/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.GenericElementModel;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Invariant(value={"getName() != null", "getSimpleName().equals(getName().getSimpleName())", "getInterfaces() != null", "!getInterfaces().contains(null)", "getSuperArguments() != null", "!getSuperArguments().contains(null)", "getSuperclass() != null || superArguments.isEmpty()", "getImportNames() != null", "!getImportNames().contains(null)", "getEnclosingElement() == null || importNames.isEmpty()"})
public class TypeModel
extends GenericElementModel {
    protected ClassName name;
    protected Set<ClassName> interfaces;
    protected ClassName superclass;
    protected List<TypeName> superArguments;
    protected Set<String> importNames;

    @Requires(value={"kind != null", "name != null", "kind.isType()"})
    public TypeModel(ElementKind kind, ClassName name) {
        super(kind, name.getSimpleName());
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$TypeModel(kind, name);
                contractContext.leaveContract();
            }
            this.name = name;
            this.interfaces = new HashSet<ClassName>();
            this.superArguments = new ArrayList<TypeName>();
            this.importNames = new HashSet<String>();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == TypeModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == TypeModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$TypeModel(ElementKind kind, ClassName name) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$TypeModel(kind, name, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$TypeModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$GenericElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$QualifiedElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ElementModel();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public TypeModel(TypeModel that) {
        super(that);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$TypeModel(that);
                contractContext.leaveContract();
            }
            this.name = that.name;
            this.interfaces = new HashSet<ClassName>(that.interfaces);
            this.superArguments = new ArrayList<TypeName>(that.superArguments);
            this.importNames = new HashSet<String>(that.importNames);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$TypeModel(that);
                if (this.getClass() == TypeModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == TypeModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$TypeModel(TypeModel that) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$TypeModel(that, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$TypeModel(TypeModel that) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$TypeModel(that);
    }

    @Override
    public TypeModel clone() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            TypeModel typeModel = new TypeModel(this);
            if (contractContext.tryEnterContract()) {
                TypeModel typeModel2;
                typeModel = typeModel2 = typeModel;
                this.com$google$java$contract$Q$clone(typeModel2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clone")
    private /* synthetic */ void com$google$java$contract$Q$clone(TypeModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$clone(result);
    }

    public ClassName getName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ClassName className = this.name;
            if (contractContext.tryEnterContract()) {
                ClassName className2;
                className = className2 = className;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return className;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"getEnclosingElement() == null", "value != null"})
    @Ensures(value={"getImportNames().contains(value)"})
    public void addImportName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void value;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addImportName(string);
                contractContext.leaveContract();
            }
            this.importNames.add((String)value);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addImportName((String)value);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addImportName")
    private /* synthetic */ void com$google$java$contract$P$addImportName(String value) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addImportName(value, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addImportName")
    private /* synthetic */ void com$google$java$contract$Q$addImportName(String value) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addImportName(value);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"getEnclosingElement() == null", "value != null"})
    @Ensures(value={"!getImportNames().contains(value)"})
    public void removeImportName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void value;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeImportName(string);
                contractContext.leaveContract();
            }
            this.importNames.remove(value);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeImportName((String)value);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeImportName")
    private /* synthetic */ void com$google$java$contract$P$removeImportName(String value) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeImportName(value, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeImportName")
    private /* synthetic */ void com$google$java$contract$Q$removeImportName(String value) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeImportName(value);
    }

    @Requires(value={"getEnclosingElement() == null"})
    public Set<String> getImportNames() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getImportNames();
                contractContext.leaveContract();
            }
            Set<String> set = Collections.unmodifiableSet(this.importNames);
            if (contractContext.tryEnterContract()) {
                Set<String> set2;
                set = set2 = set;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return set;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getImportNames")
    private /* synthetic */ void com$google$java$contract$P$getImportNames() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$getImportNames(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public ClassName getSuperclass() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ClassName className = this.superclass;
            if (contractContext.tryEnterContract()) {
                ClassName className2;
                className = className2 = className;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return className;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSuperclass(ClassName className) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void className2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.superclass = className2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result != null"})
    public List<? extends TypeName> getSuperArguments() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<TypeName> list = Collections.unmodifiableList(this.superArguments);
            if (contractContext.tryEnterContract()) {
                List<TypeName> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getSuperArguments(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getSuperArguments")
    private /* synthetic */ void com$google$java$contract$Q$getSuperArguments(List<? extends TypeName> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$getSuperArguments(result);
    }

    @Ensures(value={"getSuperArguments().isEmpty()"})
    public void clearSuperArguments() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.superArguments.clear();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$clearSuperArguments();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clearSuperArguments")
    private /* synthetic */ void com$google$java$contract$Q$clearSuperArguments() {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$clearSuperArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"typeName != null"})
    @Ensures(value={"getSuperArguments().size() == old(getSuperArguments().size()) + 1", "getSuperArguments().contains(typeName)"})
    public void addSuperArgument(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        Object object = null;
        try {
            void typeName2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addSuperArgument(typeName);
                object = this.com$google$java$contract$QO$addSuperArgument$0(typeName);
                contractContext.leaveContract();
            }
            this.superArguments.add((TypeName)typeName2);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addSuperArgument((TypeName)typeName2, object);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addSuperArgument")
    private /* synthetic */ void com$google$java$contract$P$addSuperArgument(TypeName typeName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addSuperArgument(typeName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=0, target="addSuperArgument")
    private /* synthetic */ Object com$google$java$contract$QO$addSuperArgument$0(TypeName typeName) {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$model$TypeModel$addSuperArgument$0(typeName);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addSuperArgument")
    private /* synthetic */ void com$google$java$contract$Q$addSuperArgument(TypeName typeName, Object com$google$java$contract$local$old0) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addSuperArgument(typeName, com$google$java$contract$local$old0);
    }

    public Set<? extends ClassName> getInterfaces() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Set<ClassName> set = Collections.unmodifiableSet(this.interfaces);
            if (contractContext.tryEnterContract()) {
                Set<ClassName> set2;
                set = set2 = set;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return set;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"className != null"})
    @Ensures(value={"getInterfaces().contains(className)"})
    public void addInterface(ClassName className) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void className2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addInterface(className);
                contractContext.leaveContract();
            }
            this.interfaces.add((ClassName)className2);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addInterface((ClassName)className2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addInterface")
    private /* synthetic */ void com$google$java$contract$P$addInterface(ClassName className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addInterface(className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addInterface")
    private /* synthetic */ void com$google$java$contract$Q$addInterface(ClassName className) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addInterface(className);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"className != null"})
    @Ensures(value={"!getInterfaces().contains(className)"})
    public void removeInterface(ClassName className) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void className2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeInterface(className);
                contractContext.leaveContract();
            }
            this.interfaces.remove(className2);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeInterface((ClassName)className2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeInterface")
    private /* synthetic */ void com$google$java$contract$P$removeInterface(ClassName className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeInterface(className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeInterface")
    private /* synthetic */ void com$google$java$contract$Q$removeInterface(ClassName className) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeInterface(className);
    }

    @Ensures(value={"result != null"})
    public List<? extends ContractAnnotationModel> getInvariants() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<ContractAnnotationModel> list = Elements.filter(this.enclosedElements, ContractAnnotationModel.class, ElementKind.INVARIANT);
            if (contractContext.tryEnterContract()) {
                List<ContractAnnotationModel> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getInvariants(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getInvariants")
    private /* synthetic */ void com$google$java$contract$Q$getInvariants(List<? extends ContractAnnotationModel> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$getInvariants(result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"annotation != null", "annotation.getKind() == ElementKind.INVARIANT"})
    @Ensures(value={"getEnclosedElements().contains(annotation)", "getInvariants().contains(annotation)"})
    public void addInvariant(ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addInvariant(contractAnnotationModel);
                contractContext.leaveContract();
            }
            this.addEnclosedElement((ElementModel)annotation);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addInvariant((ContractAnnotationModel)annotation);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addInvariant")
    private /* synthetic */ void com$google$java$contract$P$addInvariant(ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addInvariant(annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addInvariant")
    private /* synthetic */ void com$google$java$contract$Q$addInvariant(ContractAnnotationModel annotation) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addInvariant(annotation);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"annotation != null", "annotation.getKind() == ElementKind.INVARIANT"})
    @Ensures(value={"!getEnclosedElements().contains(annotation)", "!getInvariants().contains(annotation)"})
    public void removeInvariant(ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeInvariant(contractAnnotationModel);
                contractContext.leaveContract();
            }
            this.removeEnclosedElement((ElementModel)annotation);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeInvariant((ContractAnnotationModel)annotation);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeInvariant")
    private /* synthetic */ void com$google$java$contract$P$removeInvariant(ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeInvariant(annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeInvariant")
    private /* synthetic */ void com$google$java$contract$Q$removeInvariant(ContractAnnotationModel annotation) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeInvariant(annotation);
    }

    @Ensures(value={"result != null", "!result.contains(null)"})
    public List<? extends QualifiedElementModel> getMembers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<QualifiedElementModel> list = Elements.filter(this.enclosedElements, QualifiedElementModel.class, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.CONTRACT_METHOD, ElementKind.CONTRACT_MOCK);
            if (contractContext.tryEnterContract()) {
                List<QualifiedElementModel> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getMembers(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getMembers")
    private /* synthetic */ void com$google$java$contract$Q$getMembers(List<? extends QualifiedElementModel> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$getMembers(result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"member != null", "member.getKind().isMember()"})
    @Ensures(value={"getEnclosedElements().contains(member)", "getMembers().contains(member)"})
    public void addMember(QualifiedElementModel qualifiedElementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void member;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addMember(qualifiedElementModel);
                contractContext.leaveContract();
            }
            this.addEnclosedElement((ElementModel)member);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addMember((QualifiedElementModel)member);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addMember")
    private /* synthetic */ void com$google$java$contract$P$addMember(QualifiedElementModel member) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addMember(member, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addMember")
    private /* synthetic */ void com$google$java$contract$Q$addMember(QualifiedElementModel member) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addMember(member);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"member != null", "member.getKind().isMember()"})
    @Ensures(value={"!getEnclosedElements().contains(member)", "!getMembers().contains(member)"})
    public void removeInvariant(QualifiedElementModel qualifiedElementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void member;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeInvariant(qualifiedElementModel);
                contractContext.leaveContract();
            }
            this.removeEnclosedElement((ElementModel)member);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeInvariant((QualifiedElementModel)member);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeInvariant")
    private /* synthetic */ void com$google$java$contract$P$removeInvariant(QualifiedElementModel member) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeInvariant(member, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeInvariant")
    private /* synthetic */ void com$google$java$contract$Q$removeInvariant(QualifiedElementModel member) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeInvariant(member);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(ElementVisitor elementVisitor) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void visitor;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$accept(elementVisitor);
                contractContext.leaveContract();
            }
            visitor.visitType(this);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="accept")
    private /* synthetic */ void com$google$java$contract$P$accept(ElementVisitor visitor) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ElementModel$accept(visitor, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Override
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            EnumSet<ElementKind[]> allowed = EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.CONSTANT, ElementKind.FIELD, ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.INVARIANT, ElementKind.CONTRACT_METHOD, ElementKind.CONTRACT_MOCK});
            allowed.addAll(super.getAllowedEnclosedKinds());
            EnumSet<ElementKind[]> enumSet = allowed;
            if (contractContext.tryEnterContract()) {
                EnumSet<ElementKind[]> enumSet2;
                enumSet = enumSet2 = enumSet;
                this.com$google$java$contract$Q$getAllowedEnclosedKinds(enumSet2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return enumSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getAllowedEnclosedKinds")
    private /* synthetic */ void com$google$java$contract$Q$getAllowedEnclosedKinds(EnumSet<ElementKind> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$getAllowedEnclosedKinds(result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={39L, 40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$TypeModel() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getName() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getName() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getSimpleName().equals(this.getName().getSimpleName());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("getSimpleName().equals(getName().getSimpleName())", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.getInterfaces() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("getInterfaces() != null", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = !this.getInterfaces().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("!getInterfaces().contains(null)", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = this.getSuperArguments() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("getSuperArguments() != null", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = !this.getSuperArguments().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("!getSuperArguments().contains(null)", com$google$java$contract$local$exception$11));
        }
        boolean com$google$java$contract$local$success$6 = false;
        Throwable com$google$java$contract$local$exception$13 = null;
        try {
            com$google$java$contract$local$success$6 = this.getSuperclass() != null || this.superArguments.isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$12) {
            com$google$java$contract$local$exception$13 = com$google$java$contract$local$exception$12;
        }
        if (!com$google$java$contract$local$success$6) {
            ContractRuntime.raise(new InvariantError("getSuperclass() != null || superArguments.isEmpty()", com$google$java$contract$local$exception$13));
        }
        boolean com$google$java$contract$local$success$7 = false;
        Throwable com$google$java$contract$local$exception$15 = null;
        try {
            com$google$java$contract$local$success$7 = this.getImportNames() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$14) {
            com$google$java$contract$local$exception$15 = com$google$java$contract$local$exception$14;
        }
        if (!com$google$java$contract$local$success$7) {
            ContractRuntime.raise(new InvariantError("getImportNames() != null", com$google$java$contract$local$exception$15));
        }
        boolean com$google$java$contract$local$success$8 = false;
        Throwable com$google$java$contract$local$exception$17 = null;
        try {
            com$google$java$contract$local$success$8 = !this.getImportNames().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$16) {
            com$google$java$contract$local$exception$17 = com$google$java$contract$local$exception$16;
        }
        if (!com$google$java$contract$local$success$8) {
            ContractRuntime.raise(new InvariantError("!getImportNames().contains(null)", com$google$java$contract$local$exception$17));
        }
        boolean com$google$java$contract$local$success$9 = false;
        Throwable com$google$java$contract$local$exception$19 = null;
        try {
            com$google$java$contract$local$success$9 = this.getEnclosingElement() == null || this.importNames.isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$18) {
            com$google$java$contract$local$exception$19 = com$google$java$contract$local$exception$18;
        }
        if (!com$google$java$contract$local$success$9) {
            ContractRuntime.raise(new InvariantError("getEnclosingElement() == null || importNames.isEmpty()", com$google$java$contract$local$exception$19));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={82L, 83L, 84L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$TypeModel(ElementKind kind, ClassName name, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = kind.isType();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("kind.isType()", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={98L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$TypeModel(TypeModel that, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={99L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$TypeModel(TypeModel that) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosingElement() == null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addImportName", lines={118L, 119L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addImportName(String value, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("getEnclosingElement() == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = value != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("value != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addImportName", lines={121L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addImportName(String value) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getImportNames().contains(value);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getImportNames().contains(value)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeImportName", lines={127L, 128L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeImportName(String value, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("getEnclosingElement() == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = value != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("value != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeImportName", lines={130L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeImportName(String value) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getImportNames().contains(value);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getImportNames().contains(value)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getImportNames", lines={135L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$getImportNames(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("getEnclosingElement() == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getSuperArguments", lines={148L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$getSuperArguments(List<? extends TypeName> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="clearSuperArguments", lines={153L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$clearSuperArguments() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getSuperArguments().isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getSuperArguments().isEmpty()", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addSuperArgument", lines={158L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addSuperArgument(TypeName typeName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = typeName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("typeName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addSuperArgument", lines={160L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$model$TypeModel$addSuperArgument$0(TypeName typeName) {
        return this.getSuperArguments().size();
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addSuperArgument", lines={160L, 161L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addSuperArgument(TypeName typeName, Object com$google$java$contract$local$old0) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getSuperArguments().size() == ContractRuntime.magicCast(com$google$java$contract$local$old0, null) + 1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getSuperArguments().size() == old(getSuperArguments().size()) + 1", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getSuperArguments().contains(typeName);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getSuperArguments().contains(typeName)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addInterface", lines={171L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addInterface(ClassName className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = className != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("className != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addInterface", lines={172L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addInterface(ClassName className) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getInterfaces().contains(className);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getInterfaces().contains(className)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeInterface", lines={177L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeInterface(ClassName className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = className != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("className != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeInterface", lines={178L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeInterface(ClassName className) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getInterfaces().contains(className);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getInterfaces().contains(className)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getInvariants", lines={183L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$getInvariants(List<? extends ContractAnnotationModel> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addInvariant", lines={190L, 191L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addInvariant(ContractAnnotationModel annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation.getKind() == ElementKind.INVARIANT;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation.getKind() == ElementKind.INVARIANT", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addInvariant", lines={194L, 195L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addInvariant(ContractAnnotationModel annotation) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosedElements().contains(annotation);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosedElements().contains(annotation)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getInvariants().contains(annotation);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getInvariants().contains(annotation)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeInvariant", lines={202L, 203L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeInvariant(ContractAnnotationModel annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation.getKind() == ElementKind.INVARIANT;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation.getKind() == ElementKind.INVARIANT", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeInvariant", lines={206L, 207L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeInvariant(ContractAnnotationModel annotation) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getEnclosedElements().contains(annotation);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getEnclosedElements().contains(annotation)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.getInvariants().contains(annotation);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!getInvariants().contains(annotation)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getMembers", lines={214L, 215L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$getMembers(List<? extends QualifiedElementModel> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !result.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!result.contains(null)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addMember", lines={231L, 232L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$addMember(QualifiedElementModel member, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = member != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("member != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = member.getKind().isMember();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("member.getKind().isMember()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addMember", lines={235L, 236L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$addMember(QualifiedElementModel member) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosedElements().contains(member);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosedElements().contains(member)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getMembers().contains(member);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getMembers().contains(member)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeInvariant", lines={243L, 244L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$TypeModel$removeInvariant(QualifiedElementModel member, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = member != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("member != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = member.getKind().isMember();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("member.getKind().isMember()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeInvariant", lines={247L, 248L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$TypeModel$removeInvariant(QualifiedElementModel member) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getEnclosedElements().contains(member);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getEnclosedElements().contains(member)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.getMembers().contains(member);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!getMembers().contains(member)", com$google$java$contract$local$exception$3));
        }
    }
}

