/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

@Invariant(value={"getContractKind() != null", "getId() >= -1", "getStatements() != null", "!getStatements().contains(null)", "!getContractKind().isClassContract() || getContractedMethod() == null", "!getContractKind().isMethodContract() || getContractedMethod() != null"})
public class ContractMethodModel
extends MethodModel {
    private static final ClassName CONTRACT_SIGNATURE_CLASS;
    protected ContractKind contractKind;
    protected int id;
    protected List<String> statements;
    protected String prologue;
    protected String epilogue;
    protected MethodModel contractedMethod;
    protected List<Long> lineNumbers;

    @Requires(value={"kind != null", "name != null", "returnType != null", "!kind.isClassContract() || contracted == null"})
    public ContractMethodModel(ContractKind kind, String name, TypeName returnType, MethodModel contracted) {
        super(ElementKind.CONTRACT_METHOD, name, returnType);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractMethodModel(kind, name, returnType, contracted);
                contractContext.leaveContract();
            }
            if (contracted != null) {
                this.typeParameters = new ArrayList<TypeName>(contracted.getTypeParameters());
                Elements.copyParameters(this, contracted.getParameters());
                this.modifiers = EnumSet.copyOf(contracted.getModifiers());
            }
            this.fixCommonModifiers();
            this.contractKind = kind;
            this.id = -1;
            this.statements = new ArrayList<String>();
            this.prologue = null;
            this.epilogue = null;
            this.contractedMethod = contracted;
            this.lineNumbers = null;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractMethodModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractMethodModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractMethodModel(ContractKind kind, String name, TypeName returnType, MethodModel contracted) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ContractMethodModel$ContractMethodModel(kind, name, returnType, contracted, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ContractMethodModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$MethodModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$GenericElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$QualifiedElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ElementModel();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public ContractMethodModel(ContractMethodModel that) {
        super(that);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractMethodModel(that);
                contractContext.leaveContract();
            }
            this.contractKind = that.contractKind;
            this.id = that.id;
            this.statements = new ArrayList<String>(that.statements);
            this.prologue = that.prologue;
            this.epilogue = that.epilogue;
            this.contractedMethod = that.contractedMethod;
            this.lineNumbers = that.lineNumbers;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ContractMethodModel(that);
                if (this.getClass() == ContractMethodModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractMethodModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractMethodModel(ContractMethodModel that) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ContractMethodModel$ContractMethodModel(that, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$ContractMethodModel(ContractMethodModel that) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$ContractMethodModel(that);
    }

    @Override
    public ContractMethodModel clone() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ContractMethodModel contractMethodModel = new ContractMethodModel(this);
            if (contractContext.tryEnterContract()) {
                ContractMethodModel contractMethodModel2;
                contractMethodModel = contractMethodModel2 = contractMethodModel;
                this.com$google$java$contract$Q$clone(contractMethodModel2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractMethodModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clone")
    private /* synthetic */ void com$google$java$contract$Q$clone(ContractMethodModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$clone(result);
    }

    private void fixCommonModifiers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.removeModifier(ElementModifier.ABSTRACT);
            this.removeModifier(ElementModifier.TRANSIENT);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public ContractKind getContractKind() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ContractKind contractKind = this.contractKind;
            if (contractContext.tryEnterContract()) {
                ContractKind contractKind2;
                contractKind = contractKind2 = contractKind;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public int getId() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            int n = this.id;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setId(int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void id;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.id = id;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public MethodModel getContractedMethod() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            MethodModel methodModel = this.contractedMethod;
            if (contractContext.tryEnterContract()) {
                MethodModel methodModel2;
                methodModel = methodModel2 = methodModel;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return methodModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public List<Long> getLineNumbers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<Long> list = this.lineNumbers;
            if (contractContext.tryEnterContract()) {
                List<Long> list2;
                list = list2 = list;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Ensures(value={"lineNumbers == getLineNumbers()"})
    public void setLineNumbers(List<Long> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void lineNumbers;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.lineNumbers = lineNumbers;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$setLineNumbers((List<Long>)lineNumbers);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="setLineNumbers")
    private /* synthetic */ void com$google$java$contract$Q$setLineNumbers(List<Long> lineNumbers) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$setLineNumbers(lineNumbers);
    }

    @Ensures(value={"result != null"})
    public String getCode() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            if (this.prologue != null) {
                buffer.append(this.prologue);
            }
            for (String stmt : this.statements) {
                buffer.append(stmt);
            }
            if (this.epilogue != null) {
                buffer.append(this.epilogue);
            }
            String string = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                this.com$google$java$contract$Q$getCode(string2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getCode")
    private /* synthetic */ void com$google$java$contract$Q$getCode(String result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$getCode(result);
    }

    public List<String> getStatements() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<String> list = Collections.unmodifiableList(this.statements);
            if (contractContext.tryEnterContract()) {
                List<String> list2;
                list = list2 = list;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public String getPrologue() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.prologue;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Ensures(value={"getPrologue().equals(prologue)"})
    public void setPrologue(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void prologue;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.prologue = prologue;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$setPrologue((String)prologue);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="setPrologue")
    private /* synthetic */ void com$google$java$contract$Q$setPrologue(String prologue) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$setPrologue(prologue);
    }

    public String getEpilogue() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.epilogue;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Ensures(value={"getEpilogue().equals(epilogue)"})
    public void setEpilogue(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void epilogue;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.epilogue = epilogue;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$setEpilogue((String)epilogue);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="setEpilogue")
    private /* synthetic */ void com$google$java$contract$Q$setEpilogue(String epilogue) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$setEpilogue(epilogue);
    }

    @Ensures(value={"getStatements().isEmpty()"})
    public void clearStatements() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.statements.clear();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$clearStatements();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clearStatements")
    private /* synthetic */ void com$google$java$contract$Q$clearStatements() {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$clearStatements();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"stmt != null"})
    @Ensures(value={"getStatements().size() == old(getStatements().size()) + 1", "getStatements().contains(stmt)"})
    public void addStatement(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        Object object = null;
        try {
            void stmt;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addStatement(string);
                object = this.com$google$java$contract$QO$addStatement$0(string);
                contractContext.leaveContract();
            }
            this.statements.add((String)stmt);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addStatement((String)stmt, object);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addStatement")
    private /* synthetic */ void com$google$java$contract$P$addStatement(String stmt) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ContractMethodModel$addStatement(stmt, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=0, target="addStatement")
    private /* synthetic */ Object com$google$java$contract$QO$addStatement$0(String stmt) {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$model$ContractMethodModel$addStatement$0(stmt);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addStatement")
    private /* synthetic */ void com$google$java$contract$Q$addStatement(String stmt, Object com$google$java$contract$local$old0) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$addStatement(stmt, com$google$java$contract$local$old0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(ElementVisitor elementVisitor) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void visitor;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$accept(elementVisitor);
                contractContext.leaveContract();
            }
            visitor.visitContractMethod(this);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="accept")
    private /* synthetic */ void com$google$java$contract$P$accept(ElementVisitor visitor) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ElementModel$accept(visitor, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Override
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            EnumSet<ElementKind> allowed = EnumSet.of(ElementKind.CONTRACT_SIGNATURE);
            allowed.addAll(super.getAllowedEnclosedKinds());
            EnumSet<ElementKind> enumSet = allowed;
            if (contractContext.tryEnterContract()) {
                EnumSet<ElementKind> enumSet2;
                enumSet = enumSet2 = enumSet;
                this.com$google$java$contract$Q$getAllowedEnclosedKinds(enumSet2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return enumSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getAllowedEnclosedKinds")
    private /* synthetic */ void com$google$java$contract$Q$getAllowedEnclosedKinds(EnumSet<ElementKind> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$getAllowedEnclosedKinds(result);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodModel.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            CONTRACT_SIGNATURE_CLASS = new ClassName("com/google/java/contract/core/ContractMethodSignature");
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodModel.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodModel.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={37L, 38L, 39L, 40L, 41L, 42L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$ContractMethodModel() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getContractKind() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getContractKind() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getId() >= -1;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("getId() >= -1", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.getStatements() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("getStatements() != null", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = !this.getStatements().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("!getStatements().contains(null)", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = !this.getContractKind().isClassContract() || this.getContractedMethod() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("!getContractKind().isClassContract() || getContractedMethod() == null", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = !this.getContractKind().isMethodContract() || this.getContractedMethod() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("!getContractKind().isMethodContract() || getContractedMethod() != null", com$google$java$contract$local$exception$11));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={94L, 95L, 96L, 97L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ContractMethodModel$ContractMethodModel(ContractKind kind, String name, TypeName returnType, MethodModel contracted, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = returnType != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("returnType != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = !kind.isClassContract() || contracted == null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("!kind.isClassContract() || contracted == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={125L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ContractMethodModel$ContractMethodModel(ContractMethodModel that, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={126L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$ContractMethodModel(ContractMethodModel that) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosingElement() == null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setLineNumbers", lines={175L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$setLineNumbers(List<Long> lineNumbers) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = lineNumbers == this.getLineNumbers();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("lineNumbers == getLineNumbers()", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getCode", lines={180L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$getCode(String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setPrologue", lines={203L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$setPrologue(String prologue) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getPrologue().equals(prologue);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getPrologue().equals(prologue)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setEpilogue", lines={212L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$setEpilogue(String epilogue) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEpilogue().equals(epilogue);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEpilogue().equals(epilogue)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="clearStatements", lines={217L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$clearStatements() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getStatements().isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getStatements().isEmpty()", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addStatement", lines={222L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ContractMethodModel$addStatement(String stmt, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = stmt != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("stmt != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addStatement", lines={224L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$model$ContractMethodModel$addStatement$0(String stmt) {
        return this.getStatements().size();
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addStatement", lines={224L, 225L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractMethodModel$addStatement(String stmt, Object com$google$java$contract$local$old0) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getStatements().size() == ContractRuntime.magicCast(com$google$java$contract$local$old0, null) + 1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getStatements().size() == old(getStatements().size()) + 1", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getStatements().contains(stmt);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getStatements().contains(stmt)", com$google$java$contract$local$exception$3));
        }
    }
}

