/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.util.Predicate;

@Invariant(value={"isSimpleName(getSimpleName())", "isQualifiedName(getQualifiedName())", "isQualifiedName(getSemiQualifiedName())", "isBinaryName(getBinaryName())"})
public class ClassName
extends TypeName {
    protected String simpleName;
    protected String qualifiedName;
    protected String semiQualifiedName;
    protected String binaryName;
    protected static final Predicate<String> IS_SIMPLE_NAME;
    private static final Predicate<String> IS_QUALIFIED_NAME;
    private static final Predicate<String> IS_BINARY_NAME;

    @Requires(value={"isBinaryName(binaryName)"})
    @Ensures(value={"binaryName.equals(getBinaryName())"})
    public ClassName(String binaryName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ClassName(binaryName);
                contractContext.leaveContract();
            }
            this.binaryName = binaryName;
            this.simpleName = null;
            this.inferSemiQualifiedName();
            this.inferQualifiedName();
            this.inferSimpleName();
            this.declaredName = this.qualifiedName;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ClassName(binaryName);
                if (this.getClass() == ClassName.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ClassName.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ClassName(String binaryName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$ClassName(binaryName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$ClassName(String binaryName) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$ClassName(binaryName);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ClassName();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$TypeName();
    }

    @Requires(value={"isBinaryName(binaryName)", "declaredName != null"})
    @Ensures(value={"binaryName.equals(getBinaryName())", "declaredName.equals(getDeclaredName())"})
    public ClassName(String binaryName, String declaredName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ClassName(binaryName, declaredName);
                contractContext.leaveContract();
            }
            this.binaryName = binaryName;
            this.declaredName = declaredName;
            this.simpleName = null;
            this.inferSemiQualifiedName();
            this.inferQualifiedName();
            this.inferSimpleName();
            this.assertDeclaredQualifiedMatch();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ClassName(binaryName, declaredName);
                if (this.getClass() == ClassName.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ClassName.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ClassName(String binaryName, String declaredName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$ClassName(binaryName, declaredName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$ClassName(String binaryName, String declaredName) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$ClassName(binaryName, declaredName);
    }

    @Requires(value={"binaryName != null", "declaredName != null", "simpleName != null", "binaryName.endsWith(simpleName)"})
    @Ensures(value={"binaryName.equals(getBinaryName())", "declaredName.equals(getDeclaredName())", "simpleName.equals(getSimpleName())"})
    public ClassName(String binaryName, String declaredName, String simpleName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ClassName(binaryName, declaredName, simpleName);
                contractContext.leaveContract();
            }
            this.binaryName = binaryName;
            this.declaredName = declaredName;
            this.simpleName = simpleName;
            this.inferSemiQualifiedName();
            this.inferQualifiedName();
            this.assertDeclaredQualifiedMatch();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ClassName(binaryName, declaredName, simpleName);
                if (this.getClass() == ClassName.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ClassName.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ClassName(String binaryName, String declaredName, String simpleName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$ClassName(binaryName, declaredName, simpleName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$ClassName(String binaryName, String declaredName, String simpleName) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$ClassName(binaryName, declaredName, simpleName);
    }

    protected void assertDeclaredQualifiedMatch() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (!this.declaredName.replaceAll("<[^.]*>", "").startsWith(this.qualifiedName)) {
                throw new IllegalArgumentException("declared name '" + this.declaredName + "' does not match qualified name '" + this.qualifiedName + "'");
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public String getSimpleName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.simpleName;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Requires(value={"pathName != null"})
    @Ensures(value={"result != null"})
    public static String getRelativeName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            String pathName;
            int lastSep;
            if (contractContext.tryEnterContract()) {
                ClassName.com$google$java$contract$P$getRelativeName(string);
                contractContext.leaveContract();
            }
            if ((lastSep = pathName.lastIndexOf(46)) == -1) {
                String string2 = pathName;
                if (contractContext.tryEnterContract()) {
                    String string3;
                    string2 = string3 = string2;
                    ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$getRelativeName(pathName, string3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return string2;
            }
            String string4 = pathName.substring(lastSep + 1);
            if (contractContext.tryEnterContract()) {
                String string5;
                string4 = string5 = string4;
                ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$getRelativeName(pathName, string5);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return string4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getRelativeName")
    private static /* synthetic */ void com$google$java$contract$P$getRelativeName(String pathName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ClassName.com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$getRelativeName(pathName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"pathName != null"})
    @Ensures(value={"result != null"})
    public static String getPackageName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            String pathName;
            int lastSep;
            if (contractContext.tryEnterContract()) {
                ClassName.com$google$java$contract$P$getPackageName(string);
                contractContext.leaveContract();
            }
            if ((lastSep = pathName.lastIndexOf(46)) == -1) {
                String string2 = "";
                if (contractContext.tryEnterContract()) {
                    String string3;
                    string2 = string3 = string2;
                    ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$getPackageName(pathName, string3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return string2;
            }
            String string4 = pathName.substring(0, lastSep);
            if (contractContext.tryEnterContract()) {
                String string5;
                string4 = string5 = string4;
                ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$getPackageName(pathName, string5);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return string4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getPackageName")
    private static /* synthetic */ void com$google$java$contract$P$getPackageName(String pathName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ClassName.com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$getPackageName(pathName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public String getQualifiedName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.qualifiedName;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public String getSemiQualifiedName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.semiQualifiedName;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public String getBinaryName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.binaryName;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    private void inferSemiQualifiedName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.semiQualifiedName = this.binaryName.replace('/', '.');
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    private void inferQualifiedName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.simpleName == null) {
                this.qualifiedName = this.semiQualifiedName.replace('$', '.');
            } else {
                int prefixLength = this.semiQualifiedName.length() - this.simpleName.length();
                String prefix = this.semiQualifiedName.substring(0, prefixLength);
                this.qualifiedName = prefix.replace('$', '.') + this.simpleName;
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    private void inferSimpleName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            int i;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.simpleName = (i = this.qualifiedName.lastIndexOf(46)) == -1 ? this.qualifiedName : this.qualifiedName.substring(i + 1);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void obj;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = obj instanceof ClassName && this.binaryName.equals(((ClassName)obj).binaryName) && this.declaredName.equals(((ClassName)obj).declaredName);
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public int hashCode() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            int n = this.binaryName.hashCode() ^ this.declaredName.hashCode();
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public static boolean isSimpleName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            String name;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (name == null || name.isEmpty()) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl2;
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl4;
            }
            int len = name.length();
            for (int i = 1; i < len; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                boolean bl6 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl7;
                    bl6 = bl7 = bl6;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl6;
            }
            boolean bl8 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl9;
                bl8 = bl9 = bl8;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return bl8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    public static Predicate<String> isSimpleName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            Predicate<String> predicate = IS_SIMPLE_NAME;
            if (contractContext.tryEnterContract()) {
                Predicate<String> predicate2;
                predicate = predicate2 = predicate;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return predicate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result == isBinaryName(name.replace('.', '/'))"})
    public static boolean isQualifiedName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            String[] parts;
            String name;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (name == null || name.isEmpty()) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isQualifiedName(name, bl3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl2;
            }
            for (String part : parts = name.split("\\.")) {
                if (ClassName.isSimpleName(part)) continue;
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isQualifiedName(name, bl5);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl4;
            }
            boolean bl6 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl7;
                bl6 = bl7 = bl6;
                ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isQualifiedName(name, bl7);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    public static Predicate<String> isQualifiedName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            Predicate<String> predicate = IS_QUALIFIED_NAME;
            if (contractContext.tryEnterContract()) {
                Predicate<String> predicate2;
                predicate = predicate2 = predicate;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return predicate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    public static boolean isStarQualifiedName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            String name;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            boolean bl2 = name != null && name.endsWith(".*") && ClassName.isQualifiedName(name.substring(0, name.length() - 2));
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result == isQualifiedName(name.replace('/', '.'))"})
    public static boolean isBinaryName(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            String[] parts;
            String name;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (name == null || name.isEmpty()) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isBinaryName(name, bl3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl2;
            }
            for (String part : parts = name.split("/")) {
                if (ClassName.isSimpleName(part)) continue;
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isBinaryName(name, bl5);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ClassName.class);
                }
                return bl4;
            }
            boolean bl6 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl7;
                bl6 = bl7 = bl6;
                ClassName.com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isBinaryName(name, bl7);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    public static Predicate<String> isBinaryName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            Predicate<String> predicate = IS_BINARY_NAME;
            if (contractContext.tryEnterContract()) {
                Predicate<String> predicate2;
                predicate = predicate2 = predicate;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return predicate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ClassName.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            IS_SIMPLE_NAME = new Predicate<String>(){

                @Override
                public boolean apply(String name) {
                    return ClassName.isSimpleName(name);
                }
            };
            IS_QUALIFIED_NAME = new Predicate<String>(){

                @Override
                public boolean apply(String name) {
                    return ClassName.isQualifiedName(name);
                }
            };
            IS_BINARY_NAME = new Predicate<String>(){

                @Override
                public boolean apply(String name) {
                    return ClassName.isBinaryName(name);
                }
            };
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ClassName.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={46L, 47L, 48L, 49L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$ClassName() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isSimpleName(this.getSimpleName());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("isSimpleName(getSimpleName())", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = ClassName.isQualifiedName(this.getQualifiedName());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("isQualifiedName(getQualifiedName())", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = ClassName.isQualifiedName(this.getSemiQualifiedName());
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("isQualifiedName(getSemiQualifiedName())", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = ClassName.isBinaryName(this.getBinaryName());
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("isBinaryName(getBinaryName())", com$google$java$contract$local$exception$7));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={62L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$ClassName(String binaryName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isBinaryName(binaryName);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("isBinaryName(binaryName)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={63L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$ClassName(String binaryName) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = binaryName.equals(this.getBinaryName());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("binaryName.equals(getBinaryName())", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={79L, 80L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$ClassName(String binaryName, String declaredName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isBinaryName(binaryName);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("isBinaryName(binaryName)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = declaredName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("declaredName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={83L, 84L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$ClassName(String binaryName, String declaredName) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = binaryName.equals(this.getBinaryName());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("binaryName.equals(getBinaryName())", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = declaredName.equals(this.getDeclaredName());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("declaredName.equals(getDeclaredName())", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={97L, 98L, 99L, 100L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$ClassName(String binaryName, String declaredName, String simpleName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = binaryName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("binaryName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = declaredName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("declaredName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = simpleName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("simpleName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = binaryName.endsWith(simpleName);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("binaryName.endsWith(simpleName)", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={103L, 104L, 105L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$ClassName(String binaryName, String declaredName, String simpleName) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = binaryName.equals(this.getBinaryName());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("binaryName.equals(getBinaryName())", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = declaredName.equals(this.getDeclaredName());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("declaredName.equals(getDeclaredName())", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = simpleName.equals(this.getSimpleName());
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("simpleName.equals(getSimpleName())", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getRelativeName", lines={133L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$getRelativeName(String pathName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pathName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pathName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getRelativeName", lines={134L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$getRelativeName(String pathName, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getPackageName", lines={149L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ClassName$getPackageName(String pathName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pathName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pathName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getPackageName", lines={150L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$getPackageName(String pathName, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isQualifiedName", lines={246L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isQualifiedName(String name, boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == ClassName.isBinaryName(name.replace('.', '/'));
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == isBinaryName(name.replace('.', '/'))", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isBinaryName", lines={286L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ClassName$isBinaryName(String name, boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == ClassName.isQualifiedName(name.replace('/', '.'));
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == isQualifiedName(name.replace('/', '.'))", com$google$java$contract$local$exception$1));
        }
    }
}

