/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.apt.TypeBuilder;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.JavaUtils;
import java.net.URLClassLoader;
import javax.lang.model.element.TypeElement;

class TypeFactory {
    protected URLClassLoader sourceDependencyLoader;
    protected FactoryUtils utils;

    @Requires(value={"utils != null"})
    TypeFactory(FactoryUtils utils, String sourceDependencyPath) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$TypeFactory(utils, sourceDependencyPath);
                contractContext.leaveContract();
            }
            this.sourceDependencyLoader = null;
            if (sourceDependencyPath != null) {
                this.sourceDependencyLoader = JavaUtils.getLoaderForPath(sourceDependencyPath);
            }
            this.utils = utils;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$TypeFactory(FactoryUtils utils, String sourceDependencyPath) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$TypeFactory$TypeFactory(utils, sourceDependencyPath, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"element != null", "diagnosticManager != null"})
    @Ensures(value={"result != null", "result.getName().getQualifiedName().equals(element.getQualifiedName().toString())"})
    TypeModel createType(TypeElement typeElement, DiagnosticManager diagnosticManager) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void diagnosticManager2;
            void element;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$createType(typeElement, diagnosticManager);
                contractContext.leaveContract();
            }
            String name = this.utils.elementUtils.getBinaryName((TypeElement)element).toString().replace('.', '/');
            TypeBuilder visitor = new TypeBuilder(this.utils, this.sourceDependencyLoader, (DiagnosticManager)diagnosticManager2);
            element.accept(visitor, null);
            TypeModel typeModel = visitor.getType();
            if (contractContext.tryEnterContract()) {
                TypeModel typeModel2;
                typeModel = typeModel2 = typeModel;
                this.com$google$java$contract$Q$createType((TypeElement)element, (DiagnosticManager)diagnosticManager2, typeModel2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createType")
    private /* synthetic */ void com$google$java$contract$P$createType(TypeElement element, DiagnosticManager diagnosticManager) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$TypeFactory$createType(element, diagnosticManager, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="createType")
    private /* synthetic */ void com$google$java$contract$Q$createType(TypeElement element, DiagnosticManager diagnosticManager, TypeModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$TypeFactory$createType(element, diagnosticManager, result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={45L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$TypeFactory$TypeFactory(FactoryUtils utils, String sourceDependencyPath, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = utils != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("utils != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createType", lines={62L, 63L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$TypeFactory$createType(TypeElement element, DiagnosticManager diagnosticManager, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("diagnosticManager != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createType", lines={66L, 67L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$TypeFactory$createType(TypeElement element, DiagnosticManager diagnosticManager, TypeModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result.getName().getQualifiedName().equals(element.getQualifiedName().toString());
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result.getName().getQualifiedName().equals(element.getQualifiedName().toString())", com$google$java$contract$local$exception$3));
        }
    }
}

