/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

class JavacUtils {
    JavacUtils() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"processingEnv != null", "element != null", "annotation != null"})
    @Ensures(value={"result != null"})
    public static List<Long> getLineNumbers(ProcessingEnvironment processingEnvironment, Element element, AnnotationMirror annotationMirror) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavacUtils.class);
        try {
            void annotation;
            void element2;
            ProcessingEnvironment processingEnv;
            Trees treeUtils;
            if (contractContext.tryEnterContract()) {
                JavacUtils.com$google$java$contract$P$getLineNumbers(processingEnvironment, element, annotationMirror);
                contractContext.leaveContract();
            }
            if ((treeUtils = Trees.instance(processingEnv)) == null) {
                List<Long> list = Collections.emptyList();
                if (contractContext.tryEnterContract()) {
                    List<Long> list2;
                    list = list2 = list;
                    JavacUtils.com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getLineNumbers(processingEnv, (Element)element2, (AnnotationMirror)annotation, list2);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavacUtils.class);
                }
                return list;
            }
            TreePath path = treeUtils.getPath((Element)element2, (AnnotationMirror)annotation);
            if (path == null) {
                List<Long> list = Collections.emptyList();
                if (contractContext.tryEnterContract()) {
                    List<Long> list3;
                    list = list3 = list;
                    JavacUtils.com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getLineNumbers(processingEnv, (Element)element2, (AnnotationMirror)annotation, list3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavacUtils.class);
                }
                return list;
            }
            CompilationUnitTree unitTree = path.getCompilationUnit();
            LineMap lineMap = unitTree.getLineMap();
            SourcePositions positions = treeUtils.getSourcePositions();
            AnnotationTree annotationTree = (AnnotationTree)path.getLeaf();
            AssignmentTree assignTree = (AssignmentTree)annotationTree.getArguments().get(0);
            ExpressionTree exprTree = assignTree.getExpression();
            ArrayList<Long> lines = new ArrayList<Long>();
            if (exprTree.getKind() == Tree.Kind.STRING_LITERAL) {
                long pos = positions.getStartPosition(unitTree, exprTree);
                lines.add(lineMap.getLineNumber(pos));
            } else {
                NewArrayTree valuesTree = (NewArrayTree)exprTree;
                for (ExpressionTree expressionTree : valuesTree.getInitializers()) {
                    long pos = positions.getStartPosition(unitTree, expressionTree);
                    lines.add(lineMap.getLineNumber(pos));
                }
            }
            ArrayList<Long> arrayList = lines;
            if (contractContext.tryEnterContract()) {
                ArrayList<Long> arrayList2;
                arrayList = arrayList2 = arrayList;
                JavacUtils.com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getLineNumbers(processingEnv, (Element)element2, (AnnotationMirror)annotation, arrayList2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavacUtils.class);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavacUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getLineNumbers")
    private static /* synthetic */ void com$google$java$contract$P$getLineNumbers(ProcessingEnvironment processingEnv, Element element, AnnotationMirror annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavacUtils.com$google$java$contract$PH$com$google$java$contract$core$apt$JavacUtils$getLineNumbers(processingEnv, element, annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"processingEnv != null", "element != null"})
    @Ensures(value={"result != null"})
    public static Set<String> getImportNames(ProcessingEnvironment processingEnvironment, Element element) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavacUtils.class);
        try {
            void element2;
            ProcessingEnvironment processingEnv;
            Trees treeUtils;
            if (contractContext.tryEnterContract()) {
                JavacUtils.com$google$java$contract$P$getImportNames(processingEnvironment, element);
                contractContext.leaveContract();
            }
            if ((treeUtils = Trees.instance(processingEnv)) == null) {
                Set<String> set = Collections.emptySet();
                if (contractContext.tryEnterContract()) {
                    Set<String> set2;
                    set = set2 = set;
                    JavacUtils.com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getImportNames(processingEnv, (Element)element2, set2);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavacUtils.class);
                }
                return set;
            }
            TreePath path = treeUtils.getPath((Element)element2);
            if (path == null) {
                Set<String> set = Collections.emptySet();
                if (contractContext.tryEnterContract()) {
                    Set<String> set3;
                    set = set3 = set;
                    JavacUtils.com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getImportNames(processingEnv, (Element)element2, set3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavacUtils.class);
                }
                return set;
            }
            CompilationUnitTree unitTree = path.getCompilationUnit();
            HashSet<String> importNames = new HashSet<String>();
            for (ImportTree importTree : unitTree.getImports()) {
                StringBuilder buffer = new StringBuilder();
                if (importTree.isStatic()) {
                    buffer.append("static ");
                }
                buffer.append(importTree.getQualifiedIdentifier().toString());
                importNames.add(buffer.toString());
            }
            HashSet<String> hashSet = importNames;
            if (contractContext.tryEnterContract()) {
                HashSet<String> hashSet2;
                hashSet = hashSet2 = hashSet;
                JavacUtils.com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getImportNames(processingEnv, (Element)element2, hashSet2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavacUtils.class);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavacUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getImportNames")
    private static /* synthetic */ void com$google$java$contract$P$getImportNames(ProcessingEnvironment processingEnv, Element element) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavacUtils.com$google$java$contract$PH$com$google$java$contract$core$apt$JavacUtils$getImportNames(processingEnv, element, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={54L, 55L, 56L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$JavacUtils$getLineNumbers(ProcessingEnvironment processingEnv, Element element, AnnotationMirror annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = processingEnv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("processingEnv != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={58L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getLineNumbers(ProcessingEnvironment processingEnv, Element element, AnnotationMirror annotation, List<Long> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getImportNames", lines={100L, 101L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$JavacUtils$getImportNames(ProcessingEnvironment processingEnv, Element element, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = processingEnv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("processingEnv != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getImportNames", lines={103L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$JavacUtils$getImportNames(ProcessingEnvironment processingEnv, Element element, Set<String> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }
}

