/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.JavaUtils;
import com.google.java.contract.core.util.SyntheticJavaFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class DiagnosticManager
implements DiagnosticListener<JavaFileObject>,
Iterable<Report> {
    protected List<Report> reports;
    protected int errorCount;

    public DiagnosticManager() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.reports = new ArrayList<Report>();
            this.errorCount = 0;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public boolean hasErrors() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            boolean bl2 = this.errorCount != 0;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result >= 0"})
    public int getErrorCount() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            int n = this.errorCount;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                this.com$google$java$contract$Q$getErrorCount(n2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getErrorCount")
    private /* synthetic */ void com$google$java$contract$Q$getErrorCount(int result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$DiagnosticManager$getErrorCount(result);
    }

    @Ensures(value={"result >= 0"})
    public int getCount() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            int n = this.reports.size();
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                this.com$google$java$contract$Q$getCount(n2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getCount")
    private /* synthetic */ void com$google$java$contract$Q$getCount(int result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$DiagnosticManager$getCount(result);
    }

    @Override
    public Iterator<Report> iterator() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            Iterator<Report> iterator = this.reports.iterator();
            if (contractContext.tryEnterContract()) {
                Iterator<Report> iterator2;
                iterator = iterator2 = iterator;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return iterator;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"r != null"})
    public void report(Report report) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void r;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$report(report);
                contractContext.leaveContract();
            }
            if (r.getKind() == Diagnostic.Kind.ERROR) {
                ++this.errorCount;
            }
            this.reports.add((Report)r);
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="report")
    private /* synthetic */ void com$google$java$contract$P$report(Report r) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$report(r, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void diagnostic2;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (diagnostic2.getKind() != Diagnostic.Kind.ERROR) {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            this.report(new CompilerReport((Diagnostic<? extends JavaFileObject>)diagnostic2));
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void error(String string, String string2, int n, int n2, int n3, Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void info;
            void endPosition;
            void startPosition;
            void position;
            void sourceString;
            void message;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.report(new AnnotationReport(Diagnostic.Kind.ERROR, (String)message, (String)sourceString, (int)position, (int)startPosition, (int)endPosition, info));
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void error(String string, String string2, int n, int n2, int n3, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotationValue2;
            void annotationMirror2;
            void sourceElement;
            void endPosition;
            void startPosition;
            void position;
            void sourceString;
            void message;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.report(new AnnotationReport(Diagnostic.Kind.ERROR, (String)message, (String)sourceString, (int)position, (int)startPosition, (int)endPosition, (Element)sourceElement, (AnnotationMirror)annotationMirror2, (AnnotationValue)annotationValue2));
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void warning(String string, String string2, int n, int n2, int n3, Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void info;
            void endPosition;
            void startPosition;
            void position;
            void sourceString;
            void message;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.report(new AnnotationReport(Diagnostic.Kind.WARNING, (String)message, (String)sourceString, (int)position, (int)startPosition, (int)endPosition, info));
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void warning(String string, String string2, int n, int n2, int n3, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotationValue2;
            void annotationMirror2;
            void sourceElement;
            void endPosition;
            void startPosition;
            void position;
            void sourceString;
            void message;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.report(new AnnotationReport(Diagnostic.Kind.WARNING, (String)message, (String)sourceString, (int)position, (int)startPosition, (int)endPosition, (Element)sourceElement, (AnnotationMirror)annotationMirror2, (AnnotationValue)annotationValue2));
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getErrorCount", lines={446L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$DiagnosticManager$getErrorCount(int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= 0", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getCount", lines={451L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$DiagnosticManager$getCount(int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= 0", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="report", lines={464L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$report(Report r, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = r != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("r != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @Invariant(value={"diagnostic != null"})
    public class CompilerReport
    extends Report {
        protected Diagnostic<? extends JavaFileObject> diagnostic;

        @Requires(value={"diagnostic != null"})
        public CompilerReport(Diagnostic<? extends JavaFileObject> diagnostic) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                this.diagnostic = diagnostic;
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == CompilerReport.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == CompilerReport.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$DiagnosticManager$CompilerReport();
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$DiagnosticManager$Report();
        }

        /*
         * WARNING - void declaration
         */
        @Requires(value={"sourceContent != null", "sourceInfo != null"})
        protected String formatErrorSnippet(CharSequence charSequence, AnnotationSourceInfo annotationSourceInfo) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void sourceContent;
                void sourceInfo;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    this.com$google$java$contract$P$formatErrorSnippet(charSequence, annotationSourceInfo);
                    contractContext.leaveContract();
                }
                List<String> code = sourceInfo.getCode();
                int column = (int)this.diagnostic.getColumnNumber();
                int maxCodeLength = 0;
                for (String expr : code) {
                    int length = expr.length();
                    if (length <= maxCodeLength) continue;
                    maxCodeLength = length;
                }
                int errorPos = (int)this.diagnostic.getPosition();
                int lineStart = errorPos - column + 1;
                int errorStart = (int)this.diagnostic.getStartPosition();
                int errorEnd = (int)this.diagnostic.getEndPosition();
                String partialLine = ((Object)sourceContent.subSequence(lineStart, errorEnd)).toString();
                String snippet = null;
                int snippetErrorPos = -1;
                int snippetErrorStart = -1;
                int snippetErrorEnd = -1;
                for (String expr : code) {
                    String commentMarker = "/*[" + JavaUtils.quoteComment(expr) + "]*/";
                    int pos = partialLine.lastIndexOf(commentMarker);
                    if (pos == -1) continue;
                    snippet = expr;
                    int base = lineStart + (pos += commentMarker.length());
                    snippetErrorPos = errorPos - base;
                    snippetErrorStart = errorStart - base;
                    snippetErrorEnd = errorEnd - base;
                    snippetErrorPos -= JavaUtils.generatedCodeLength(partialLine.substring(pos, pos + snippetErrorPos));
                    snippetErrorStart -= JavaUtils.generatedCodeLength(partialLine.substring(pos, pos + snippetErrorStart));
                    snippetErrorEnd -= JavaUtils.generatedCodeLength(partialLine.substring(pos, pos + snippetErrorEnd));
                }
                if (snippet != null) {
                    StringBuilder buffer = new StringBuilder("clause: ");
                    buffer.append(snippet);
                    if (snippetErrorPos != -1) {
                        buffer.append("\n        ");
                        int end = snippet.length();
                        if (snippetErrorPos > end) {
                            snippetErrorPos = end;
                        }
                        if (snippetErrorStart > end) {
                            snippetErrorStart = end;
                        }
                        if (snippetErrorEnd > end) {
                            snippetErrorEnd = end;
                        }
                        this.underlineError(buffer, snippet, snippetErrorPos, snippetErrorStart, snippetErrorEnd);
                        snippet = buffer.toString();
                    }
                }
                String string = snippet;
                if (contractContext.tryEnterContract()) {
                    String string2;
                    string = string2 = string;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return string;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="formatErrorSnippet")
        private /* synthetic */ void com$google$java$contract$P$formatErrorSnippet(CharSequence sourceContent, AnnotationSourceInfo sourceInfo) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$CompilerReport$formatErrorSnippet(sourceContent, sourceInfo, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        protected AnnotationSourceInfo getSourceInfo() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                JavaFileObject source;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (!((source = this.diagnostic.getSource()) instanceof SyntheticJavaFile)) {
                    AnnotationSourceInfo annotationSourceInfo = null;
                    if (contractContext.tryEnterContract()) {
                        AnnotationSourceInfo annotationSourceInfo2;
                        annotationSourceInfo = annotationSourceInfo2 = annotationSourceInfo;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return annotationSourceInfo;
                }
                SyntheticJavaFile synthSource = (SyntheticJavaFile)source;
                Object info = synthSource.getSourceInfo(this.diagnostic.getLineNumber());
                if (!(info instanceof AnnotationSourceInfo)) {
                    AnnotationSourceInfo annotationSourceInfo = null;
                    if (contractContext.tryEnterContract()) {
                        AnnotationSourceInfo annotationSourceInfo3;
                        annotationSourceInfo = annotationSourceInfo3 = annotationSourceInfo;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return annotationSourceInfo;
                }
                AnnotationSourceInfo annotationSourceInfo = (AnnotationSourceInfo)info;
                if (contractContext.tryEnterContract()) {
                    AnnotationSourceInfo annotationSourceInfo4;
                    annotationSourceInfo = annotationSourceInfo4 = annotationSourceInfo;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return annotationSourceInfo;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public Diagnostic.Kind getKind() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                Diagnostic.Kind kind = this.diagnostic.getKind();
                if (contractContext.tryEnterContract()) {
                    Diagnostic.Kind kind2;
                    kind = kind2 = kind;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return kind;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getMessage(Locale locale) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void locale2;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                AnnotationSourceInfo sourceInfo = this.getSourceInfo();
                String msg = "error in contract: ";
                String errorCode = this.diagnostic.getCode();
                msg = errorCode != null && errorCode.startsWith("compiler.err.expected") ? msg + "syntax error" : msg + this.diagnostic.getMessage((Locale)locale2);
                JavaFileObject source = this.diagnostic.getSource();
                if (source != null && sourceInfo != null) {
                    String string;
                    block15: {
                        String string2;
                        try {
                            CharSequence chars = source.getCharContent(true);
                            string = msg + "\n" + this.formatErrorSnippet(chars, sourceInfo);
                            if (!contractContext.tryEnterContract()) break block15;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        string = string2 = string;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return string;
                }
                String string = msg;
                if (contractContext.tryEnterContract()) {
                    String string3;
                    string = string3 = string;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return string;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public Element getElement() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                AnnotationSourceInfo sourceInfo = this.getSourceInfo();
                Element element = this.getSourceInfo() == null ? null : sourceInfo.getElement();
                if (contractContext.tryEnterContract()) {
                    Element element2;
                    element = element2 = element;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return element;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public AnnotationMirror getAnnotationMirror() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                AnnotationSourceInfo sourceInfo = this.getSourceInfo();
                AnnotationMirror annotationMirror = this.getSourceInfo() == null ? null : sourceInfo.getAnnotationMirror();
                if (contractContext.tryEnterContract()) {
                    AnnotationMirror annotationMirror2;
                    annotationMirror = annotationMirror2 = annotationMirror;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return annotationMirror;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public AnnotationValue getAnnotationValue() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                AnnotationSourceInfo sourceInfo = this.getSourceInfo();
                AnnotationValue annotationValue = this.getSourceInfo() == null ? null : sourceInfo.getAnnotationValue();
                if (contractContext.tryEnterContract()) {
                    AnnotationValue annotationValue2;
                    annotationValue = annotationValue2 = annotationValue;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return annotationValue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, lines={255L})
        protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$DiagnosticManager$CompilerReport() {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = this.diagnostic != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new InvariantError("diagnostic != null", com$google$java$contract$local$exception$1));
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={263L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$CompilerReport$CompilerReport(Diagnostic<? extends JavaFileObject> diagnostic, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = diagnostic != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("diagnostic != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="formatErrorSnippet", lines={275L, 276L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$CompilerReport$formatErrorSnippet(CharSequence sourceContent, AnnotationSourceInfo sourceInfo, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = sourceContent != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("sourceContent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = sourceInfo != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                return new PreconditionError("sourceInfo != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
            }
            return null;
        }
    }

    public class AnnotationReport
    extends Report {
        protected Diagnostic.Kind kind;
        protected String message;
        protected String sourceString;
        protected int position;
        protected int startPosition;
        protected int endPosition;
        protected Element sourceElement;
        protected AnnotationMirror annotationMirror;
        protected AnnotationValue annotationValue;

        @Requires(value={"kind != null", "message != null", "position >= startPosition", "position <= endPosition", "startPosition >= 0", "startPosition <= endPosition"})
        @Ensures(value={"kind == getKind()"})
        public AnnotationReport(Diagnostic.Kind kind, String message, String sourceString, int position, int startPosition, int endPosition, Element sourceElement, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                this.kind = kind;
                this.message = message;
                this.sourceString = sourceString;
                this.position = position;
                this.startPosition = startPosition;
                this.endPosition = endPosition;
                this.sourceElement = sourceElement;
                this.annotationMirror = annotationMirror;
                this.annotationValue = annotationValue;
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == AnnotationReport.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == AnnotationReport.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$DiagnosticManager$Report();
        }

        @Requires(value={"kind != null", "message != null", "position >= startPosition", "position <= endPosition", "startPosition >= 0", "startPosition <= endPosition"})
        @Ensures(value={"kind == getKind()"})
        public AnnotationReport(Diagnostic.Kind kind, String message, String sourceString, int position, int startPosition, int endPosition, Object info) {
            this(kind, message, sourceString, position, startPosition, endPosition, null, null, null);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (info instanceof AnnotationSourceInfo) {
                    AnnotationSourceInfo sourceInfo = (AnnotationSourceInfo)info;
                    this.sourceElement = sourceInfo.getElement();
                    this.annotationMirror = sourceInfo.getAnnotationMirror();
                    this.annotationValue = sourceInfo.getAnnotationValue();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == AnnotationReport.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == AnnotationReport.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public Diagnostic.Kind getKind() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                Diagnostic.Kind kind = this.kind;
                if (contractContext.tryEnterContract()) {
                    Diagnostic.Kind kind2;
                    kind = kind2 = kind;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return kind;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public String getMessage(Locale locale) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (this.sourceString == null) {
                    String string = this.message;
                    if (contractContext.tryEnterContract()) {
                        String string2;
                        string = string2 = string;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return string;
                }
                StringBuilder buffer = new StringBuilder("clause: ");
                buffer.append(this.sourceString);
                buffer.append("\n        ");
                this.underlineError(buffer, this.sourceString, this.position, this.startPosition, this.endPosition);
                String string = this.message + "\n" + buffer.toString();
                if (contractContext.tryEnterContract()) {
                    String string3;
                    string = string3 = string;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return string;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public Element getElement() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                Element element = this.sourceElement;
                if (contractContext.tryEnterContract()) {
                    Element element2;
                    element = element2 = element;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return element;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public AnnotationMirror getAnnotationMirror() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                AnnotationMirror annotationMirror = this.annotationMirror;
                if (contractContext.tryEnterContract()) {
                    AnnotationMirror annotationMirror2;
                    annotationMirror = annotationMirror2 = annotationMirror;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return annotationMirror;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @Override
        public AnnotationValue getAnnotationValue() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                AnnotationValue annotationValue = this.annotationValue;
                if (contractContext.tryEnterContract()) {
                    AnnotationValue annotationValue2;
                    annotationValue = annotationValue2 = annotationValue;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return annotationValue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={157L, 158L, 159L, 160L, 161L, 162L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$AnnotationReport$AnnotationReport(Diagnostic.Kind kind, String message, String sourceString, int position, int startPosition, int endPosition, Element sourceElement, AnnotationMirror annotationMirror, AnnotationValue annotationValue, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = kind != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = message != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                return new PreconditionError("message != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
            }
            boolean com$google$java$contract$local$success$2 = false;
            Throwable com$google$java$contract$local$exception$5 = null;
            try {
                com$google$java$contract$local$success$2 = position >= startPosition;
            }
            catch (Throwable com$google$java$contract$local$exception$4) {
                com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
            }
            if (!com$google$java$contract$local$success$2) {
                return new PreconditionError("position >= startPosition", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
            }
            boolean com$google$java$contract$local$success$3 = false;
            Throwable com$google$java$contract$local$exception$7 = null;
            try {
                com$google$java$contract$local$success$3 = position <= endPosition;
            }
            catch (Throwable com$google$java$contract$local$exception$6) {
                com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
            }
            if (!com$google$java$contract$local$success$3) {
                return new PreconditionError("position <= endPosition", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
            }
            boolean com$google$java$contract$local$success$4 = false;
            Throwable com$google$java$contract$local$exception$9 = null;
            try {
                com$google$java$contract$local$success$4 = startPosition >= 0;
            }
            catch (Throwable com$google$java$contract$local$exception$8) {
                com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
            }
            if (!com$google$java$contract$local$success$4) {
                return new PreconditionError("startPosition >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$9);
            }
            boolean com$google$java$contract$local$success$5 = false;
            Throwable com$google$java$contract$local$exception$11 = null;
            try {
                com$google$java$contract$local$success$5 = startPosition <= endPosition;
            }
            catch (Throwable com$google$java$contract$local$exception$10) {
                com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
            }
            if (!com$google$java$contract$local$success$5) {
                return new PreconditionError("startPosition <= endPosition", com$google$java$contract$local$error, com$google$java$contract$local$exception$11);
            }
            return null;
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={165L})
        protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$DiagnosticManager$AnnotationReport$AnnotationReport(Diagnostic.Kind kind, String message, String sourceString, int position, int startPosition, int endPosition, Element sourceElement, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = kind == this.getKind();
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new PostconditionError("kind == getKind()", com$google$java$contract$local$exception$1));
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={194L, 195L, 196L, 197L, 198L, 199L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$AnnotationReport$AnnotationReport(Diagnostic.Kind kind, String message, String sourceString, int position, int startPosition, int endPosition, Object info, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = kind != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = message != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                return new PreconditionError("message != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
            }
            boolean com$google$java$contract$local$success$2 = false;
            Throwable com$google$java$contract$local$exception$5 = null;
            try {
                com$google$java$contract$local$success$2 = position >= startPosition;
            }
            catch (Throwable com$google$java$contract$local$exception$4) {
                com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
            }
            if (!com$google$java$contract$local$success$2) {
                return new PreconditionError("position >= startPosition", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
            }
            boolean com$google$java$contract$local$success$3 = false;
            Throwable com$google$java$contract$local$exception$7 = null;
            try {
                com$google$java$contract$local$success$3 = position <= endPosition;
            }
            catch (Throwable com$google$java$contract$local$exception$6) {
                com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
            }
            if (!com$google$java$contract$local$success$3) {
                return new PreconditionError("position <= endPosition", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
            }
            boolean com$google$java$contract$local$success$4 = false;
            Throwable com$google$java$contract$local$exception$9 = null;
            try {
                com$google$java$contract$local$success$4 = startPosition >= 0;
            }
            catch (Throwable com$google$java$contract$local$exception$8) {
                com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
            }
            if (!com$google$java$contract$local$success$4) {
                return new PreconditionError("startPosition >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$9);
            }
            boolean com$google$java$contract$local$success$5 = false;
            Throwable com$google$java$contract$local$exception$11 = null;
            try {
                com$google$java$contract$local$success$5 = startPosition <= endPosition;
            }
            catch (Throwable com$google$java$contract$local$exception$10) {
                com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
            }
            if (!com$google$java$contract$local$success$5) {
                return new PreconditionError("startPosition <= endPosition", com$google$java$contract$local$error, com$google$java$contract$local$exception$11);
            }
            return null;
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={202L})
        protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$DiagnosticManager$AnnotationReport$AnnotationReport(Diagnostic.Kind kind, String message, String sourceString, int position, int startPosition, int endPosition, Object info) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = kind == this.getKind();
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new PostconditionError("kind == getKind()", com$google$java$contract$local$exception$1));
            }
        }
    }

    @Invariant(value={"getKind() != null", "getMessage(null) != null", "getAnnotationMirror() == null || getElement() != null", "getAnnotationValue() == null || getAnnotationMirror() != null"})
    public abstract class Report {
        public Report() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == Report.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == Report.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$DiagnosticManager$Report();
        }

        public abstract Diagnostic.Kind getKind();

        public abstract String getMessage(Locale var1);

        public abstract Element getElement();

        public abstract AnnotationMirror getAnnotationMirror();

        public abstract AnnotationValue getAnnotationValue();

        /*
         * WARNING - void declaration
         */
        @Requires(value={"buffer != null", "expr != null", "pos >= start", "pos <= end", "start >= 0", "start <= end", "end <= expr.length()"})
        protected void underlineError(StringBuilder stringBuilder, String string, int n, int n2, int n3) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void pos;
                void buffer;
                void start;
                int i;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    this.com$google$java$contract$P$underlineError(stringBuilder, string, n, n2, n3);
                    contractContext.leaveContract();
                }
                for (i = 0; i < start; ++i) {
                    buffer.append(" ");
                }
                if (pos == start) {
                    buffer.append("^");
                } else {
                    void end;
                    while (i < pos) {
                        buffer.append("~");
                        ++i;
                    }
                    buffer.append("^");
                    ++i;
                    while (i < end) {
                        buffer.append("~");
                        ++i;
                    }
                }
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="underlineError")
        private /* synthetic */ void com$google$java$contract$P$underlineError(StringBuilder buffer, String expr, int pos, int start, int end) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$Report$underlineError(buffer, expr, pos, start, end, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, lines={56L, 57L, 58L, 59L})
        protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$DiagnosticManager$Report() {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = this.getKind() != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new InvariantError("getKind() != null", com$google$java$contract$local$exception$1));
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = this.getMessage(null) != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                ContractRuntime.raise(new InvariantError("getMessage(null) != null", com$google$java$contract$local$exception$3));
            }
            boolean com$google$java$contract$local$success$2 = false;
            Throwable com$google$java$contract$local$exception$5 = null;
            try {
                com$google$java$contract$local$success$2 = this.getAnnotationMirror() == null || this.getElement() != null;
            }
            catch (Throwable com$google$java$contract$local$exception$4) {
                com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
            }
            if (!com$google$java$contract$local$success$2) {
                ContractRuntime.raise(new InvariantError("getAnnotationMirror() == null || getElement() != null", com$google$java$contract$local$exception$5));
            }
            boolean com$google$java$contract$local$success$3 = false;
            Throwable com$google$java$contract$local$exception$7 = null;
            try {
                com$google$java$contract$local$success$3 = this.getAnnotationValue() == null || this.getAnnotationMirror() != null;
            }
            catch (Throwable com$google$java$contract$local$exception$6) {
                com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
            }
            if (!com$google$java$contract$local$success$3) {
                ContractRuntime.raise(new InvariantError("getAnnotationValue() == null || getAnnotationMirror() != null", com$google$java$contract$local$exception$7));
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="underlineError", lines={96L, 97L, 98L, 99L, 100L, 101L, 102L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$DiagnosticManager$Report$underlineError(StringBuilder buffer, String expr, int pos, int start, int end, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = buffer != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("buffer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = expr != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                return new PreconditionError("expr != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
            }
            boolean com$google$java$contract$local$success$2 = false;
            Throwable com$google$java$contract$local$exception$5 = null;
            try {
                com$google$java$contract$local$success$2 = pos >= start;
            }
            catch (Throwable com$google$java$contract$local$exception$4) {
                com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
            }
            if (!com$google$java$contract$local$success$2) {
                return new PreconditionError("pos >= start", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
            }
            boolean com$google$java$contract$local$success$3 = false;
            Throwable com$google$java$contract$local$exception$7 = null;
            try {
                com$google$java$contract$local$success$3 = pos <= end;
            }
            catch (Throwable com$google$java$contract$local$exception$6) {
                com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
            }
            if (!com$google$java$contract$local$success$3) {
                return new PreconditionError("pos <= end", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
            }
            boolean com$google$java$contract$local$success$4 = false;
            Throwable com$google$java$contract$local$exception$9 = null;
            try {
                com$google$java$contract$local$success$4 = start >= 0;
            }
            catch (Throwable com$google$java$contract$local$exception$8) {
                com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
            }
            if (!com$google$java$contract$local$success$4) {
                return new PreconditionError("start >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$9);
            }
            boolean com$google$java$contract$local$success$5 = false;
            Throwable com$google$java$contract$local$exception$11 = null;
            try {
                com$google$java$contract$local$success$5 = start <= end;
            }
            catch (Throwable com$google$java$contract$local$exception$10) {
                com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
            }
            if (!com$google$java$contract$local$success$5) {
                return new PreconditionError("start <= end", com$google$java$contract$local$error, com$google$java$contract$local$exception$11);
            }
            boolean com$google$java$contract$local$success$6 = false;
            Throwable com$google$java$contract$local$exception$13 = null;
            try {
                com$google$java$contract$local$success$6 = end <= expr.length();
            }
            catch (Throwable com$google$java$contract$local$exception$12) {
                com$google$java$contract$local$exception$13 = com$google$java$contract$local$exception$12;
            }
            if (!com$google$java$contract$local$success$6) {
                return new PreconditionError("end <= expr.length()", com$google$java$contract$local$error, com$google$java$contract$local$exception$13);
            }
            return null;
        }
    }
}

