/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.ElementVisitor$com$google$java$contract$H;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.ElementScanner;
import com.google.java.contract.core.util.Elements;
import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Predicates;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@Invariant(value={"getLineNumberMap() != null", "Iterables.all(getLineNumberMap().keySet(), Predicates.between(1L, null))", "output != null", "lineNumber >= 1"})
public class ContractWriter
extends ElementScanner {
    private static final List<String> numericTypes;
    private static final String CONTRACT_METHOD_SIGNATURE = "com.google.java.contract.core.agent.ContractMethodSignature";
    private static final String CONTRACT_KIND = "com.google.java.contract.core.model.ContractKind";
    private static final Pattern VARIADIC_REGEX;
    protected boolean debugTrace;
    protected ByteArrayOutputStream output;
    protected long lineNumber;
    protected Map<Long, Object> lineNumberMap;
    protected boolean isRootClass;
    protected TypeModel type;

    protected ContractWriter() {
        this(false);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractWriter.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractWriter.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractWriter();
    }

    protected ContractWriter(boolean debugTrace) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.debugTrace = debugTrace;
            this.output = new ByteArrayOutputStream();
            this.lineNumber = 1L;
            this.lineNumberMap = new HashMap<Long, Object>();
            this.isRootClass = true;
            this.type = null;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractWriter.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractWriter.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Requires(value={"parent != null"})
    protected ContractWriter(ContractWriter parent) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractWriter(parent);
                contractContext.leaveContract();
            }
            this.debugTrace = parent.debugTrace;
            this.output = parent.output;
            this.lineNumber = parent.lineNumber;
            this.lineNumberMap = parent.lineNumberMap;
            this.isRootClass = false;
            this.type = null;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractWriter.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractWriter.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractWriter(ContractWriter parent) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$ContractWriter(parent, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"type != null"})
    @Ensures(value={"result != null"})
    protected static String getDefaultValue(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractWriter.class);
        try {
            TypeName type;
            String name;
            if (contractContext.tryEnterContract()) {
                ContractWriter.com$google$java$contract$P$getDefaultValue(typeName);
                contractContext.leaveContract();
            }
            if ((name = type.getDeclaredName()).equals("boolean")) {
                String string = "false";
                if (contractContext.tryEnterContract()) {
                    String string2;
                    string = string2 = string;
                    ContractWriter.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$getDefaultValue(type, string2);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractWriter.class);
                }
                return string;
            }
            if (numericTypes.contains(name)) {
                String string = "(" + name + ")0";
                if (contractContext.tryEnterContract()) {
                    String string3;
                    string = string3 = string;
                    ContractWriter.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$getDefaultValue(type, string3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractWriter.class);
                }
                return string;
            }
            String string = "(" + name + ")null";
            if (contractContext.tryEnterContract()) {
                String string4;
                string = string4 = string;
                ContractWriter.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$getDefaultValue(type, string4);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractWriter.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractWriter.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getDefaultValue")
    private static /* synthetic */ void com$google$java$contract$P$getDefaultValue(TypeName type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractWriter.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$getDefaultValue(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"str != null"})
    protected void append(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$append(string);
                contractContext.leaveContract();
            }
            try {
                void str;
                this.output.write(str.getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="append")
    private /* synthetic */ void com$google$java$contract$P$append(String str) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$append(str, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Ensures(value={"lineNumber == old(lineNumber) + 1"})
    protected void appendEndOfLine() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        Object object = null;
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                object = this.com$google$java$contract$QO$appendEndOfLine$0();
                contractContext.leaveContract();
            }
            this.output.write(10);
            ++this.lineNumber;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$appendEndOfLine(object);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=0, target="appendEndOfLine")
    private /* synthetic */ Object com$google$java$contract$QO$appendEndOfLine$0() {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine$0();
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="appendEndOfLine")
    private /* synthetic */ void com$google$java$contract$Q$appendEndOfLine(Object com$google$java$contract$local$old0) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine(com$google$java$contract$local$old0);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"info != null"})
    @Ensures(value={"lineNumber == old(lineNumber) + 1"})
    protected void appendEndOfLine(Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        Object object2 = null;
        try {
            void info;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendEndOfLine(object);
                object2 = this.com$google$java$contract$QO$appendEndOfLine$0(object);
                contractContext.leaveContract();
            }
            this.lineNumberMap.put(this.lineNumber, info);
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$appendEndOfLine(info, object2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendEndOfLine")
    private /* synthetic */ void com$google$java$contract$P$appendEndOfLine(Object info) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine(info, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=0, target="appendEndOfLine")
    private /* synthetic */ Object com$google$java$contract$QO$appendEndOfLine$0(Object info) {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine$0(info);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="appendEndOfLine")
    private /* synthetic */ void com$google$java$contract$Q$appendEndOfLine(Object info, Object com$google$java$contract$local$old0) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine(info, com$google$java$contract$local$old0);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"list != null", "separator != null"})
    private void appendJoin(Collection<?> collection, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void list;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendJoin(collection, string);
                contractContext.leaveContract();
            }
            if (list.isEmpty()) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            Iterator it = list.iterator();
            while (true) {
                void separator;
                this.append(it.next().toString());
                if (!it.hasNext()) break;
                this.append((String)separator);
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendJoin")
    private /* synthetic */ void com$google$java$contract$P$appendJoin(Collection<?> list, String separator) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendJoin(list, separator, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"signature != null"})
    private void appendGenericSignature(List<? extends TypeName> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void signature;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendGenericSignature(list);
                contractContext.leaveContract();
            }
            if (!signature.isEmpty()) {
                this.append("<");
                this.appendJoin((Collection<?>)signature, ", ");
                this.append(">");
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendGenericSignature")
    private /* synthetic */ void com$google$java$contract$P$appendGenericSignature(List<? extends TypeName> signature) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendGenericSignature(signature, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"modifiers != null"})
    private void appendModifiers(EnumSet<ElementModifier> enumSet) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void modifiers;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendModifiers(enumSet);
                contractContext.leaveContract();
            }
            ArrayList list = new ArrayList(modifiers);
            Collections.sort(list);
            this.appendJoin(list, " ");
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendModifiers")
    private /* synthetic */ void com$google$java$contract$P$appendModifiers(EnumSet<ElementModifier> modifiers) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendModifiers(modifiers, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"rootType != null"})
    private void appendPackageDeclaration(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void rootType;
            String packageName;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendPackageDeclaration(typeModel);
                contractContext.leaveContract();
            }
            if (!(packageName = ClassName.getPackageName(rootType.getName().getSemiQualifiedName())).isEmpty()) {
                this.append("package ");
                this.append(packageName);
                this.append(";");
                this.appendEndOfLine();
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendPackageDeclaration")
    private /* synthetic */ void com$google$java$contract$P$appendPackageDeclaration(TypeModel rootType) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendPackageDeclaration(rootType, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"rootType != null", "rootType.getEnclosingElement() == null"})
    private void appendImportStatements(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void rootType;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendImportStatements(typeModel);
                contractContext.leaveContract();
            }
            for (String importName : rootType.getImportNames()) {
                this.append("import ");
                this.append(importName);
                this.append(";");
                this.appendEndOfLine();
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendImportStatements")
    private /* synthetic */ void com$google$java$contract$P$appendImportStatements(TypeModel rootType) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendImportStatements(rootType, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"variable != null"})
    private void appendVariableDeclaration(VariableModel variableModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void variable;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendVariableDeclaration(variableModel);
                contractContext.leaveContract();
            }
            this.appendVariableDeclaration((VariableModel)variable, null);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendVariableDeclaration")
    private /* synthetic */ void com$google$java$contract$P$appendVariableDeclaration(VariableModel variable) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendVariableDeclaration(variable, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"variable != null"})
    private void appendVariableDeclaration(VariableModel variableModel, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void typeNameOverride;
            void variable;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendVariableDeclaration(variableModel, string);
                contractContext.leaveContract();
            }
            this.appendModifiers(variable.getModifiers());
            this.append(" ");
            if (typeNameOverride == null) {
                this.append(variable.getType().getDeclaredName());
            } else {
                this.append((String)typeNameOverride);
            }
            this.append(" ");
            this.append(variable.getSimpleName());
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendVariableDeclaration")
    private /* synthetic */ void com$google$java$contract$P$appendVariableDeclaration(VariableModel variable, String typeNameOverride) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendVariableDeclaration(variable, typeNameOverride, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"method != null"})
    private void appendMethodDeclaration(MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void method;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendMethodDeclaration(methodModel);
                contractContext.leaveContract();
            }
            EnumSet<ElementModifier> modifiers = method.getModifiers();
            if (this.type.getKind().isInterfaceType()) {
                modifiers.remove((Object)ElementModifier.ABSTRACT);
            }
            this.appendModifiers(modifiers);
            this.append(" ");
            this.appendGenericSignature(method.getTypeParameters());
            if (method.isConstructor()) {
                this.append(" ");
                this.append(method.getEnclosingElement().getSimpleName());
            } else {
                this.append(" ");
                this.append(method.getReturnType().getDeclaredName());
                this.append(" ");
                this.append(method.getSimpleName());
            }
            this.append("(");
            Iterator<? extends VariableModel> it = method.getParameters().iterator();
            if (it.hasNext()) {
                VariableModel param = it.next();
                while (it.hasNext()) {
                    this.appendVariableDeclaration(param);
                    this.append(", ");
                    param = it.next();
                }
                if (!method.isVariadic()) {
                    this.appendVariableDeclaration(param);
                } else {
                    String variadicTypeName = VARIADIC_REGEX.matcher(param.getType().getDeclaredName()).replaceFirst("...");
                    this.appendVariableDeclaration(param, variadicTypeName);
                }
            }
            this.append(")");
            Set<? extends TypeName> exceptions = method.getExceptions();
            if (exceptions.size() != 0) {
                this.append(" throws ");
                this.appendJoin(exceptions, ", ");
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendMethodDeclaration")
    private /* synthetic */ void com$google$java$contract$P$appendMethodDeclaration(MethodModel method) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendMethodDeclaration(method, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"method != null", "method.isConstructor()"})
    private void appendConstructorCode(MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void method;
            TypeModel parent;
            List<? extends TypeName> superArguments;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendConstructorCode(methodModel);
                contractContext.leaveContract();
            }
            if (!(superArguments = (parent = Elements.getTypeOf((ElementModel)method)).getSuperArguments()).isEmpty()) {
                this.append("super(");
                Iterator<? extends TypeName> it = superArguments.iterator();
                while (true) {
                    this.append(ContractWriter.getDefaultValue(it.next()));
                    if (!it.hasNext()) break;
                    this.append(", ");
                }
                this.append(");");
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendConstructorCode")
    private /* synthetic */ void com$google$java$contract$P$appendConstructorCode(MethodModel method) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendConstructorCode(method, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"method != null", "!method.isConstructor()"})
    private void appendNormalMethodCode(MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void method;
            TypeName returnType;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendNormalMethodCode(methodModel);
                contractContext.leaveContract();
            }
            if (!(returnType = method.getReturnType()).getDeclaredName().equals("void")) {
                this.append("return ");
                this.append(ContractWriter.getDefaultValue(returnType));
                this.append(";");
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendNormalMethodCode")
    private /* synthetic */ void com$google$java$contract$P$appendNormalMethodCode(MethodModel method) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendNormalMethodCode(method, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"contract != null"})
    private void appendContractSignature(ContractMethodModel contractMethodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            List<Long> lineNumbers;
            MethodModel contracted;
            void contract2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendContractSignature(contractMethodModel);
                contractContext.leaveContract();
            }
            this.append("@");
            this.append(CONTRACT_METHOD_SIGNATURE);
            this.append("(");
            this.append("kind = ");
            this.append(CONTRACT_KIND);
            this.append(".");
            this.append(contract2.getContractKind().name());
            int id = contract2.getId();
            if (id != -1) {
                this.append(", id = ");
                this.append(Integer.toString(id));
            }
            if ((contracted = contract2.getContractedMethod()) != null) {
                this.append(", target = \"");
                this.append(contracted.getSimpleName());
                this.append("\"");
            }
            if ((lineNumbers = contract2.getLineNumbers()) != null && !lineNumbers.isEmpty()) {
                this.append(", lines = { ");
                Iterator<Long> it = lineNumbers.iterator();
                while (true) {
                    Long lineNumber;
                    this.append(Long.toString((lineNumber = it.next()) == null ? -1L : lineNumber));
                    if (!it.hasNext()) break;
                    this.append(", ");
                }
                this.append(" }");
            }
            this.append(")");
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendContractSignature")
    private /* synthetic */ void com$google$java$contract$P$appendContractSignature(ContractMethodModel contract2) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendContractSignature(contract2, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitVariable(VariableModel variableModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void variable;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitVariable(variableModel);
                contractContext.leaveContract();
            }
            if (variable.getKind() == ElementKind.CONSTANT) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            this.appendVariableDeclaration((VariableModel)variable);
            if (variable.getModifiers().contains((Object)ElementModifier.FINAL)) {
                this.append(" = ");
                String defaultValue = ContractWriter.getDefaultValue(variable.getType());
                this.append("\"dummy\".equals(\"dummy\") ? ");
                this.append(defaultValue);
                this.append(":");
                this.append(defaultValue);
            }
            this.append(";");
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitVariable")
    private /* synthetic */ void com$google$java$contract$P$visitVariable(VariableModel variable) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitVariable(variable, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitContractMethod(ContractMethodModel contractMethodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void contract2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitContractMethod(contractMethodModel);
                contractContext.leaveContract();
            }
            this.appendContractSignature((ContractMethodModel)contract2);
            this.appendMethodDeclaration((MethodModel)contract2);
            this.append(" {");
            this.appendEndOfLine();
            Object info = contract2.getSourceInfo();
            if (this.debugTrace && contract2.getContractKind() == ContractKind.HELPER) {
                this.append("com.google.java.contract.core.util.DebugUtils.contractInfo(");
                this.append("\"checking contract: ");
                this.append(ContractWriter.quoteString(((TypeModel)contract2.getEnclosingElement()).getName().getQualifiedName()));
                this.append(".");
                this.append(ContractWriter.quoteString(contract2.getSimpleName()));
                if (info instanceof AnnotationSourceInfo) {
                    AnnotationSourceInfo sourceInfo = (AnnotationSourceInfo)info;
                    this.append(": ");
                    this.append(ContractWriter.quoteString(((Object)sourceInfo.getAnnotationValue()).toString()));
                }
                this.append("\");");
                this.appendEndOfLine();
            }
            this.append(contract2.getCode());
            if (info == null) {
                this.appendEndOfLine();
            } else {
                this.appendEndOfLine(info);
            }
            this.append("}");
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitContractMethod")
    private /* synthetic */ void com$google$java$contract$P$visitContractMethod(ContractMethodModel contract2) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitContractMethod(contract2, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethod(MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void method;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitMethod(methodModel);
                contractContext.leaveContract();
            }
            if (this.type.getKind() == ElementKind.ENUM && method.getSimpleName().equals("<init>")) {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            this.appendMethodDeclaration((MethodModel)method);
            if (this.type.getKind().isInterfaceType() || method.getModifiers().contains((Object)ElementModifier.ABSTRACT)) {
                this.append(";");
            } else {
                this.append(" {");
                this.appendEndOfLine();
                if (method.isConstructor()) {
                    this.appendConstructorCode((MethodModel)method);
                } else {
                    this.appendNormalMethodCode((MethodModel)method);
                }
                this.appendEndOfLine();
                this.append("}");
            }
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitMethod")
    private /* synthetic */ void com$google$java$contract$P$visitMethod(MethodModel method) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitMethod(method, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitType(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitType(typeModel);
                contractContext.leaveContract();
            }
            if (this.type != null) {
                ContractWriter subwriter = new ContractWriter(this);
                subwriter.visitType((TypeModel)type);
                this.lineNumber = subwriter.lineNumber;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            this.type = type;
            if (this.isRootClass) {
                this.appendPackageDeclaration((TypeModel)type);
                this.appendImportStatements((TypeModel)type);
            }
            this.appendTypeDeclaration((TypeModel)type);
            this.appendSuperclass((TypeModel)type);
            this.appendInterfaces((TypeModel)type);
            this.append(" {");
            this.appendEndOfLine();
            if (type.getKind() == ElementKind.ENUM) {
                this.appendEnumSkeleton((TypeModel)type);
            }
            this.scan(type.getEnclosedElements());
            this.append("}");
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitType")
    private /* synthetic */ void com$google$java$contract$P$visitType(TypeModel type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitType(type, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"kind != null"})
    private String getKeywordForType(ElementKind elementKind) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getKeywordForType(elementKind);
                contractContext.leaveContract();
            }
            String keyword = null;
            switch (this.type.getKind()) {
                case CLASS: {
                    keyword = "class";
                    break;
                }
                case ENUM: {
                    keyword = "enum";
                    break;
                }
                case INTERFACE: {
                    keyword = "interface";
                    break;
                }
                case ANNOTATION_TYPE: {
                    keyword = "@interface";
                }
            }
            String string = keyword;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getKeywordForType")
    private /* synthetic */ void com$google$java$contract$P$getKeywordForType(ElementKind kind) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$getKeywordForType(kind, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"type != null"})
    private void appendEnumSkeleton(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            List<VariableModel> constants;
            Iterator<VariableModel> it;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendEnumSkeleton(typeModel);
                contractContext.leaveContract();
            }
            if ((it = (constants = Elements.filter(type.getEnclosedElements(), VariableModel.class, ElementKind.CONSTANT)).iterator()).hasNext()) {
                while (true) {
                    this.append(it.next().getSimpleName());
                    if (!it.hasNext()) break;
                    this.append(", ");
                }
            }
            this.append(";");
            this.appendEndOfLine();
            this.append("private ");
            this.append(type.getSimpleName());
            this.append("() {");
            this.appendEndOfLine();
            this.append("}");
            this.appendEndOfLine();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendEnumSkeleton")
    private /* synthetic */ void com$google$java$contract$P$appendEnumSkeleton(TypeModel type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendEnumSkeleton(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    private void appendTypeDeclaration(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            String keyword;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if ((keyword = this.getKeywordForType(type.getKind())) == null) {
                throw new IllegalArgumentException();
            }
            EnumSet<ElementModifier> modifiers = type.getModifiers();
            switch (type.getKind()) {
                case INTERFACE: {
                    modifiers.remove((Object)ElementModifier.ABSTRACT);
                    break;
                }
                case ANNOTATION_TYPE: {
                    modifiers.remove((Object)ElementModifier.ABSTRACT);
                    modifiers.remove((Object)ElementModifier.STATIC);
                }
            }
            this.appendModifiers(modifiers);
            this.append(" ");
            this.append(keyword);
            this.append(" ");
            String printName = type.getSimpleName();
            this.append(printName);
            this.appendGenericSignature(type.getTypeParameters());
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"type != null"})
    private void appendSuperclass(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendSuperclass(typeModel);
                contractContext.leaveContract();
            }
            if (type.getKind() != ElementKind.ENUM && type.getSuperclass() != null) {
                this.append(" extends ");
                this.append(type.getSuperclass().getDeclaredName());
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendSuperclass")
    private /* synthetic */ void com$google$java$contract$P$appendSuperclass(TypeModel type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendSuperclass(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"type != null", "type.getKind() != ElementKind.ANNOTATION_TYPE|| type.getInterfaces().size() == 1"})
    private void appendInterfaces(TypeModel typeModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            Set<? extends ClassName> interfaces;
            void type;
            ElementKind kind;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$appendInterfaces(typeModel);
                contractContext.leaveContract();
            }
            if ((kind = type.getKind()) != ElementKind.ANNOTATION_TYPE && (interfaces = type.getInterfaces()).size() != 0) {
                if (kind == ElementKind.INTERFACE) {
                    this.append(" extends ");
                } else {
                    this.append(" implements ");
                }
                this.appendJoin(interfaces, ", ");
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="appendInterfaces")
    private /* synthetic */ void com$google$java$contract$P$appendInterfaces(TypeModel type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendInterfaces(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"s != null"})
    @Ensures(value={"result != null"})
    public static String quoteString(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractWriter.class);
        try {
            String s;
            if (contractContext.tryEnterContract()) {
                ContractWriter.com$google$java$contract$P$quoteString(string);
                contractContext.leaveContract();
            }
            String string2 = s.replace("\\", "\\\\").replace("\"", "\\\"");
            if (contractContext.tryEnterContract()) {
                String string3;
                string2 = string3 = string2;
                ContractWriter.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$quoteString(s, string3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractWriter.class);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractWriter.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="quoteString")
    private static /* synthetic */ void com$google$java$contract$P$quoteString(String s) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractWriter.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$quoteString(s, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public Map<Long, ?> getLineNumberMap() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Map<Long, Object> map = this.lineNumberMap;
            if (contractContext.tryEnterContract()) {
                Map<Long, Object> map2;
                map = map2 = map;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result != null"})
    public byte[] toByteArray() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            byte[] byArray = this.output.toByteArray();
            if (contractContext.tryEnterContract()) {
                byte[] byArray2;
                byArray = byArray2 = byArray;
                this.com$google$java$contract$Q$toByteArray(byArray2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="toByteArray")
    private /* synthetic */ void com$google$java$contract$Q$toByteArray(byte[] result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$toByteArray(result);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractWriter.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            numericTypes = Arrays.asList("char", "byte", "short", "int", "long", "float", "double");
            VARIADIC_REGEX = Pattern.compile("\\[\\p{javaWhitespace}*\\]\\p{javaWhitespace}*$");
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractWriter.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractWriter.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={62L, 63L, 64L, 65L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$ContractWriter() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getLineNumberMap() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getLineNumberMap() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = Iterables.all(this.getLineNumberMap().keySet(), Predicates.between(1L, null));
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("Iterables.all(getLineNumberMap().keySet(), Predicates.between(1L, null))", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.output != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("output != null", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.lineNumber >= 1L;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("lineNumber >= 1", com$google$java$contract$local$exception$7));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={112L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$ContractWriter(ContractWriter parent, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = parent != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getDefaultValue", lines={125L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$getDefaultValue(TypeName type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getDefaultValue", lines={126L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$getDefaultValue(TypeName type, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="append", lines={138L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$append(String str, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = str != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("str != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendEndOfLine", lines={147L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine$0() {
        return this.lineNumber;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendEndOfLine", lines={147L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine(Object com$google$java$contract$local$old0) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.lineNumber == ContractRuntime.magicCast(com$google$java$contract$local$old0, null) + 1L;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("lineNumber == old(lineNumber) + 1", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendEndOfLine", lines={153L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine(Object info, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = info != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("info != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendEndOfLine", lines={154L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine$0(Object info) {
        return this.lineNumber;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendEndOfLine", lines={154L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$appendEndOfLine(Object info, Object com$google$java$contract$local$old0) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.lineNumber == ContractRuntime.magicCast(com$google$java$contract$local$old0, null) + 1L;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("lineNumber == old(lineNumber) + 1", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendJoin", lines={161L, 162L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendJoin(Collection<?> list, String separator, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = list != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("list != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = separator != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("separator != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendGenericSignature", lines={179L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendGenericSignature(List<? extends TypeName> signature, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = signature != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("signature != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendModifiers", lines={188L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendModifiers(EnumSet<ElementModifier> modifiers, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = modifiers != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("modifiers != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendPackageDeclaration", lines={195L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendPackageDeclaration(TypeModel rootType, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = rootType != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("rootType != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendImportStatements", lines={208L, 209L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendImportStatements(TypeModel rootType, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = rootType != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("rootType != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = rootType.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("rootType.getEnclosingElement() == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendVariableDeclaration", lines={220L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendVariableDeclaration(VariableModel variable, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = variable != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("variable != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendVariableDeclaration", lines={225L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendVariableDeclaration(VariableModel variable, String typeNameOverride, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = variable != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("variable != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendMethodDeclaration", lines={239L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendMethodDeclaration(MethodModel method, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = method != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("method != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendConstructorCode", lines={287L, 288L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendConstructorCode(MethodModel method, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = method != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("method != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = method.isConstructor();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("method.isConstructor()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendNormalMethodCode", lines={308L, 309L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendNormalMethodCode(MethodModel method, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = method != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("method != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !method.isConstructor();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("!method.isConstructor()", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendContractSignature", lines={320L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendContractSignature(ContractMethodModel contract2, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contract2 != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contract != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getKeywordForType", lines={488L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$getKeywordForType(ElementKind kind, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendEnumSkeleton", lines={511L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendEnumSkeleton(TypeModel type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendSuperclass", lines={576L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendSuperclass(TypeModel type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="appendInterfaces", lines={592L, 593L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$appendInterfaces(TypeModel type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = type.getKind() != ElementKind.ANNOTATION_TYPE || type.getInterfaces().size() == 1;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("type.getKind() != ElementKind.ANNOTATION_TYPE|| type.getInterfaces().size() == 1", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="quoteString", lines={615L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractWriter$quoteString(String s, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = s != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("s != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="quoteString", lines={616L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$quoteString(String s, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="toByteArray", lines={625L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractWriter$toByteArray(byte[] result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }
}

