/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.BalancedTokenizer;
import com.google.java.contract.core.util.JavaTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

@Invariant(value={"diagnosticManager != null", "oldId >= 0", "oldParameters == null || oldParametersCode != null", "oldParameters == null || oldParametersLineNumbers != null", "oldParameters == null || !oldParameters.contains(null)", "oldParameters == null || !oldParametersCode.contains(null)", "oldParameters == null || oldParameters.size() == oldParametersCode.size()", "oldParameters == null || oldParameters.size() == oldParametersLineNumbers.size()"})
public class ContractExpressionTransformer {
    private static final String MAGIC_CAST_METHOD = "com.google.java.contract.core.runtime.ContractRuntime.magicCast";
    protected DiagnosticManager diagnosticManager;
    protected boolean acceptOld;
    protected List<VariableModel> oldParameters;
    protected List<String> oldParametersCode;
    protected List<Long> oldParametersLineNumbers;
    protected List<String> newCode;
    protected boolean parsed;
    protected int oldId;

    public ContractExpressionTransformer(DiagnosticManager diagnosticManager, boolean acceptOld) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.diagnosticManager = diagnosticManager;
            this.acceptOld = acceptOld;
            this.oldParameters = null;
            this.oldParametersCode = null;
            this.oldParametersLineNumbers = null;
            this.newCode = null;
            this.parsed = false;
            this.oldId = 0;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractExpressionTransformer.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractExpressionTransformer.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractExpressionTransformer();
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptOld(boolean bl) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void acceptOld;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.acceptOld = acceptOld;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"currentBuffer != null", "tokenizer != null", "token != null"})
    private void transformCommon(StringBuilder stringBuilder, BalancedTokenizer balancedTokenizer, JavaTokenizer.Token token) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void token2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$transformCommon(stringBuilder, balancedTokenizer, token);
                contractContext.leaveContract();
            }
            switch (token2.kind) {
                case COMMENT: {
                    void currentBuffer;
                    int length = token2.text.length();
                    for (int i = 0; i < length; ++i) {
                        currentBuffer.append(" ");
                    }
                    break;
                }
                default: {
                    void currentBuffer;
                    currentBuffer.append(token2.text);
                }
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="transformCommon")
    private /* synthetic */ void com$google$java$contract$P$transformCommon(StringBuilder currentBuffer, BalancedTokenizer tokenizer, JavaTokenizer.Token token) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$transformCommon(currentBuffer, tokenizer, token, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * Unable to fully structure code
     */
    @Requires(value={"code != null", "lineNumbers != null", "code.size() == lineNumbers.size()"})
    @Ensures(value={"result == canQueryResults()", "!result || newCode.size() == code.size()"})
    public boolean transform(List<String> var1_1, List<Long> var2_2, Object var3_3) {
        var4_4 = ContractRuntime.getContext();
        var5_5 = var4_4.tryEnter(this);
        try {
            if (var4_4.tryEnterContract()) {
                if (var5_5) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$transform(var1_1, var2_2, var3_3);
                var4_4.leaveContract();
            }
            this.oldParameters = new ArrayList<VariableModel>();
            this.oldParametersCode = new ArrayList<String>();
            this.oldParametersLineNumbers = new ArrayList<Long>();
            this.newCode = new ArrayList<String>();
            this.parsed = true;
            iterLineNumber = lineNumbers.iterator();
            block8: for (String expr : code) {
                lineNumber = iterLineNumber.hasNext() != false ? (Long)iterLineNumber.next() : null;
                tokenizer = new BalancedTokenizer(new StringReader(expr));
                currentLevel = 0;
                newLevel = 0;
                buffer = new StringBuilder();
                oldBuffer = null;
                oldName = null;
                oldContext = -1;
                while (tokenizer.hasNext()) {
                    block27: {
                        block26: {
                            token = tokenizer.next();
                            newLevel = tokenizer.getCurrentLevel();
                            v0 = currentBuffer = oldBuffer != null ? oldBuffer : buffer;
                            if (newLevel == 0 && token.text.equals(";")) {
                                this.diagnosticManager.error("'\"' expected", expr, token.offset, token.offset, token.offset, sourceInfo);
                                this.parsed = false;
                                continue block8;
                            }
                            if (oldBuffer == null) break block26;
                            if (newLevel == oldContext) {
                                oldExpr = oldBuffer.toString();
                                this.oldParameters.add(new VariableModel(ElementKind.PARAMETER, oldName, new ClassName("java/lang/Object")));
                                this.oldParametersCode.add(oldExpr);
                                this.oldParametersLineNumbers.add(lineNumber);
                                buffer.append("(   ");
                                buffer.append("/*[*/");
                                buffer.append("com.google.java.contract.core.runtime.ContractRuntime.magicCast");
                                buffer.append("(");
                                buffer.append(oldName);
                                buffer.append(", ");
                                buffer.append("true ? null : ");
                                buffer.append("/*]*/");
                                buffer.append(oldExpr);
                                buffer.append("/*[*/");
                                buffer.append(")");
                                buffer.append("/*]*/");
                                buffer.append(")");
                                oldBuffer = null;
                                oldContext = -1;
                            } else {
                                switch (1.$SwitchMap$com$google$java$contract$core$util$JavaTokenizer$TokenKind[token.kind.ordinal()]) {
                                    case 2: {
                                        if (token.text.equals("old")) {
                                            this.diagnosticManager.error("nested old expression", expr, token.offset, token.offset, token.offset, sourceInfo);
                                            this.parsed = false;
                                            continue block8;
                                        }
                                        oldBuffer.append(token.text);
                                        break;
                                    }
                                    default: {
                                        this.transformCommon(oldBuffer, tokenizer, token);
                                        break;
                                    }
                                }
                            }
                            break block27;
                        }
                        switch (1.$SwitchMap$com$google$java$contract$core$util$JavaTokenizer$TokenKind[token.kind.ordinal()]) {
                            case 2: {
                                if (!this.acceptOld || !token.text.equals("old")) ** GOTO lbl99
                                afterOld = null;
                                if (!tokenizer.hasNext()) ** GOTO lbl91
                                afterOld = tokenizer.next();
                                if (afterOld.text.equals("(") || afterOld.kind == JavaTokenizer.TokenKind.SPACE && tokenizer.hasNext() && tokenizer.next().text.equals("(")) ** GOTO lbl95
lbl91:
                                // 2 sources

                                errorPos = afterOld != null ? afterOld.offset : tokenizer.getCurrentOffset();
                                this.diagnosticManager.error("'(' expected", expr, errorPos, errorPos, errorPos, sourceInfo);
                                this.parsed = false;
                                continue block8;
lbl95:
                                // 1 sources

                                oldName = "com$google$java$contract$local$old" + this.oldId++;
                                oldBuffer = afterOld.kind == JavaTokenizer.TokenKind.SPACE ? new StringBuilder(afterOld.text) : new StringBuilder();
                                oldContext = currentLevel;
                                break;
                            }
lbl99:
                            // 2 sources

                            default: {
                                this.transformCommon(buffer, tokenizer, token);
                            }
                        }
                    }
                    currentLevel = newLevel;
                }
                if (tokenizer.hasErrors()) {
                    errorPos = tokenizer.getCurrentOffset();
                    this.diagnosticManager.error(tokenizer.getErrorMessage(), expr, errorPos, errorPos, errorPos, sourceInfo);
                    this.parsed = false;
                    continue;
                }
                this.newCode.add(buffer.toString());
            }
            v1 = this.parsed;
            if (var4_4.tryEnterContract()) {
                v1 = var21_22 = v1;
                this.com$google$java$contract$Q$transform((List<String>)code, (List<Long>)lineNumbers, sourceInfo, var21_22);
                if (var5_5) {
                    this.com$google$java$contract$I();
                }
                var4_4.leaveContract();
            }
            if (var5_5) {
                var4_4.leave(this);
            }
            return v1;
        }
        catch (Throwable v2) {
            v3 = v2;
            if (v2 instanceof Exception && var4_4.tryEnterContract()) {
                var22_23 = (Exception)v3;
                if (var5_5) {
                    this.com$google$java$contract$I();
                }
                v3 = var22_23;
                var4_4.leaveContract();
            }
            if (var5_5) {
                var4_4.leave(this);
            }
            throw v3;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="transform")
    private /* synthetic */ void com$google$java$contract$P$transform(List<String> code, List<Long> lineNumbers, Object sourceInfo) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$transform(code, lineNumbers, sourceInfo, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="transform")
    private /* synthetic */ void com$google$java$contract$Q$transform(List<String> code, List<Long> lineNumbers, Object sourceInfo, boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$transform(code, lineNumbers, sourceInfo, result);
    }

    public boolean canQueryResults() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.parsed;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result >= 0"})
    public int getNextOldId() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            int n = this.oldId;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                this.com$google$java$contract$Q$getNextOldId(n2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getNextOldId")
    private /* synthetic */ void com$google$java$contract$Q$getNextOldId(int result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getNextOldId(result);
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null", "result.size() == getOldParametersCode().size()", "result.size() == getOldParametersLineNumbers().size()"})
    public List<VariableModel> getOldParameters() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getOldParameters();
                contractContext.leaveContract();
            }
            List<VariableModel> list = this.oldParameters;
            if (contractContext.tryEnterContract()) {
                List<VariableModel> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getOldParameters(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getOldParameters")
    private /* synthetic */ void com$google$java$contract$P$getOldParameters() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParameters(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getOldParameters")
    private /* synthetic */ void com$google$java$contract$Q$getOldParameters(List<VariableModel> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParameters(result);
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null", "result.size() == getOldParameters().size()", "result.size() == getOldParametersLineNumbers().size()"})
    public List<String> getOldParametersCode() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getOldParametersCode();
                contractContext.leaveContract();
            }
            List<String> list = this.oldParametersCode;
            if (contractContext.tryEnterContract()) {
                List<String> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getOldParametersCode(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getOldParametersCode")
    private /* synthetic */ void com$google$java$contract$P$getOldParametersCode() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersCode(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getOldParametersCode")
    private /* synthetic */ void com$google$java$contract$Q$getOldParametersCode(List<String> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersCode(result);
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null", "result.size() == getOldParameters().size()", "result.size() == getOldParametersCode().size()"})
    public List<Long> getOldParametersLineNumbers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getOldParametersLineNumbers();
                contractContext.leaveContract();
            }
            List<Long> list = this.oldParametersLineNumbers;
            if (contractContext.tryEnterContract()) {
                List<Long> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getOldParametersLineNumbers(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getOldParametersLineNumbers")
    private /* synthetic */ void com$google$java$contract$P$getOldParametersLineNumbers() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersLineNumbers(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getOldParametersLineNumbers")
    private /* synthetic */ void com$google$java$contract$Q$getOldParametersLineNumbers(List<Long> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersLineNumbers(result);
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null"})
    public List<String> getTransformedCode() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getTransformedCode();
                contractContext.leaveContract();
            }
            List<String> list = this.newCode;
            if (contractContext.tryEnterContract()) {
                List<String> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getTransformedCode(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getTransformedCode")
    private /* synthetic */ void com$google$java$contract$P$getTransformedCode() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getTransformedCode(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getTransformedCode")
    private /* synthetic */ void com$google$java$contract$Q$getTransformedCode(List<String> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getTransformedCode(result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={61L, 62L, 63L, 64L, 65L, 66L, 67L, 68L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$ContractExpressionTransformer() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("diagnosticManager != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.oldId >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("oldId >= 0", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.oldParameters == null || this.oldParametersCode != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("oldParameters == null || oldParametersCode != null", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.oldParameters == null || this.oldParametersLineNumbers != null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("oldParameters == null || oldParametersLineNumbers != null", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = this.oldParameters == null || !this.oldParameters.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("oldParameters == null || !oldParameters.contains(null)", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = this.oldParameters == null || !this.oldParametersCode.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("oldParameters == null || !oldParametersCode.contains(null)", com$google$java$contract$local$exception$11));
        }
        boolean com$google$java$contract$local$success$6 = false;
        Throwable com$google$java$contract$local$exception$13 = null;
        try {
            com$google$java$contract$local$success$6 = this.oldParameters == null || this.oldParameters.size() == this.oldParametersCode.size();
        }
        catch (Throwable com$google$java$contract$local$exception$12) {
            com$google$java$contract$local$exception$13 = com$google$java$contract$local$exception$12;
        }
        if (!com$google$java$contract$local$success$6) {
            ContractRuntime.raise(new InvariantError("oldParameters == null || oldParameters.size() == oldParametersCode.size()", com$google$java$contract$local$exception$13));
        }
        boolean com$google$java$contract$local$success$7 = false;
        Throwable com$google$java$contract$local$exception$15 = null;
        try {
            com$google$java$contract$local$success$7 = this.oldParameters == null || this.oldParameters.size() == this.oldParametersLineNumbers.size();
        }
        catch (Throwable com$google$java$contract$local$exception$14) {
            com$google$java$contract$local$exception$15 = com$google$java$contract$local$exception$14;
        }
        if (!com$google$java$contract$local$success$7) {
            ContractRuntime.raise(new InvariantError("oldParameters == null || oldParameters.size() == oldParametersLineNumbers.size()", com$google$java$contract$local$exception$15));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transformCommon", lines={140L, 141L, 142L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$transformCommon(StringBuilder currentBuffer, BalancedTokenizer tokenizer, JavaTokenizer.Token token, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = currentBuffer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("currentBuffer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = tokenizer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("tokenizer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = token != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("token != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transform", lines={169L, 170L, 171L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$transform(List<String> code, List<Long> lineNumbers, Object sourceInfo, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = code != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("code != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = lineNumbers != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("lineNumbers != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = code.size() == lineNumbers.size();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("code.size() == lineNumbers.size()", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transform", lines={174L, 175L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$transform(List<String> code, List<Long> lineNumbers, Object sourceInfo, boolean result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == canQueryResults()", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !result || this.newCode.size() == code.size();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!result || newCode.size() == code.size()", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getNextOldId", lines={329L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getNextOldId(int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= 0", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getOldParameters", lines={334L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParameters(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("canQueryResults()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getOldParameters", lines={336L, 337L, 338L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParameters(List<VariableModel> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result.size() == this.getOldParametersCode().size();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result.size() == getOldParametersCode().size()", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = result.size() == this.getOldParametersLineNumbers().size();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("result.size() == getOldParametersLineNumbers().size()", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getOldParametersCode", lines={344L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersCode(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("canQueryResults()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getOldParametersCode", lines={346L, 347L, 348L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersCode(List<String> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result.size() == this.getOldParameters().size();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result.size() == getOldParameters().size()", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = result.size() == this.getOldParametersLineNumbers().size();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("result.size() == getOldParametersLineNumbers().size()", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getOldParametersLineNumbers", lines={354L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersLineNumbers(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("canQueryResults()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getOldParametersLineNumbers", lines={356L, 357L, 358L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getOldParametersLineNumbers(List<Long> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result.size() == this.getOldParameters().size();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result.size() == getOldParameters().size()", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = result.size() == this.getOldParametersCode().size();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("result.size() == getOldParametersCode().size()", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTransformedCode", lines={364L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionTransformer$getTransformedCode(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("canQueryResults()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTransformedCode", lines={365L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractExpressionTransformer$getTransformedCode(List<String> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }
}

