/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.JavaUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementScanner6;

@Invariant(value={"utils != null"})
abstract class AbstractTypeBuilder
extends ElementScanner6<Void, ElementModel> {
    protected FactoryUtils utils;
    protected DiagnosticManager diagnosticManager;
    protected Iterator<Long> rootLineNumberIterator;

    @Requires(value={"utils != null"})
    protected AbstractTypeBuilder(FactoryUtils utils, DiagnosticManager diagnosticManager) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$AbstractTypeBuilder(utils, diagnosticManager);
                contractContext.leaveContract();
            }
            this.utils = utils;
            this.diagnosticManager = diagnosticManager;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == AbstractTypeBuilder.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == AbstractTypeBuilder.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$AbstractTypeBuilder(FactoryUtils utils, DiagnosticManager diagnosticManager) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$AbstractTypeBuilder(utils, diagnosticManager, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$AbstractTypeBuilder();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"parent != null", "annotation != null", "owner != null", "utils.isContractAnnotation(annotation)"})
    @Ensures(value={"result != null"})
    private ContractAnnotationModel createBlankContractModel(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void owner;
            void primary;
            TypeName returnType;
            boolean virtual;
            void parent;
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$createBlankContractModel(element, annotationMirror, bl, className);
                contractContext.leaveContract();
            }
            com.google.java.contract.core.model.ElementKind kind = this.utils.getAnnotationKindForName((AnnotationMirror)annotation);
            block1 : switch (parent.getKind()) {
                default: {
                    virtual = parent.getKind() != ElementKind.INTERFACE;
                    returnType = null;
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    virtual = parent.getEnclosingElement().getKind() != ElementKind.INTERFACE;
                    ExecutableElement method = (ExecutableElement)parent;
                    switch (method.getReturnType().getKind()) {
                        case VOID: {
                            returnType = this.utils.getTypeNameForType(method.getReturnType());
                            break block1;
                        }
                        case NONE: {
                            returnType = null;
                            break block1;
                        }
                        case PACKAGE: {
                            throw new RuntimeException("ExecutableElement has PACKAGE return type");
                        }
                    }
                    returnType = this.utils.getTypeNameForType(this.utils.typeUtils.erasure(method.getReturnType()));
                }
            }
            ContractAnnotationModel contractAnnotationModel = new ContractAnnotationModel(kind, (boolean)primary, virtual, (ClassName)owner, returnType);
            if (contractContext.tryEnterContract()) {
                ContractAnnotationModel contractAnnotationModel2;
                contractAnnotationModel = contractAnnotationModel2 = contractAnnotationModel;
                this.com$google$java$contract$Q$createBlankContractModel((Element)parent, (AnnotationMirror)annotation, (boolean)primary, (ClassName)owner, contractAnnotationModel2);
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return contractAnnotationModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createBlankContractModel")
    private /* synthetic */ void com$google$java$contract$P$createBlankContractModel(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$createBlankContractModel(parent, annotation, primary, owner, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="createBlankContractModel")
    private /* synthetic */ void com$google$java$contract$Q$createBlankContractModel(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, ContractAnnotationModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$AbstractTypeBuilder$createBlankContractModel(parent, annotation, primary, owner, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"parent != null", "annotation != null", "owner != null", "utils.isContractAnnotation(annotation)"})
    protected ContractAnnotationModel createContractModel(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void owner;
            void primary;
            void annotation;
            void parent;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$createContractModel(element, annotationMirror, bl, className);
                contractContext.leaveContract();
            }
            ContractAnnotationModel model = this.createBlankContractModel((Element)parent, (AnnotationMirror)annotation, (boolean)primary, (ClassName)owner);
            List<Long> lineNumbers = null;
            if (this.rootLineNumberIterator == null) {
                lineNumbers = this.getLineNumbers((Element)parent, (AnnotationMirror)annotation);
            }
            AnnotationValue lastAnnotationValue = null;
            for (AnnotationValue annotationValue : annotation.getElementValues().values()) {
                List values = (List)annotationValue.getValue();
                Iterator iterValue = values.iterator();
                Iterator<Long> iterLineNumber = this.rootLineNumberIterator != null ? this.rootLineNumberIterator : lineNumbers.iterator();
                while (iterValue.hasNext()) {
                    String value = (String)((AnnotationValue)iterValue.next()).getValue();
                    Long lineNumber = iterLineNumber.hasNext() ? iterLineNumber.next() : null;
                    model.addValue(value, lineNumber);
                }
                lastAnnotationValue = annotationValue;
            }
            if (model.getValues().isEmpty()) {
                this.diagnosticManager.warning("No contracts specified in annotation.", null, 0, 0, 0, (Element)parent, (AnnotationMirror)annotation, lastAnnotationValue);
                ContractAnnotationModel contractAnnotationModel = null;
                if (contractContext.tryEnterContract()) {
                    ContractAnnotationModel contractAnnotationModel2;
                    contractAnnotationModel = contractAnnotationModel2 = contractAnnotationModel;
                    if (bl2) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl2) {
                    contractContext.leave(this);
                }
                return contractAnnotationModel;
            }
            AnnotationSourceInfo sourceInfo = new AnnotationSourceInfo((Element)parent, (AnnotationMirror)annotation, lastAnnotationValue, model.getValues());
            model.setSourceInfo(sourceInfo);
            ContractAnnotationModel contractAnnotationModel = model;
            if (contractContext.tryEnterContract()) {
                ContractAnnotationModel contractAnnotationModel3;
                contractAnnotationModel = contractAnnotationModel3 = contractAnnotationModel;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return contractAnnotationModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createContractModel")
    private /* synthetic */ void com$google$java$contract$P$createContractModel(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$createContractModel(parent, annotation, primary, owner, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"parent != null", "annotation != null", "owner != null", "p != null"})
    protected void visitAnnotation(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className, ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void owner;
            void primary;
            void parent;
            ContractAnnotationModel model;
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitAnnotation(element, annotationMirror, bl, className, elementModel);
                contractContext.leaveContract();
            }
            if (this.utils.isContractAnnotation((AnnotationMirror)annotation) && (model = this.createContractModel((Element)parent, (AnnotationMirror)annotation, (boolean)primary, (ClassName)owner)) != null) {
                void p;
                p.addEnclosedElement(model);
            }
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitAnnotation")
    private /* synthetic */ void com$google$java$contract$P$visitAnnotation(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, ElementModel p) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$visitAnnotation(parent, annotation, primary, owner, p, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"parent != null", "annotation != null"})
    @Ensures(value={"result != null"})
    protected List<Long> getLineNumbers(Element element, AnnotationMirror annotationMirror) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            void parent;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getLineNumbers(element, annotationMirror);
                contractContext.leaveContract();
            }
            if (JavaUtils.classExists("com.sun.source.util.Trees")) {
                List list;
                block18: {
                    List list2;
                    try {
                        list = (List)Class.forName("com.google.java.contract.core.apt.JavacUtils").getMethod("getLineNumbers", ProcessingEnvironment.class, Element.class, AnnotationMirror.class).invoke(null, this.utils.processingEnv, parent, annotation);
                        if (!contractContext.tryEnterContract()) break block18;
                    }
                    catch (Exception e) {
                        List<Long> list3 = Collections.emptyList();
                        if (contractContext.tryEnterContract()) {
                            List<Long> list4;
                            list3 = list4 = list3;
                            this.com$google$java$contract$Q$getLineNumbers((Element)parent, (AnnotationMirror)annotation, list4);
                            if (bl) {
                                this.com$google$java$contract$I();
                            }
                            contractContext.leaveContract();
                        }
                        if (bl) {
                            contractContext.leave(this);
                        }
                        return list3;
                    }
                    list = list2 = list;
                    this.com$google$java$contract$Q$getLineNumbers((Element)parent, (AnnotationMirror)annotation, list2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            List<Long> list = Collections.emptyList();
            if (contractContext.tryEnterContract()) {
                List<Long> list5;
                list = list5 = list;
                this.com$google$java$contract$Q$getLineNumbers((Element)parent, (AnnotationMirror)annotation, list5);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getLineNumbers")
    private /* synthetic */ void com$google$java$contract$P$getLineNumbers(Element parent, AnnotationMirror annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$getLineNumbers(parent, annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getLineNumbers")
    private /* synthetic */ void com$google$java$contract$Q$getLineNumbers(Element parent, AnnotationMirror annotation, List<Long> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$AbstractTypeBuilder$getLineNumbers(parent, annotation, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"element != null"})
    @Ensures(value={"result != null"})
    protected Set<String> getImportNames(Element element) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void element2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getImportNames(element);
                contractContext.leaveContract();
            }
            if (JavaUtils.classExists("com.sun.source.util.Trees")) {
                Set set;
                block18: {
                    Set set2;
                    try {
                        set = (Set)Class.forName("com.google.java.contract.core.apt.JavacUtils").getMethod("getImportNames", ProcessingEnvironment.class, Element.class).invoke(null, this.utils.processingEnv, element2);
                        if (!contractContext.tryEnterContract()) break block18;
                    }
                    catch (Exception e) {
                        Set<String> set3 = Collections.emptySet();
                        if (contractContext.tryEnterContract()) {
                            Set<String> set4;
                            set3 = set4 = set3;
                            this.com$google$java$contract$Q$getImportNames((Element)element2, set4);
                            if (bl) {
                                this.com$google$java$contract$I();
                            }
                            contractContext.leaveContract();
                        }
                        if (bl) {
                            contractContext.leave(this);
                        }
                        return set3;
                    }
                    set = set2 = set;
                    this.com$google$java$contract$Q$getImportNames((Element)element2, set2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return set;
            }
            Set<String> set = Collections.emptySet();
            if (contractContext.tryEnterContract()) {
                Set<String> set5;
                set = set5 = set;
                this.com$google$java$contract$Q$getImportNames((Element)element2, set5);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return set;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getImportNames")
    private /* synthetic */ void com$google$java$contract$P$getImportNames(Element element) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$getImportNames(element, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getImportNames")
    private /* synthetic */ void com$google$java$contract$Q$getImportNames(Element element, Set<String> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$AbstractTypeBuilder$getImportNames(element, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"parent != null", "owner != null", "p != null"})
    protected void scanAnnotations(Element element, boolean bl, ClassName className, ElementModel elementModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void parent;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$scanAnnotations(element, bl, className, elementModel);
                contractContext.leaveContract();
            }
            for (AnnotationMirror annotationMirror : parent.getAnnotationMirrors()) {
                void p;
                void owner;
                void primary;
                this.visitAnnotation((Element)parent, annotationMirror, (boolean)primary, (ClassName)owner, (ElementModel)p);
            }
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="scanAnnotations")
    private /* synthetic */ void com$google$java$contract$P$scanAnnotations(Element parent, boolean primary, ClassName owner, ElementModel p) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$scanAnnotations(parent, primary, owner, p, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={49L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$AbstractTypeBuilder() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.utils != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("utils != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={56L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$AbstractTypeBuilder(FactoryUtils utils, DiagnosticManager diagnosticManager, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = utils != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("utils != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createBlankContractModel", lines={82L, 83L, 84L, 85L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$createBlankContractModel(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = parent != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = owner != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("owner != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.utils.isContractAnnotation(annotation);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("utils.isContractAnnotation(annotation)", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createBlankContractModel", lines={87L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$AbstractTypeBuilder$createBlankContractModel(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, ContractAnnotationModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createContractModel", lines={142L, 143L, 144L, 145L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$createContractModel(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = parent != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = owner != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("owner != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.utils.isContractAnnotation(annotation);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("utils.isContractAnnotation(annotation)", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="visitAnnotation", lines={207L, 208L, 209L, 210L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$visitAnnotation(Element parent, AnnotationMirror annotation, boolean primary, ClassName owner, ElementModel p, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = parent != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = owner != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("owner != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = p != null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("p != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={229L, 230L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$getLineNumbers(Element parent, AnnotationMirror annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = parent != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={232L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$AbstractTypeBuilder$getLineNumbers(Element parent, AnnotationMirror annotation, List<Long> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getImportNames", lines={255L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$getImportNames(Element element, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getImportNames", lines={256L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$AbstractTypeBuilder$getImportNames(Element element, Set<String> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="scanAnnotations", lines={282L, 283L, 284L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AbstractTypeBuilder$scanAnnotations(Element parent, boolean primary, ClassName owner, ElementModel p, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = parent != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = owner != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("owner != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = p != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("p != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }
}

