/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.agent.ContractMethodSignatures;
import com.google.java.contract.core.agent.LineNumberingMethodAdapter;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

@Invariant(value={"ContractMethodSignatures.isLineNumberList(lineNumbers)"})
class LineNumberingClassAdapter
extends ClassVisitor {
    protected List<Long> lineNumbers;

    @Requires(value={"cv != null", "ContractMethodSignatures.isLineNumberList(lineNumbers)"})
    public LineNumberingClassAdapter(ClassVisitor cv, List<Long> lineNumbers) {
        super(262144, cv);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$LineNumberingClassAdapter(cv, lineNumbers);
                contractContext.leaveContract();
            }
            this.lineNumbers = lineNumbers;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == LineNumberingClassAdapter.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == LineNumberingClassAdapter.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$LineNumberingClassAdapter(ClassVisitor cv, List<Long> lineNumbers) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$LineNumberingClassAdapter$LineNumberingClassAdapter(cv, lineNumbers, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$agent$LineNumberingClassAdapter();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void exceptions;
            void signature;
            void desc;
            void name;
            void access;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            MethodVisitor mv = this.cv.visitMethod((int)(access | 0x1000), (String)name, (String)desc, (String)signature, (String[])exceptions);
            LineNumberingMethodAdapter lineNumberingMethodAdapter = new LineNumberingMethodAdapter(mv, (int)(access | 0x1000), (String)name, (String)desc){

                @Override
                protected void onMethodEnter() {
                    this.lineNumbers = LineNumberingClassAdapter.this.lineNumbers;
                    super.onMethodEnter();
                }
            };
            if (contractContext.tryEnterContract()) {
                LineNumberingMethodAdapter lineNumberingMethodAdapter2;
                lineNumberingMethodAdapter = lineNumberingMethodAdapter2 = lineNumberingMethodAdapter;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return lineNumberingMethodAdapter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={33L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$LineNumberingClassAdapter() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ContractMethodSignatures.isLineNumberList(this.lineNumbers);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("ContractMethodSignatures.isLineNumberList(lineNumbers)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={44L, 45L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$LineNumberingClassAdapter$LineNumberingClassAdapter(ClassVisitor cv, List<Long> lineNumbers, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = cv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("cv != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = ContractMethodSignatures.isLineNumberList(lineNumbers);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("ContractMethodSignatures.isLineNumberList(lineNumbers)", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }
}

