/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractAnalyzer;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.agent.HelperClassAdapter;
import com.google.java.contract.core.agent.SpecificationClassAdapter;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.BlacklistManager;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.JavaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ContractClassFileTransformer
implements ClassFileTransformer {
    protected BlacklistManager blacklistManager;
    protected ClassLoader loader;
    protected Map<String, Set<String>> assignableToNames;
    protected Map<String, String> superClassNames;

    public ContractClassFileTransformer() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.assignableToNames = new HashMap<String, Set<String>>();
            this.superClassNames = new HashMap<String, String>();
            this.blacklistManager = BlacklistManager.getInstance();
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public ContractClassFileTransformer(ClassLoader loader) {
        this();
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.loader = loader;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            byte[] byArray2;
            block19: {
                byte[] byArray3;
                void bytecode;
                ContractAnalyzer contracts;
                void className;
                block15: {
                    byte[] byArray4;
                    block18: {
                        byte[] byArray5;
                        block16: {
                            byte[] byArray6;
                            block17: {
                                byte[] byArray7;
                                if (contractContext.tryEnterContract()) {
                                    contractContext.leaveContract();
                                }
                                if (this.blacklistManager.isIgnored((String)className)) {
                                    DebugUtils.info("agent", "ignoring " + (String)className);
                                    byte[] byArray8 = null;
                                    if (contractContext.tryEnterContract()) {
                                        byte[] byArray9;
                                        byArray8 = byArray9 = byArray8;
                                        contractContext.leaveContract();
                                    }
                                    if (bl) {
                                        contractContext.leave(this);
                                    }
                                    return byArray8;
                                }
                                try {
                                    void loader;
                                    this.loader = loader;
                                    contracts = this.analyze((String)className);
                                    if (contracts != null) break block15;
                                    if (!className.endsWith("$com$google$java$contract$H")) break block16;
                                    DebugUtils.info("agent", "adding source info to " + (String)className);
                                    byArray6 = this.instrumentWithDebug((byte[])bytecode);
                                    if (!contractContext.tryEnterContract()) break block17;
                                }
                                catch (Throwable e) {
                                    DebugUtils.err("agent", "while instrumenting " + (String)className, e);
                                    throw new RuntimeException(e);
                                }
                                byArray6 = byArray7 = byArray6;
                                contractContext.leaveContract();
                            }
                            if (bl) {
                                contractContext.leave(this);
                            }
                            return byArray6;
                        }
                        byArray4 = null;
                        if (!contractContext.tryEnterContract()) break block18;
                        byArray4 = byArray5 = byArray4;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return byArray4;
                }
                DebugUtils.info("agent", "adding contracts to " + (String)className);
                byArray2 = this.instrumentWithContracts((byte[])bytecode, contracts);
                if (!contractContext.tryEnterContract()) break block19;
                byArray2 = byArray3 = byArray2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"bytecode != null", "contractBytecode != null"})
    @Ensures(value={"result != null"})
    public byte[] transformWithContracts(byte[] byArray, byte[] byArray2) throws IllegalClassFormatException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            byte[] byArray3;
            block8: {
                byte[] byArray4;
                void bytecode;
                void contractBytecode;
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$transformWithContracts(byArray, byArray2);
                    contractContext.leaveContract();
                }
                try {
                    ContractAnalyzer contracts = this.extractContracts(new ClassReader((byte[])contractBytecode));
                    byArray3 = this.instrumentWithContracts((byte[])bytecode, contracts);
                    if (!contractContext.tryEnterContract()) break block8;
                }
                catch (Throwable t) {
                    IllegalClassFormatException e = new IllegalClassFormatException();
                    e.initCause(t);
                    throw e;
                }
                byArray3 = byArray4 = byArray3;
                this.com$google$java$contract$Q$transformWithContracts((byte[])bytecode, (byte[])contractBytecode, byArray4);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byArray3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="transformWithContracts")
    private /* synthetic */ void com$google$java$contract$P$transformWithContracts(byte[] bytecode, byte[] contractBytecode) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithContracts(bytecode, contractBytecode, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="transformWithContracts")
    private /* synthetic */ void com$google$java$contract$Q$transformWithContracts(byte[] bytecode, byte[] contractBytecode, byte[] result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithContracts(bytecode, contractBytecode, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"bytecode != null"})
    @Ensures(value={"result != null"})
    public byte[] transformWithDebug(byte[] byArray) throws IllegalClassFormatException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            byte[] byArray2;
            block8: {
                byte[] byArray3;
                void bytecode;
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$transformWithDebug(byArray);
                    contractContext.leaveContract();
                }
                try {
                    byArray2 = this.instrumentWithDebug((byte[])bytecode);
                    if (!contractContext.tryEnterContract()) break block8;
                }
                catch (Throwable t) {
                    IllegalClassFormatException e = new IllegalClassFormatException();
                    e.initCause(t);
                    throw e;
                }
                byArray2 = byArray3 = byArray2;
                this.com$google$java$contract$Q$transformWithDebug((byte[])bytecode, byArray3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="transformWithDebug")
    private /* synthetic */ void com$google$java$contract$P$transformWithDebug(byte[] bytecode) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithDebug(bytecode, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="transformWithDebug")
    private /* synthetic */ void com$google$java$contract$Q$transformWithDebug(byte[] bytecode, byte[] result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithDebug(bytecode, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"ClassName.isBinaryName(className)"})
    protected ContractAnalyzer analyze(String string) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void className;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$analyze(string);
                contractContext.leaveContract();
            }
            if (className.endsWith("$com$google$java$contract$H")) {
                ContractAnalyzer contractAnalyzer = null;
                if (contractContext.tryEnterContract()) {
                    ContractAnalyzer contractAnalyzer2;
                    contractAnalyzer = contractAnalyzer2 = contractAnalyzer;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return contractAnalyzer;
            }
            String helperFileName = (String)className + "$com$google$java$contract$H" + JavaFileObject.Kind.CLASS.extension;
            if (JavaUtils.resourceExists(this.loader, helperFileName)) {
                ContractAnalyzer contractAnalyzer = null;
                if (contractContext.tryEnterContract()) {
                    ContractAnalyzer contractAnalyzer3;
                    contractAnalyzer = contractAnalyzer3 = contractAnalyzer;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return contractAnalyzer;
            }
            InputStream contractStream = JavaUtils.getContractClassInputStream(this.loader, (String)className);
            if (contractStream == null) {
                ContractAnalyzer contractAnalyzer = null;
                if (contractContext.tryEnterContract()) {
                    ContractAnalyzer contractAnalyzer4;
                    contractAnalyzer = contractAnalyzer4 = contractAnalyzer;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return contractAnalyzer;
            }
            ContractAnalyzer contractAnalyzer = this.extractContracts(new ClassReader(contractStream));
            if (contractContext.tryEnterContract()) {
                ContractAnalyzer contractAnalyzer5;
                contractAnalyzer = contractAnalyzer5 = contractAnalyzer;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractAnalyzer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="analyze")
    private /* synthetic */ void com$google$java$contract$P$analyze(String className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$analyze(className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"reader != null"})
    protected ContractAnalyzer extractContracts(ClassReader classReader) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void reader;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$extractContracts(classReader);
                contractContext.leaveContract();
            }
            ContractAnalyzer contractAnalyzer = new ContractAnalyzer();
            reader.accept(contractAnalyzer, 8);
            ContractAnalyzer contractAnalyzer2 = contractAnalyzer;
            if (contractContext.tryEnterContract()) {
                ContractAnalyzer contractAnalyzer3;
                contractAnalyzer2 = contractAnalyzer3 = contractAnalyzer2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractAnalyzer2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="extractContracts")
    private /* synthetic */ void com$google$java$contract$P$extractContracts(ClassReader reader) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$extractContracts(reader, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"bytecode != null", "contracts != null"})
    @Ensures(value={"result != null"})
    protected byte[] instrumentWithContracts(byte[] byArray, ContractAnalyzer contractAnalyzer) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void contracts;
            void bytecode;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$instrumentWithContracts(byArray, contractAnalyzer);
                contractContext.leaveContract();
            }
            ClassReader reader = new ClassReader((byte[])bytecode);
            NonLoadingClassWriter writer = new NonLoadingClassWriter(reader, 3);
            SpecificationClassAdapter adapter = new SpecificationClassAdapter(writer, (ContractAnalyzer)contracts);
            reader.accept(adapter, 8);
            byte[] byArray2 = writer.toByteArray();
            if (contractContext.tryEnterContract()) {
                byte[] byArray3;
                byArray2 = byArray3 = byArray2;
                this.com$google$java$contract$Q$instrumentWithContracts((byte[])bytecode, (ContractAnalyzer)contracts, byArray3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="instrumentWithContracts")
    private /* synthetic */ void com$google$java$contract$P$instrumentWithContracts(byte[] bytecode, ContractAnalyzer contracts) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithContracts(bytecode, contracts, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="instrumentWithContracts")
    private /* synthetic */ void com$google$java$contract$Q$instrumentWithContracts(byte[] bytecode, ContractAnalyzer contracts, byte[] result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithContracts(bytecode, contracts, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"bytecode != null"})
    @Ensures(value={"result != null"})
    private byte[] instrumentWithDebug(byte[] byArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void bytecode;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$instrumentWithDebug(byArray);
                contractContext.leaveContract();
            }
            ClassReader reader = new ClassReader((byte[])bytecode);
            NonLoadingClassWriter writer = new NonLoadingClassWriter(reader, 0);
            reader.accept(new HelperClassAdapter(writer), 8);
            byte[] byArray2 = writer.toByteArray();
            if (contractContext.tryEnterContract()) {
                byte[] byArray3;
                byArray2 = byArray3 = byArray2;
                this.com$google$java$contract$Q$instrumentWithDebug((byte[])bytecode, byArray3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="instrumentWithDebug")
    private /* synthetic */ void com$google$java$contract$P$instrumentWithDebug(byte[] bytecode) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithDebug(bytecode, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="instrumentWithDebug")
    private /* synthetic */ void com$google$java$contract$Q$instrumentWithDebug(byte[] bytecode, byte[] result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithDebug(bytecode, result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transformWithContracts", lines={290L, 291L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithContracts(byte[] bytecode, byte[] contractBytecode, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = bytecode != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("bytecode != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = contractBytecode != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("contractBytecode != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transformWithContracts", lines={293L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithContracts(byte[] bytecode, byte[] contractBytecode, byte[] result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transformWithDebug", lines={311L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithDebug(byte[] bytecode, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = bytecode != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("bytecode != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="transformWithDebug", lines={312L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$transformWithDebug(byte[] bytecode, byte[] result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="analyze", lines={332L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$analyze(String className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isBinaryName(className);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="extractContracts", lines={360L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$extractContracts(ClassReader reader, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = reader != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("reader != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="instrumentWithContracts", lines={377L, 378L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithContracts(byte[] bytecode, ContractAnalyzer contracts, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = bytecode != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("bytecode != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = contracts != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("contracts != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="instrumentWithContracts", lines={380L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithContracts(byte[] bytecode, ContractAnalyzer contracts, byte[] result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="instrumentWithDebug", lines={400L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithDebug(byte[] bytecode, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = bytecode != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("bytecode != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="instrumentWithDebug", lines={401L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractClassFileTransformer$instrumentWithDebug(byte[] bytecode, byte[] result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    protected class NonLoadingClassWriter
    extends ClassWriter {
        @Requires(value={"reader != null"})
        public NonLoadingClassWriter(ClassReader reader, int flags) {
            super(reader, flags);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected String getCommonSuperClass(String string, String string2) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void className2;
                String className1;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (className1.equals(className2)) {
                    void v0 = className1;
                    if (contractContext.tryEnterContract()) {
                        void var5_5;
                        v0 = var5_5 = v0;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return v0;
                }
                SuperInfoFinder superInfoFinder = new SuperInfoFinder();
                SuperInfoFinder.access$100(superInfoFinder, className1);
                SuperInfoFinder.access$100(superInfoFinder, (String)className2);
                if (ContractClassFileTransformer.this.assignableToNames.get(className1).contains(className2)) {
                    void v1 = className2;
                    if (contractContext.tryEnterContract()) {
                        void var7_7;
                        v1 = var7_7 = v1;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return v1;
                }
                while (!ContractClassFileTransformer.this.assignableToNames.get(className2).contains(className1)) {
                    className1 = ContractClassFileTransformer.this.superClassNames.get(className1);
                }
                void v2 = className1;
                if (contractContext.tryEnterContract()) {
                    void var8_8;
                    v2 = var8_8 = v2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return v2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={185L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$NonLoadingClassWriter$NonLoadingClassWriter(ClassReader reader, int flags, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = reader != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("reader != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }
    }

    private class SuperInfoFinder
    extends ClassVisitor {
        private SuperInfoFinder() {
            super(262144);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void interfaces;
                void superName;
                void signature;
                void name;
                void access;
                void version;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                super.visit((int)version, (int)access, (String)name, (String)signature, (String)superName, (String[])interfaces);
                HashSet<void> assignable = new HashSet<void>();
                assignable.add(name);
                ContractClassFileTransformer.this.assignableToNames.put((String)name, assignable);
                if (superName != null) {
                    ContractClassFileTransformer.this.superClassNames.put((String)name, (String)superName);
                    assignable.add(superName);
                    this.findSuperInfo((String)superName);
                    assignable.addAll((Collection)ContractClassFileTransformer.this.assignableToNames.get(superName));
                }
                for (void ifaceName : interfaces) {
                    assignable.add(ifaceName);
                    this.findSuperInfo((String)ifaceName);
                    assignable.addAll((Collection)ContractClassFileTransformer.this.assignableToNames.get(ifaceName));
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Requires(value={"ClassName.isBinaryName(className)"})
        private void findSuperInfo(String string) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void className;
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$findSuperInfo(string);
                    contractContext.leaveContract();
                }
                if (ContractClassFileTransformer.this.superClassNames.containsKey(className)) {
                    if (contractContext.tryEnterContract()) {
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return;
                }
                if (ContractClassFileTransformer.this.blacklistManager.isIgnored(new ClassName((String)className).getQualifiedName())) {
                    this.findSuperInfoFromClass((String)className);
                } else {
                    this.findSuperInfoFromClassFile((String)className);
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="findSuperInfo")
        private /* synthetic */ void com$google$java$contract$P$findSuperInfo(String className) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$findSuperInfo(className, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        /*
         * WARNING - void declaration
         */
        @Requires(value={"ClassName.isBinaryName(className)"})
        private void findSuperInfoFromClassFile(String string) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void className;
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$findSuperInfoFromClassFile(string);
                    contractContext.leaveContract();
                }
                try {
                    InputStream stream = JavaUtils.getClassInputStream(ContractClassFileTransformer.this.loader, (String)className);
                    if (stream == null) {
                        throw new NullPointerException();
                    }
                    ClassReader reader = new ClassReader(stream);
                    reader.accept(this, 0);
                }
                catch (Exception e) {
                    this.addDefaultAssignable((String)className);
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="findSuperInfoFromClassFile")
        private /* synthetic */ void com$google$java$contract$P$findSuperInfoFromClassFile(String className) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$findSuperInfoFromClassFile(className, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        /*
         * WARNING - void declaration
         */
        @Requires(value={"ClassName.isBinaryName(className)"})
        private void findSuperInfoFromClass(String string) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                Class<?> clazz;
                void className;
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$findSuperInfoFromClass(string);
                    contractContext.leaveContract();
                }
                try {
                    String qName = new ClassName((String)className).getQualifiedName();
                    clazz = Class.forName(qName, false, ContractClassFileTransformer.this.loader);
                }
                catch (ClassNotFoundException e) {
                    this.addDefaultAssignable((String)className);
                    if (contractContext.tryEnterContract()) {
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return;
                }
                Class<?> superClass = clazz.getSuperclass();
                if (superClass == null) {
                    this.addDefaultAssignable((String)className);
                    if (contractContext.tryEnterContract()) {
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return;
                }
                HashSet<Object> assignable = new HashSet<Object>();
                assignable.add(className);
                ContractClassFileTransformer.this.assignableToNames.put((String)className, assignable);
                String superName = superClass.getName().replace('.', '/');
                ContractClassFileTransformer.this.superClassNames.put((String)className, superName);
                assignable.add(superName);
                this.findSuperInfo(superName);
                assignable.addAll((Collection)ContractClassFileTransformer.this.assignableToNames.get(superName));
                for (Class<?> iface : clazz.getInterfaces()) {
                    String ifaceName = iface.getName().replace('.', '/');
                    assignable.add(ifaceName);
                    this.findSuperInfo(ifaceName);
                    assignable.addAll((Collection)ContractClassFileTransformer.this.assignableToNames.get(ifaceName));
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="findSuperInfoFromClass")
        private /* synthetic */ void com$google$java$contract$P$findSuperInfoFromClass(String className) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$findSuperInfoFromClass(className, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        /*
         * WARNING - void declaration
         */
        @Requires(value={"className != null"})
        private void addDefaultAssignable(String string) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void className;
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$addDefaultAssignable(string);
                    contractContext.leaveContract();
                }
                if (!ContractClassFileTransformer.this.superClassNames.containsKey(className)) {
                    ContractClassFileTransformer.this.superClassNames.put((String)className, "java/lang/Object");
                }
                HashSet<Object> assignable = new HashSet<Object>();
                assignable.add(className);
                assignable.add("java/lang/Object");
                ContractClassFileTransformer.this.assignableToNames.put((String)className, assignable);
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="addDefaultAssignable")
        private /* synthetic */ void com$google$java$contract$P$addDefaultAssignable(String className) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$addDefaultAssignable(className, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$100(SuperInfoFinder superInfoFinder, String string) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(SuperInfoFinder.class);
            try {
                void x1;
                SuperInfoFinder x0;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                x0.findSuperInfo((String)x1);
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(SuperInfoFinder.class);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(SuperInfoFinder.class);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="findSuperInfo", lines={98L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$findSuperInfo(String className, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = ClassName.isBinaryName(className);
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="findSuperInfoFromClassFile", lines={111L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$findSuperInfoFromClassFile(String className, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = ClassName.isBinaryName(className);
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="findSuperInfoFromClass", lines={124L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$findSuperInfoFromClass(String className, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = ClassName.isBinaryName(className);
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="addDefaultAssignable", lines={165L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractClassFileTransformer$SuperInfoFinder$addDefaultAssignable(String className, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = className != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("className != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }
    }
}

