/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract;

import java.util.ArrayList;
import java.util.List;

public abstract class ContractAssertionError
extends AssertionError {
    public ContractAssertionError(String msg) {
        super((Object)msg);
        this.cleanStackTrace();
    }

    public ContractAssertionError(String msg, Throwable throwable) {
        this(throwable == null ? msg : "evaluating \"" + msg + "\" caused " + throwable.getClass().getSimpleName());
    }

    public ContractAssertionError(String msg, ContractAssertionError cause) {
        super((Object)msg);
        this.initCause((Throwable)((Object)cause));
        this.cleanStackTrace();
    }

    public ContractAssertionError(String msg, ContractAssertionError cause, Throwable throwable) {
        this(throwable == null ? msg : "evaluating \"" + msg + "\" caused " + throwable.getClass().getSimpleName(), cause);
    }

    private void cleanStackTrace() {
        StackTraceElement[] realTrace = this.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[realTrace.length - 1];
        StackTraceElement top = realTrace[0];
        trace[0] = new StackTraceElement(top.getClassName(), this.getMethodName(realTrace[2].getMethodName()), top.getFileName(), top.getLineNumber());
        System.arraycopy(realTrace, 2, trace, 1, realTrace.length - 2);
        this.setStackTrace(trace);
    }

    public List<String> getMessages() {
        ArrayList<String> list = new ArrayList<String>();
        Object error = this;
        do {
            list.add(((Throwable)error).getMessage());
        } while ((error = ((Throwable)error).getCause()) != null);
        return list;
    }

    protected abstract String getMethodName(String var1);
}

