/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.testing.throwingproviders;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.ThrowableSubject;
import com.google.common.truth.Truth;
import com.google.inject.throwingproviders.CheckedProvider;
import javax.annotation.Nullable;

public final class CheckedProviderSubject<T, P extends CheckedProvider<T>>
extends Subject {
    private final P provider;

    public static <T, P extends CheckedProvider<T>> Subject.Factory<CheckedProviderSubject<T, P>, P> checkedProviders() {
        return new CheckedProviderSubjectFactory();
    }

    public static <T, P extends CheckedProvider<T>> CheckedProviderSubject<T, P> assertThat(@Nullable P provider) {
        return (CheckedProviderSubject)Truth.assertAbout(CheckedProviderSubject.checkedProviders()).that(provider);
    }

    private CheckedProviderSubject(FailureMetadata failureMetadata, @Nullable P subject) {
        super(failureMetadata, subject);
        this.provider = subject;
    }

    public Subject providedValue() {
        Object got;
        try {
            got = this.provider.get();
        }
        catch (Exception e) {
            this.failWithCauseAndMessage(e, "checked provider was not expected to throw an exception");
            return this.ignoreCheck().that(new Object());
        }
        return this.check("get()", new Object[0]).that(got);
    }

    public ThrowableSubject thrownException() {
        Object got;
        try {
            got = this.provider.get();
        }
        catch (Throwable e) {
            return this.check("get()'s exception", new Object[0]).that(e);
        }
        this.failWithoutActual(Fact.simpleFact((String)"expected to throw"), new Fact[]{Fact.fact((String)"but provided", (Object)got)});
        return this.ignoreCheck().that(new Throwable());
    }

    private void failWithCauseAndMessage(Throwable cause, String message) {
        ((UnexpectedFailureSubject)this.check("get()", new Object[0]).about(CheckedProviderSubject.unexpectedFailures()).that((Object)cause)).doFail(message);
    }

    private static Subject.Factory<UnexpectedFailureSubject, Throwable> unexpectedFailures() {
        return new Subject.Factory<UnexpectedFailureSubject, Throwable>(){

            public UnexpectedFailureSubject createSubject(FailureMetadata metadata, Throwable actual) {
                return new UnexpectedFailureSubject(metadata, actual);
            }
        };
    }

    /* synthetic */ CheckedProviderSubject(FailureMetadata x0, CheckedProvider x1, 1 x2) {
        this(x0, x1);
    }

    private static final class UnexpectedFailureSubject
    extends Subject {
        UnexpectedFailureSubject(FailureMetadata metadata, @Nullable Throwable actual) {
            super(metadata, (Object)actual);
        }

        void doFail(String message) {
            this.failWithoutActual(Fact.simpleFact((String)message), new Fact[0]);
        }
    }

    private static final class CheckedProviderSubjectFactory<T, P extends CheckedProvider<T>>
    implements Subject.Factory<CheckedProviderSubject<T, P>, P> {
        private CheckedProviderSubjectFactory() {
        }

        public CheckedProviderSubject<T, P> createSubject(FailureMetadata failureMetadata, @Nullable P target) {
            return new CheckedProviderSubject(failureMetadata, (CheckedProvider)target, null);
        }
    }
}

