/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.appengine.http;

import com.google.api.client.extensions.appengine.http.UrlFetchRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public final class UrlFetchTransport
extends HttpTransport {
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "HEAD", "POST", "PUT"};

    public boolean supportsMethod(String method) {
        return Arrays.binarySearch(SUPPORTED_METHODS, method) >= 0;
    }

    protected UrlFetchRequest buildRequest(String method, String url) throws IOException {
        Preconditions.checkArgument((boolean)this.supportsMethod(method), (String)"HTTP method %s not supported", (Object[])new Object[]{method});
        HTTPMethod httpMethod = method.equals("DELETE") ? HTTPMethod.DELETE : (method.equals("GET") ? HTTPMethod.GET : (method.equals("HEAD") ? HTTPMethod.HEAD : (method.equals("POST") ? HTTPMethod.POST : HTTPMethod.PUT)));
        return new UrlFetchRequest(httpMethod, url);
    }

    @Deprecated
    public boolean supportsHead() {
        return true;
    }

    @Deprecated
    public LowLevelHttpRequest buildDeleteRequest(String url) throws IOException {
        return this.buildRequest("DELETE", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildGetRequest(String url) throws IOException {
        return this.buildRequest("GET", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildHeadRequest(String url) throws IOException {
        return this.buildRequest("HEAD", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildPostRequest(String url) throws IOException {
        return this.buildRequest("POST", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildPutRequest(String url) throws IOException {
        return this.buildRequest("PUT", url);
    }

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }
}

