/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v5;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v5.Apache5HttpRequest;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;

public final class Apache5HttpTransport
extends HttpTransport {
    private final HttpClient httpClient;
    private final boolean isMtls;

    public Apache5HttpTransport() {
        this(Apache5HttpTransport.newDefaultHttpClient(), false);
    }

    public Apache5HttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.isMtls = false;
    }

    @Beta
    public Apache5HttpTransport(HttpClient httpClient, boolean isMtls) {
        this.httpClient = httpClient;
        this.isMtls = isMtls;
    }

    public static HttpClient newDefaultHttpClient() {
        return Apache5HttpTransport.newDefaultHttpClientBuilder().build();
    }

    public static HttpClientBuilder newDefaultHttpClientBuilder() {
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactory.getSocketFactory()).setMaxConnTotal(200).setMaxConnPerRoute(20).setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive(-1L, TimeUnit.MILLISECONDS).build()).build();
        return HttpClients.custom().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).disableRedirectHandling().disableAutomaticRetries();
    }

    public boolean supportsMethod(String method) {
        return true;
    }

    protected Apache5HttpRequest buildRequest(String method, String url) {
        Object requestBase = method.equals("DELETE") ? new HttpDelete(url) : (method.equals("GET") ? new HttpGet(url) : (method.equals("HEAD") ? new HttpHead(url) : (method.equals("PATCH") ? new HttpPatch(url) : (method.equals("POST") ? new HttpPost(url) : (method.equals("PUT") ? new HttpPut(url) : (method.equals("TRACE") ? new HttpTrace(url) : (method.equals("OPTIONS") ? new HttpOptions(url) : new HttpUriRequestBase((String)Preconditions.checkNotNull((Object)method), URI.create(url)))))))));
        return new Apache5HttpRequest(this.httpClient, (HttpUriRequestBase)requestBase);
    }

    public void shutdown() throws IOException {
        if (this.httpClient instanceof ModalCloseable) {
            ((ModalCloseable)this.httpClient).close(CloseMode.GRACEFUL);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public boolean isMtls() {
        return this.isMtls;
    }
}

