/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.android.util.store;

import com.google.api.client.util.IOUtils;
import com.google.api.client.util.Maps;
import com.google.api.client.util.store.AbstractDataStoreFactory;
import com.google.api.client.util.store.AbstractMemoryDataStore;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;

public class FileDataStoreFactory
extends AbstractDataStoreFactory {
    private static final Logger LOGGER = Logger.getLogger(FileDataStoreFactory.class.getName());
    private final File dataDirectory;

    public FileDataStoreFactory(File dataDirectory) throws IOException {
        dataDirectory = dataDirectory.getCanonicalFile();
        if (IOUtils.isSymbolicLink((File)dataDirectory)) {
            throw new IOException("unable to use a symbolic link: " + dataDirectory);
        }
        if (!dataDirectory.exists() && !dataDirectory.mkdirs()) {
            throw new IOException("unable to create directory: " + dataDirectory);
        }
        this.dataDirectory = dataDirectory;
        FileDataStoreFactory.setPermissionsToOwnerOnly(dataDirectory);
    }

    public final File getDataDirectory() {
        return this.dataDirectory;
    }

    protected <V extends Serializable> DataStore<V> createDataStore(String id) throws IOException {
        return new FileDataStore(this, this.dataDirectory, id);
    }

    static void setPermissionsToOwnerOnly(File file) {
        try {
            if (!(file.setReadable(false, false) && file.setWritable(false, false) && file.setExecutable(false, false))) {
                LOGGER.warning("unable to change permissions for everybody: " + file);
            }
            if (!(file.setReadable(true, true) && file.setWritable(true, true) && file.setExecutable(true, true))) {
                LOGGER.warning("unable to change permissions for owner: " + file);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class FileDataStore<V extends Serializable>
    extends AbstractMemoryDataStore<V> {
        private final File dataFile;

        FileDataStore(FileDataStoreFactory dataStore, File dataDirectory, String id) throws IOException {
            super((DataStoreFactory)dataStore, id);
            this.dataFile = new File(dataDirectory, id);
            if (IOUtils.isSymbolicLink((File)this.dataFile)) {
                throw new IOException("unable to use a symbolic link: " + this.dataFile);
            }
            if (this.dataFile.createNewFile()) {
                this.keyValueMap = Maps.newHashMap();
                this.save();
            } else {
                this.keyValueMap = (HashMap)IOUtils.deserialize((InputStream)new FileInputStream(this.dataFile));
            }
        }

        public void save() throws IOException {
            IOUtils.serialize((Object)this.keyValueMap, (OutputStream)new FileOutputStream(this.dataFile));
        }

        public FileDataStoreFactory getDataStoreFactory() {
            return (FileDataStoreFactory)super.getDataStoreFactory();
        }
    }
}

