/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import java.util.NoSuchElementException;

public final class InternalPreconditions {
    private static final String CHECK_TYPE = System.getProperty("jre.checks.type");
    private static final String CHECK_BOUNDS = System.getProperty("jre.checks.bounds");
    private static final String CHECK_API = System.getProperty("jre.checks.api");
    private static final boolean LEVEL_NORMAL_OR_HIGHER = System.getProperty("jre.checks.checkLevel").equals("NORMAL");
    private static final boolean LEVEL_OPT_OR_HIGHER = System.getProperty("jre.checks.checkLevel").equals("OPTIMIZED") || LEVEL_NORMAL_OR_HIGHER;
    private static final boolean LEVEL_MINIMAL_OR_HIGHER;
    private static final boolean IS_TYPE_CHECKED;
    private static final boolean IS_BOUNDS_CHECKED;
    private static final boolean IS_API_CHECKED;
    private static final boolean IS_ASSERTED;

    public static boolean isTypeChecked() {
        return IS_TYPE_CHECKED || IS_ASSERTED;
    }

    public static boolean isApiChecked() {
        return IS_API_CHECKED || IS_ASSERTED;
    }

    public static void checkType(boolean expression) {
        if (IS_TYPE_CHECKED) {
            InternalPreconditions.checkCriticalType(expression);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalType(expression);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalType(boolean expression) {
        if (!expression) {
            throw new ClassCastException();
        }
    }

    public static void checkArrayType(boolean expression) {
        if (IS_TYPE_CHECKED) {
            InternalPreconditions.checkCriticalArrayType(expression);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalArrayType(expression);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalArrayType(boolean expression) {
        if (!expression) {
            throw new ArrayStoreException();
        }
    }

    public static void checkArrayType(boolean expression, Object errorMessage) {
        if (IS_TYPE_CHECKED) {
            InternalPreconditions.checkCriticalArrayType(expression, errorMessage);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalArrayType(expression, errorMessage);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalArrayType(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ArrayStoreException(String.valueOf(errorMessage));
        }
    }

    public static void checkElement(boolean expression) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalElement(expression);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalElement(expression);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalElement(boolean expression) {
        if (!expression) {
            throw new NoSuchElementException();
        }
    }

    public static void checkElement(boolean expression, Object errorMessage) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalElement(expression, errorMessage);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalElement(expression, errorMessage);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalElement(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new NoSuchElementException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalArgument(expression);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalArgument(expression);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalArgument(expression, errorMessage);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalArgument(expression, errorMessage);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalArgument(expression, errorMessageTemplate, errorMessageArgs);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalArgument(expression, errorMessageTemplate, errorMessageArgs);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(InternalPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalState(expression);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalState(expression);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalState(expression, errorMessage);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalState(expression, errorMessage);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalNotNull(reference);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalNotNull(reference);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return reference;
    }

    public static <T> T checkCriticalNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static void checkNotNull(Object reference, Object errorMessage) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalNotNull(reference, errorMessage);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalNotNull(reference, errorMessage);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalNotNull(Object reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
    }

    public static void checkArraySize(int size) {
        if (IS_API_CHECKED) {
            InternalPreconditions.checkCriticalArraySize(size);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalArraySize(size);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalArraySize(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("Negative array size: " + size);
        }
    }

    public static void checkElementIndex(int index, int size) {
        if (IS_BOUNDS_CHECKED) {
            InternalPreconditions.checkCriticalElementIndex(index, size);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalElementIndex(index, size);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalElementIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    public static void checkPositionIndex(int index, int size) {
        if (IS_BOUNDS_CHECKED) {
            InternalPreconditions.checkCriticalPositionIndex(index, size);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalPositionIndex(index, size);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalPositionIndex(int index, int size) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (IS_BOUNDS_CHECKED) {
            InternalPreconditions.checkCriticalPositionIndexes(start, end, size);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalPositionIndexes(start, end, size);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalPositionIndexes(int start, int end, int size) {
        if (start < 0 || end > size) {
            throw new IndexOutOfBoundsException("fromIndex: " + start + ", toIndex: " + end + ", size: " + size);
        }
        if (start > end) {
            throw new IllegalArgumentException("fromIndex: " + start + " > toIndex: " + end);
        }
    }

    public static void checkCriticalArrayBounds(int start, int end, int length) {
        if (start > end) {
            throw new IllegalArgumentException("fromIndex: " + start + " > toIndex: " + end);
        }
        if (start < 0 || end > length) {
            throw new ArrayIndexOutOfBoundsException("fromIndex: " + start + ", toIndex: " + end + ", length: " + length);
        }
    }

    public static void checkCriticalStringBounds(int start, int end, int length) {
        if (start < 0 || end > length || end < start) {
            throw new StringIndexOutOfBoundsException("fromIndex: " + start + ", toIndex: " + end + ", length: " + length);
        }
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private InternalPreconditions() {
    }

    static {
        boolean bl = LEVEL_MINIMAL_OR_HIGHER = System.getProperty("jre.checks.checkLevel").equals("MINIMAL") || LEVEL_OPT_OR_HIGHER;
        if (!LEVEL_MINIMAL_OR_HIGHER) {
            throw new IllegalStateException("Incorrect level: " + System.getProperty("jre.checks.checkLevel"));
        }
        IS_TYPE_CHECKED = CHECK_TYPE.equals("AUTO") && LEVEL_OPT_OR_HIGHER || CHECK_TYPE.equals("ENABLED");
        IS_BOUNDS_CHECKED = CHECK_BOUNDS.equals("AUTO") && LEVEL_NORMAL_OR_HIGHER || CHECK_BOUNDS.equals("ENABLED");
        IS_API_CHECKED = CHECK_API.equals("AUTO") && LEVEL_NORMAL_OR_HIGHER || CHECK_API.equals("ENABLED");
        IS_ASSERTED = System.getProperty("jre.checkedMode").equals("ENABLED");
    }
}

