/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.Group;
import com.google.gwt.validation.client.impl.GroupChain;
import com.google.gwt.validation.client.impl.metadata.ValidationGroupsMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.ValidationException;

public class GroupChainGenerator {
    private final ValidationGroupsMetadata validationGroupsMetadata;
    private final Map<Class<?>, List<Group>> resolvedSequences = new HashMap();

    public GroupChainGenerator(ValidationGroupsMetadata validationGroupsMetadata) {
        this.validationGroupsMetadata = validationGroupsMetadata;
    }

    public GroupChain getGroupChainFor(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("At least one group has to be specified.");
        }
        for (Class<?> clazz : groups) {
            if (this.validationGroupsMetadata.containsGroup(clazz) || this.validationGroupsMetadata.isSeqeuence(clazz)) continue;
            throw new ValidationException("The class " + clazz + " is not a valid group or sequence.");
        }
        GroupChain chain = new GroupChain();
        for (Class<?> clazz : groups) {
            if (this.isGroupSequence(clazz)) {
                this.insertSequence(clazz, chain);
                continue;
            }
            Group group = new Group(clazz);
            chain.insertGroup(group);
            this.insertInheritedGroups(clazz, chain);
        }
        return chain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GroupChainGenerator");
        sb.append("{resolvedSequences=").append(this.resolvedSequences);
        sb.append('}');
        return sb.toString();
    }

    private void addGroups(List<Group> resolvedGroupSequence, List<Group> groups) {
        for (Group tmpGroup : groups) {
            if (resolvedGroupSequence.contains(tmpGroup) && resolvedGroupSequence.indexOf(tmpGroup) < resolvedGroupSequence.size() - 1) {
                throw new GroupDefinitionException("Unable to expand group sequence.");
            }
            resolvedGroupSequence.add(tmpGroup);
        }
    }

    private void addInheritedGroups(Group group, List<Group> expandedGroups) {
        Set<Class<?>> inheritedGroups = this.validationGroupsMetadata.getParentsOfGroup(group.getGroup());
        if (inheritedGroups != null) {
            for (Class<?> inheritedGroup : inheritedGroups) {
                if (this.isGroupSequence(inheritedGroup)) {
                    throw new GroupDefinitionException("Sequence definitions are not allowed as composing parts of a sequence.");
                }
                Group g = new Group(inheritedGroup, group.getSequence());
                expandedGroups.add(g);
                this.addInheritedGroups(g, expandedGroups);
            }
        }
    }

    private List<Group> expandInhertitedGroups(List<Group> sequence) {
        ArrayList<Group> expandedGroup = new ArrayList<Group>();
        for (Group group : sequence) {
            expandedGroup.add(group);
            this.addInheritedGroups(group, expandedGroup);
        }
        return expandedGroup;
    }

    private void insertInheritedGroups(Class<?> clazz, GroupChain chain) {
        for (Class<?> inheritedGroup : this.validationGroupsMetadata.getParentsOfGroup(clazz)) {
            Group group = new Group(inheritedGroup);
            chain.insertGroup(group);
            this.insertInheritedGroups(inheritedGroup, chain);
        }
    }

    private void insertSequence(Class<?> clazz, GroupChain chain) {
        List<Group> sequence;
        if (this.resolvedSequences.containsKey(clazz)) {
            sequence = this.resolvedSequences.get(clazz);
        } else {
            sequence = this.resolveSequence(clazz, new ArrayList());
            sequence = this.expandInhertitedGroups(sequence);
        }
        chain.insertSequence(sequence);
    }

    private boolean isGroupSequence(Class<?> clazz) {
        return this.validationGroupsMetadata.isSeqeuence(clazz);
    }

    private List<Group> resolveSequence(Class<?> group, List<Class<?>> processedSequences) {
        if (processedSequences.contains(group)) {
            throw new GroupDefinitionException("Cyclic dependency in groups definition");
        }
        processedSequences.add(group);
        ArrayList<Group> resolvedGroupSequence = new ArrayList<Group>();
        List<Class<?>> sequenceList = this.validationGroupsMetadata.getSequenceList(group);
        for (Class<?> clazz : sequenceList) {
            if (this.isGroupSequence(clazz)) {
                List<Group> tmpSequence = this.resolveSequence(clazz, processedSequences);
                this.addGroups(resolvedGroupSequence, tmpSequence);
                continue;
            }
            ArrayList<Group> list = new ArrayList<Group>();
            list.add(new Group(clazz, group));
            this.addGroups(resolvedGroupSequence, list);
        }
        this.resolvedSequences.put(group, resolvedGroupSequence);
        return resolvedGroupSequence;
    }
}

