/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Uint16Array;

public class Uint16ArrayImpl
extends ArrayBufferViewImpl
implements Uint16Array {
    public Uint16ArrayImpl(ArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length * 2);
    }

    @Override
    public int get(int index) {
        int val = this.arrayBuf.getInt8(this.checkRange(index, 2));
        if (val < 0) {
            val += 65536;
        }
        return val;
    }

    @Override
    public int length() {
        return this.byteLength() / 2;
    }

    @Override
    public void set(int index, int value) {
        this.arrayBuf.setInt16(this.checkRange(index, 2), (short)(value & 0xFFFF), true);
    }

    @Override
    public void set(int[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(int[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(Uint16Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Uint16Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array.get(i));
        }
    }

    @Override
    public Uint16Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 2;
        return this.subarray(begin, count);
    }

    @Override
    public Uint16Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 2;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Uint16ArrayImpl(this.arrayBuf, begin * 2, end * 2);
    }
}

