/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.apt.TypeVisitorBase;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class ClientToDomainMapper
extends TypeVisitorBase<TypeMirror> {
    ClientToDomainMapper() {
    }

    @Override
    public TypeMirror visitDeclared(DeclaredType x, State state) {
        if (x.asElement().getKind().equals((Object)ElementKind.ENUM)) {
            return x;
        }
        if (state.types.isAssignable(x, state.entityProxyType) || state.types.isAssignable(x, state.valueProxyType)) {
            TypeElement domainType = (TypeElement)state.getClientToDomainMap().get(state.types.asElement(x));
            if (domainType == null) {
                return this.defaultAction((TypeMirror)x, state);
            }
            return domainType.asType();
        }
        if (state.types.isAssignable(x, state.entityProxyIdType)) {
            return this.convertSingleParamType(x, state.entityProxyIdType, 0, state);
        }
        if (state.types.isAssignable(x, state.requestType)) {
            return this.convertSingleParamType(x, state.requestType, 0, state);
        }
        if (state.types.isAssignable(x, state.instanceRequestType)) {
            return this.convertSingleParamType(x, state.instanceRequestType, 1, state);
        }
        for (DeclaredType valueType : this.getValueTypes(state)) {
            if (!state.types.isAssignable(x, valueType)) continue;
            return x;
        }
        if (state.types.isAssignable(x, state.findType(List.class)) || state.types.isAssignable(x, state.findType(Set.class))) {
            TypeMirror param = this.convertSingleParamType(x, state.findType(Collection.class), 0, state);
            return state.types.getDeclaredType((TypeElement)state.types.asElement(x), param);
        }
        DeclaredType mapType = state.findType(Map.class);
        if (state.types.isAssignable(x, mapType)) {
            TypeMirror keyParam = this.convertSingleParamType(x, mapType, 0, state);
            TypeMirror valueParam = this.convertSingleParamType(x, mapType, 1, state);
            return state.types.getDeclaredType((TypeElement)state.types.asElement(x), keyParam, valueParam);
        }
        return this.defaultAction((TypeMirror)x, state);
    }

    @Override
    public TypeMirror visitNoType(NoType x, State state) {
        if (x.getKind().equals((Object)TypeKind.VOID)) {
            return x;
        }
        return this.defaultAction((TypeMirror)x, state);
    }

    @Override
    public TypeMirror visitPrimitive(PrimitiveType x, State state) {
        return x;
    }

    @Override
    public TypeMirror visitTypeVariable(TypeVariable x, State state) {
        return x.getUpperBound().accept(this, state);
    }

    @Override
    public TypeMirror visitWildcard(WildcardType x, State state) {
        return state.types.erasure(x).accept(this, state);
    }

    protected TypeMirror convertSingleParamType(DeclaredType x, DeclaredType convertTo, int param, State state) {
        DeclaredType converted = (DeclaredType)State.viewAs(convertTo, x, state);
        if (converted == null) {
            return state.types.getNoType(TypeKind.NONE);
        }
        if (converted.getTypeArguments().isEmpty()) {
            return this.defaultAction((TypeMirror)x, state);
        }
        return converted.getTypeArguments().get(param).accept(this, state);
    }

    @Override
    protected TypeMirror defaultAction(TypeMirror x, State state) {
        throw new UnmappedTypeException(x);
    }

    public static class UnmappedTypeException
    extends RuntimeException {
        private final TypeMirror clientType;

        public UnmappedTypeException() {
            this.clientType = null;
        }

        public UnmappedTypeException(TypeMirror clientType) {
            String string = String.valueOf(clientType.toString());
            super(string.length() != 0 ? "No domain type resolved for ".concat(string) : new String("No domain type resolved for "));
            this.clientType = clientType;
        }

        public TypeMirror getClientType() {
            return this.clientType;
        }
    }
}

