/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;

public class SimplePager
extends AbstractPager {
    private static final int DEFAULT_FAST_FORWARD_ROWS = 1000;
    private static Resources DEFAULT_RESOURCES;
    private final ImageButton fastForward;
    private final int fastForwardRows;
    private final ImageButton firstPage;
    private final HTML label = new HTML();
    private final ImageButton lastPage;
    private final ImageButton nextPage;
    private final ImageButton prevPage;
    private final Resources resources;
    private final Style style;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public SimplePager() {
        this(TextLocation.CENTER);
    }

    @UiConstructor
    public SimplePager(TextLocation location) {
        this(location, SimplePager.getDefaultResources(), true, 1000, false);
    }

    public SimplePager(TextLocation location, boolean showFastForwardButton, boolean showLastPageButton) {
        this(location, showFastForwardButton, 1000, showLastPageButton);
    }

    public SimplePager(TextLocation location, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton) {
        this(location, SimplePager.getDefaultResources(), showFastForwardButton, fastForwardRows, showLastPageButton);
    }

    public SimplePager(TextLocation location, Resources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton, ImageButtonsConstants imageButtonConstants) {
        this(location, resources, showFastForwardButton, fastForwardRows, showLastPageButton, true, imageButtonConstants);
    }

    public SimplePager(TextLocation location, Resources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton, boolean showFirstPageButton, ImageButtonsConstants imageButtonConstants) {
        this.resources = resources;
        this.fastForwardRows = fastForwardRows;
        this.style = resources.simplePagerStyle();
        this.style.ensureInjected();
        String disabledStyle = this.style.disabledButton();
        if (showFirstPageButton) {
            this.firstPage = new ImageButton(resources.simplePagerFirstPage(), resources.simplePagerFirstPageDisabled(), disabledStyle, imageButtonConstants.firstPage());
            this.firstPage.addClickHandler(new ClickHandler(){

                @Override
                public void onClick(ClickEvent event) {
                    SimplePager.this.firstPage();
                }
            });
        } else {
            this.firstPage = null;
        }
        this.nextPage = new ImageButton(resources.simplePagerNextPage(), resources.simplePagerNextPageDisabled(), disabledStyle, imageButtonConstants.nextPage());
        this.nextPage.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                SimplePager.this.nextPage();
            }
        });
        this.prevPage = new ImageButton(resources.simplePagerPreviousPage(), resources.simplePagerPreviousPageDisabled(), disabledStyle, imageButtonConstants.prevPage());
        this.prevPage.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                SimplePager.this.previousPage();
            }
        });
        if (showLastPageButton) {
            this.lastPage = new ImageButton(resources.simplePagerLastPage(), resources.simplePagerLastPageDisabled(), disabledStyle, imageButtonConstants.lastPage());
            this.lastPage.addClickHandler(new ClickHandler(){

                @Override
                public void onClick(ClickEvent event) {
                    SimplePager.this.lastPage();
                }
            });
        } else {
            this.lastPage = null;
        }
        if (showFastForwardButton) {
            this.fastForward = new ImageButton(resources.simplePagerFastForward(), resources.simplePagerFastForwardDisabled(), disabledStyle, imageButtonConstants.fastForward());
            this.fastForward.addClickHandler(new ClickHandler(){

                @Override
                public void onClick(ClickEvent event) {
                    SimplePager.this.setPage(SimplePager.this.getPage() + SimplePager.this.getFastForwardPages());
                }
            });
        } else {
            this.fastForward = null;
        }
        HorizontalPanel layout = new HorizontalPanel();
        layout.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget(layout);
        if (location == TextLocation.LEFT) {
            layout.add(this.label);
        }
        if (showFirstPageButton) {
            layout.add(this.firstPage);
        }
        layout.add(this.prevPage);
        if (location == TextLocation.CENTER) {
            layout.add(this.label);
        }
        layout.add(this.nextPage);
        if (showFastForwardButton) {
            layout.add(this.fastForward);
        }
        if (showLastPageButton) {
            layout.add(this.lastPage);
        }
        if (location == TextLocation.RIGHT) {
            layout.add(this.label);
        }
        if (showFirstPageButton) {
            this.firstPage.getElement().getParentElement().addClassName(this.style.button());
        }
        this.prevPage.getElement().getParentElement().addClassName(this.style.button());
        this.label.getElement().getParentElement().addClassName(this.style.pageDetails());
        this.nextPage.getElement().getParentElement().addClassName(this.style.button());
        if (showFastForwardButton) {
            this.fastForward.getElement().getParentElement().addClassName(this.style.button());
        }
        if (showLastPageButton) {
            this.lastPage.getElement().getParentElement().addClassName(this.style.button());
        }
        this.setDisplay(null);
    }

    public SimplePager(TextLocation location, Resources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton) {
        this(location, resources, showFastForwardButton, fastForwardRows, showLastPageButton, (ImageButtonsConstants)GWT.create(ImageButtonsConstants.class));
    }

    @Override
    public void firstPage() {
        super.firstPage();
    }

    @Override
    public int getPage() {
        return super.getPage();
    }

    @Override
    public int getPageCount() {
        return super.getPageCount();
    }

    @Override
    public boolean hasNextPage() {
        return super.hasNextPage();
    }

    @Override
    public boolean hasNextPages(int pages) {
        return super.hasNextPages(pages);
    }

    @Override
    public boolean hasPage(int index) {
        return super.hasPage(index);
    }

    @Override
    public boolean hasPreviousPage() {
        return super.hasPreviousPage();
    }

    @Override
    public boolean hasPreviousPages(int pages) {
        return super.hasPreviousPages(pages);
    }

    @Override
    public void lastPage() {
        super.lastPage();
    }

    @Override
    public void lastPageStart() {
        super.lastPageStart();
    }

    @Override
    public void nextPage() {
        super.nextPage();
    }

    @Override
    public void previousPage() {
        super.previousPage();
    }

    @Override
    public void setDisplay(HasRows display) {
        boolean disableButtons = display == null || display.getRowCount() == 0;
        this.setFastForwardDisabled(disableButtons);
        this.setNextPageButtonsDisabled(disableButtons);
        this.setPrevPageButtonsDisabled(disableButtons);
        super.setDisplay(display);
    }

    @Override
    public void setPage(int index) {
        super.setPage(index);
    }

    @Override
    public void setPageSize(int pageSize) {
        super.setPageSize(pageSize);
    }

    @Override
    public void setPageStart(int index) {
        super.setPageStart(index);
    }

    public void startLoading() {
        this.getDisplay().setRowCount(0, true);
        this.label.setHTML("");
    }

    protected String createText() {
        NumberFormat formatter = NumberFormat.getFormat("#,###");
        HasRows display = this.getDisplay();
        Range range = display.getVisibleRange();
        int pageStart = range.getStart() + 1;
        int pageSize = range.getLength();
        int dataSize = display.getRowCount();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        boolean exact = display.isRowCountExact();
        String string = formatter.format(pageStart);
        String string2 = formatter.format(endIndex);
        String string3 = exact ? " of " : " of over ";
        String string4 = formatter.format(dataSize);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append("-").append(string2).append(string3).append(string4).toString();
    }

    @Override
    protected void onRangeOrRowCountChanged() {
        HasRows display = this.getDisplay();
        this.label.setText(this.createText());
        this.setPrevPageButtonsDisabled(!this.hasPreviousPage());
        if (this.isRangeLimited() || !display.isRowCountExact()) {
            this.setNextPageButtonsDisabled(!this.hasNextPage());
            this.setFastForwardDisabled(!this.hasNextPages(this.getFastForwardPages()));
        }
    }

    boolean isNextButtonDisabled() {
        return this.nextPage.isDisabled();
    }

    boolean isPreviousButtonDisabled() {
        return this.prevPage.isDisabled();
    }

    private int getFastForwardPages() {
        int pageSize = this.getPageSize();
        return pageSize > 0 ? this.fastForwardRows / pageSize : 0;
    }

    private void setFastForwardDisabled(boolean disabled) {
        if (this.fastForward == null) {
            return;
        }
        if (disabled) {
            this.fastForward.setResource(this.resources.simplePagerFastForwardDisabled());
            this.fastForward.getElement().getParentElement().addClassName(this.style.disabledButton());
        } else {
            this.fastForward.setResource(this.resources.simplePagerFastForward());
            this.fastForward.getElement().getParentElement().removeClassName(this.style.disabledButton());
        }
    }

    private void setNextPageButtonsDisabled(boolean disabled) {
        this.nextPage.setDisabled(disabled);
        if (this.lastPage != null) {
            this.lastPage.setDisabled(disabled);
        }
    }

    private void setPrevPageButtonsDisabled(boolean disabled) {
        if (this.firstPage != null) {
            this.firstPage.setDisabled(disabled);
        }
        this.prevPage.setDisabled(disabled);
    }

    private static class ImageButton
    extends Image {
        private boolean disabled;
        private final ImageResource resDisabled;
        private final ImageResource resEnabled;
        private final String styleDisabled;

        public ImageButton(ImageResource resEnabled, ImageResource resDiabled, String disabledStyle, String label) {
            super(resEnabled);
            this.resEnabled = resEnabled;
            this.resDisabled = resDiabled;
            this.styleDisabled = disabledStyle;
            Roles.getButtonRole().set(this.getElement());
            Roles.getButtonRole().setAriaLabelProperty(this.getElement(), label);
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        @Override
        public void onBrowserEvent(Event event) {
            if (this.disabled) {
                return;
            }
            super.onBrowserEvent(event);
        }

        public void setDisabled(boolean isDisabled) {
            if (this.disabled == isDisabled) {
                return;
            }
            this.disabled = isDisabled;
            if (this.disabled) {
                this.setResource(this.resDisabled);
                this.getElement().getParentElement().addClassName(this.styleDisabled);
            } else {
                this.setResource(this.resEnabled);
                this.getElement().getParentElement().removeClassName(this.styleDisabled);
            }
            Roles.getButtonRole().setAriaDisabledState(this.getElement(), this.disabled);
        }
    }

    public static enum TextLocation {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static interface Style
    extends CssResource {
        public String button();

        public String disabledButton();

        public String pageDetails();
    }

    public static interface Resources
    extends ClientBundle {
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerFastForward();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerFastForwardDisabled();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerFirstPage();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerFirstPageDisabled();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerLastPage();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerLastPageDisabled();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerNextPage();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerNextPageDisabled();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerPreviousPage();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource simplePagerPreviousPageDisabled();

        @ClientBundle.Source(value={"SimplePager.css"})
        public Style simplePagerStyle();
    }

    @LocalizableResource.DefaultLocale(value="en_US")
    public static interface ImageButtonsConstants
    extends Constants {
        @Constants.DefaultStringValue(value="Fast forward")
        public String fastForward();

        @Constants.DefaultStringValue(value="First page")
        public String firstPage();

        @Constants.DefaultStringValue(value="Last page")
        public String lastPage();

        @Constants.DefaultStringValue(value="Next page")
        public String nextPage();

        @Constants.DefaultStringValue(value="Previous page")
        public String prevPage();
    }
}

