/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.gss.ast.CssDotPathNode;
import com.google.gwt.resources.gss.ast.CssJavaExpressionNode;
import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunction;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunctionException;
import com.google.gwt.thirdparty.common.css.compiler.gssfunctions.GssFunctions;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import java.util.List;

public class ResourceUrlFunction
implements GssFunction {
    private final ResourceContext context;
    private final MethodByPathHelper methodByPathHelper;
    private final JClassType dataResourceType;
    private final JClassType imageResourceType;

    public static String getName() {
        return "resourceUrl";
    }

    public ResourceUrlFunction(ResourceContext context) {
        this(context, new MethodByPathHelperImpl());
    }

    @VisibleForTesting
    ResourceUrlFunction(ResourceContext context, MethodByPathHelper methodByPathHelper) {
        this.context = context;
        this.methodByPathHelper = methodByPathHelper;
        this.dataResourceType = context.getGeneratorContext().getTypeOracle().findType(DataResource.class.getCanonicalName());
        this.imageResourceType = context.getGeneratorContext().getTypeOracle().findType(ImageResource.class.getCanonicalName());
    }

    public Integer getNumExpectedArguments() {
        return 1;
    }

    public List<CssValueNode> getCallResultNodes(List<CssValueNode> cssValueNodes, ErrorManager errorManager) throws GssFunctionException {
        CssValueNode functionToEval = cssValueNodes.get(0);
        String value = functionToEval.getValue();
        SourceCodeLocation location = functionToEval.getSourceCodeLocation();
        String javaExpression = this.buildJavaExpression(value, location, errorManager);
        CssFunctionNode urlNode = this.buildUrlNode(javaExpression, location);
        return ImmutableList.of(urlNode);
    }

    public String getCallResultString(List<String> strings) throws GssFunctionException {
        return strings.get(0);
    }

    private String buildJavaExpression(String value, SourceCodeLocation location, ErrorManager errorManager) throws GssFunctionException {
        CssDotPathNode dotPathValue = new CssDotPathNode(value, "", "", location);
        this.assertMethodIsValidResource(location, dotPathValue.getPathElements(), errorManager);
        String string = this.context.getImplementationSimpleSourceName();
        String string2 = String.valueOf(dotPathValue.getValue());
        return new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".this.").append(string2).append(".getSafeUri().asString()").toString();
    }

    private void assertMethodIsValidResource(SourceCodeLocation location, List<String> pathElements, ErrorManager errorManager) throws GssFunctionException {
        JType methodType;
        try {
            methodType = this.methodByPathHelper.getReturnType(this.context, pathElements);
        }
        catch (NotFoundException e) {
            String message = e.getMessage() != null ? e.getMessage() : "Invalid path";
            errorManager.report(new GssError(message, location));
            throw new GssFunctionException(message, (Throwable)e);
        }
        if (!this.dataResourceType.isAssignableFrom((JClassType)methodType) && !this.imageResourceType.isAssignableFrom((JClassType)methodType)) {
            String string = String.valueOf(methodType);
            String message = new StringBuilder(94 + String.valueOf(string).length()).append("Invalid method type for url substitution: ").append(string).append(". ").append("Only DataResource and ImageResource are supported.").toString();
            errorManager.report(new GssError(message, location));
            throw new GssFunctionException(message);
        }
    }

    private CssFunctionNode buildUrlNode(String javaExpression, SourceCodeLocation location) {
        CssFunctionNode urlNode = GssFunctions.createUrlNode((String)"", (SourceCodeLocation)location);
        CssJavaExpressionNode cssJavaExpressionNode = new CssJavaExpressionNode(javaExpression);
        CssFunctionArgumentsNode arguments = new CssFunctionArgumentsNode(ImmutableList.of(cssJavaExpressionNode));
        urlNode.setArguments(arguments);
        return urlNode;
    }

    private static class MethodByPathHelperImpl
    implements MethodByPathHelper {
        private MethodByPathHelperImpl() {
        }

        @Override
        public JType getReturnType(ResourceContext context, List<String> pathElements) throws NotFoundException {
            return ResourceGeneratorUtil.getMethodByPath(context.getClientBundleType(), pathElements, null).getReturnType();
        }
    }

    @VisibleForTesting
    static interface MethodByPathHelper {
        public JType getReturnType(ResourceContext var1, List<String> var2) throws NotFoundException;
    }
}

