/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server.impl;

import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.server.AbstractMessageInterface;
import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.MessageProcessingException;
import com.google.gwt.i18n.server.impl.ReflectionMessage;
import com.google.gwt.i18n.server.impl.ReflectionUtils;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReflectionMessageInterface
extends AbstractMessageInterface {
    private final Class<? extends LocalizableResource> msgIntf;
    private Map<Method, String[]> paramNames = null;

    public ReflectionMessageInterface(GwtLocaleFactory factory, Class<? extends LocalizableResource> msgIntf) {
        super(factory);
        this.msgIntf = msgIntf;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotClass) {
        return ReflectionUtils.getAnnotation(this.msgIntf, annotClass, true);
    }

    @Override
    public String getClassName() {
        StringBuilder buf = new StringBuilder();
        for (Class<?> encl = this.msgIntf.getEnclosingClass(); encl != null; encl = encl.getEnclosingClass()) {
            buf.insert(0, String.valueOf(encl.getSimpleName()).concat("."));
        }
        String string = String.valueOf(buf.toString());
        String string2 = String.valueOf(this.msgIntf.getSimpleName());
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @Override
    public Iterable<Message> getMessages() throws MessageProcessingException {
        Method[] methods = this.msgIntf.getMethods();
        ArrayList<ReflectionMessage> messages = new ArrayList<ReflectionMessage>();
        for (Method method : methods) {
            messages.add(new ReflectionMessage(this.factory, this, method));
        }
        Collections.sort(messages);
        return Collections.unmodifiableList(messages);
    }

    @Override
    public String getPackageName() {
        return this.msgIntf.getPackage().getName();
    }

    @Override
    public String getQualifiedName() {
        String name = this.getPackageName();
        if (name != null) {
            name = String.valueOf(name).concat(".");
        }
        String string = String.valueOf(name);
        String string2 = String.valueOf(this.getClassName());
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotClass) {
        return ReflectionUtils.getAnnotation(this.msgIntf, annotClass, true) != null;
    }

    String[] getParameterNames(Method method) {
        if (this.paramNames == null) {
            this.fetchParameterNames();
        }
        return this.paramNames.get(method);
    }

    private void fetchParameterNames() {
        this.paramNames = new HashMap<Method, String[]>();
    }
}

