/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.ext.SupportsGeneratorResultCaching;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.net.URL;

public final class TextResourceGenerator
extends AbstractResourceGenerator
implements SupportsGeneratorResultCaching {
    private static final int MAX_STRING_CHUNK = 16383;

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        String string;
        URL[] resources = ResourceGeneratorUtil.findResources(logger, context, method);
        if (resources.length != 1) {
            logger.log(TreeLogger.ERROR, "Exactly one resource must be specified", null);
            throw new UnableToCompleteException();
        }
        URL resource = resources[0];
        StringSourceWriter sw = new StringSourceWriter();
        String string2 = String.valueOf(String.valueOf(TextResource.class.getName()));
        sw.println(new StringBuilder(8 + string2.length()).append("new ").append(string2).append("() {").toString());
        sw.indent();
        if (!AbstractResourceGenerator.STRIP_COMMENTS) {
            String string3 = String.valueOf(resource.toExternalForm());
            sw.println(string3.length() != 0 ? "// ".concat(string3) : new String("// "));
        }
        sw.println("public String getText() {");
        sw.indent();
        String toWrite = Util.readURLAsString((URL)resource);
        if (toWrite.length() > 16383) {
            this.writeLongString((SourceWriter)sw, toWrite);
        } else {
            string = String.valueOf(String.valueOf(Generator.escape((String)toWrite)));
            sw.println(new StringBuilder(10 + string.length()).append("return \"").append(string).append("\";").toString());
        }
        sw.outdent();
        sw.println("}");
        sw.println("public String getName() {");
        sw.indent();
        string = String.valueOf(String.valueOf(method.getName()));
        sw.println(new StringBuilder(10 + string.length()).append("return \"").append(string).append("\";").toString());
        sw.outdent();
        sw.println("}");
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    private void writeLongString(SourceWriter sw, String toWrite) {
        int subLength;
        sw.println("StringBuilder builder = new StringBuilder();");
        int length = toWrite.length();
        for (int offset = 0; offset < length - 1; offset += subLength) {
            subLength = Math.min(16383, length - offset);
            sw.print("builder.append(\"");
            sw.print(Generator.escape((String)toWrite.substring(offset, offset + subLength)));
            sw.println("\");");
        }
        sw.println("return builder.toString();");
    }
}

