/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.user.rebind.SourceWriter;

public abstract class AbstractCssResourceGenerator
extends AbstractResourceGenerator {
    protected abstract String getCssExpression(TreeLogger var1, ResourceContext var2, JMethod var3) throws UnableToCompleteException;

    protected boolean isReturnTypeString(JClassType classReturnType) {
        return classReturnType != null && String.class.getName().equals(classReturnType.getQualifiedSourceName());
    }

    protected void writeEnsureInjected(SourceWriter sw) {
        sw.println("private boolean injected;");
        sw.println("public boolean ensureInjected() {");
        sw.indent();
        sw.println("if (!injected) {");
        sw.indentln("injected = true;");
        sw.indentln(String.valueOf(StyleInjector.class.getName()).concat(".inject(getText());"));
        sw.indentln("return true;");
        sw.println("}");
        sw.println("return false;");
        sw.outdent();
        sw.println("}");
    }

    protected void writeGetName(JMethod method, SourceWriter sw) {
        sw.println("public String getName() {");
        String string = String.valueOf(String.valueOf(method.getName()));
        sw.indentln(new StringBuilder(10 + string.length()).append("return \"").append(string).append("\";").toString());
        sw.println("}");
    }

    protected void writeGetText(TreeLogger logger, ResourceContext context, JMethod method, SourceWriter sw) throws UnableToCompleteException {
        String cssExpression = this.getCssExpression(logger, context, method);
        sw.println("public String getText() {");
        String string = String.valueOf(String.valueOf(cssExpression));
        sw.indentln(new StringBuilder(8 + string.length()).append("return ").append(string).append(";").toString());
        sw.println("}");
    }

    protected void writeSimpleGetter(JMethod methodToImplement, String toReturn, SourceWriter sw) {
        sw.print(methodToImplement.getReadableDeclaration(false, true, true, true, true));
        sw.println(" {");
        String string = String.valueOf(String.valueOf(toReturn));
        sw.indentln(new StringBuilder(8 + string.length()).append("return ").append(string).append(";").toString());
        sw.println("}");
    }
}

