/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css.ast;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.shared.impl.StringCase;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssSubstitution;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CssProperty
extends CssNode
implements CssSubstitution {
    private boolean important;
    private String name;
    private ListValue value;

    public CssProperty(String name, Value value, boolean important) {
        assert (name.length() > 0) : "name";
        this.name = name;
        this.setValue(value);
        this.important = important;
    }

    public String getName() {
        return this.name;
    }

    public ListValue getValues() {
        return this.value;
    }

    public boolean isImportant() {
        return this.important;
    }

    @Override
    public boolean isStatic() {
        return this.getValues().isStatic();
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Value value) {
        this.value = value.isListValue();
        if (this.value == null) {
            this.value = new ListValue(value);
        }
    }

    @Override
    public void traverse(CssVisitor visitor, Context context) {
        visitor.visit(this, context);
        visitor.endVisit(this, context);
    }

    public static abstract class Value {
        public abstract String getExpression();

        public DotPathValue isDotPathValue() {
            return null;
        }

        public ExpressionValue isExpressionValue() {
            return null;
        }

        public FunctionValue isFunctionValue() {
            return null;
        }

        public IdentValue isIdentValue() {
            return null;
        }

        public ListValue isListValue() {
            return null;
        }

        public NumberValue isNumberValue() {
            return null;
        }

        public boolean isSpaceRequired() {
            return true;
        }

        public boolean isStatic() {
            return true;
        }

        public StringValue isStringValue() {
            return null;
        }

        public abstract String toCss();

        public String toString() {
            return this.toCss();
        }
    }

    public static class TokenValue
    extends IdentValue {
        public TokenValue(String token) {
            super(token);
        }

        @Override
        public boolean isSpaceRequired() {
            return false;
        }
    }

    public static class StringValue
    extends Value {
        private final String value;

        private static String escapeValue(String s, boolean inDoubleQuotes) {
            StringBuilder b = new StringBuilder();
            block5: for (char c : s.toCharArray()) {
                if (Character.isISOControl(c)) {
                    b.append('\\').append(StringCase.toUpper(Integer.toHexString(c))).append(" ");
                    continue;
                }
                switch (c) {
                    case '\'': {
                        if (inDoubleQuotes) {
                            b.append(c);
                            continue block5;
                        }
                        b.append("\\'");
                        continue block5;
                    }
                    case '\"': {
                        if (inDoubleQuotes) {
                            b.append("\\\"");
                            continue block5;
                        }
                        b.append(c);
                        continue block5;
                    }
                    case '\\': {
                        b.append("\\\\");
                        continue block5;
                    }
                    default: {
                        b.append(c);
                    }
                }
            }
            return b.toString();
        }

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public String getExpression() {
            String string = String.valueOf(String.valueOf(Generator.escape((String)this.toCss())));
            return new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public StringValue isStringValue() {
            return this;
        }

        @Override
        public String toCss() {
            String string = String.valueOf(String.valueOf(StringValue.escapeValue(this.value, true)));
            return new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }
    }

    public static class NumberValue
    extends Value {
        private final String css;
        private final String expression;
        private final String units;
        private final float value;

        public NumberValue(float value) {
            this(value, null);
        }

        public NumberValue(float value, String units) {
            this.value = value;
            this.units = units;
            int i = (int)value;
            String s = (float)i == value ? String.valueOf(i) : String.valueOf(value);
            if (units != null && value != 0.0f) {
                String string = String.valueOf(s);
                String string2 = String.valueOf(units);
                this.css = string2.length() != 0 ? string.concat(string2) : new String(string);
                String string3 = String.valueOf(String.valueOf(s));
                String string4 = String.valueOf(String.valueOf(Generator.escape((String)units)));
                this.expression = new StringBuilder(2 + string3.length() + string4.length()).append("\"").append(string3).append(string4).append("\"").toString();
            } else if (value == 0.0f) {
                this.css = "0";
                this.expression = "\"0\"";
            } else {
                this.css = s;
                String string = String.valueOf(String.valueOf(s));
                this.expression = new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
            }
        }

        @Override
        public String getExpression() {
            return this.expression;
        }

        public String getUnits() {
            return this.units;
        }

        public float getValue() {
            return this.value;
        }

        @Override
        public NumberValue isNumberValue() {
            return this;
        }

        @Override
        public String toCss() {
            return this.css;
        }
    }

    public static class ListValue
    extends Value {
        private final List<Value> values;

        public ListValue(List<Value> values) {
            this.values = Collections.unmodifiableList(new ArrayList<Value>(values));
        }

        public ListValue(Value ... values) {
            this(Arrays.asList(values));
        }

        @Override
        public String getExpression() {
            StringBuilder toReturn = new StringBuilder();
            boolean first = true;
            Iterator<Value> i = this.values.iterator();
            while (i.hasNext()) {
                Value value = i.next();
                if (!first && value.isSpaceRequired()) {
                    toReturn.append("\" \" +");
                }
                toReturn.append(value.getExpression());
                if (i.hasNext()) {
                    toReturn.append("+ ");
                }
                first = false;
            }
            return toReturn.toString();
        }

        public List<Value> getValues() {
            return this.values;
        }

        @Override
        public ListValue isListValue() {
            return this;
        }

        @Override
        public boolean isStatic() {
            for (Value value : this.values) {
                if (value.isStatic()) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toCss() {
            StringBuilder sb = new StringBuilder();
            for (Value v : this.values) {
                if (v.isSpaceRequired()) {
                    sb.append(" ");
                }
                sb.append(v.toCss());
            }
            if (sb.charAt(0) == ' ') {
                return sb.substring(1);
            }
            return sb.toString();
        }
    }

    public static class IdentValue
    extends Value {
        private final String ident;

        public IdentValue(String ident) {
            this.ident = ident;
        }

        @Override
        public String getExpression() {
            String string = String.valueOf(String.valueOf(Generator.escape((String)this.ident)));
            return new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }

        public String getIdent() {
            return this.ident;
        }

        @Override
        public IdentValue isIdentValue() {
            return this;
        }

        @Override
        public String toCss() {
            return this.ident;
        }
    }

    public static class FunctionValue
    extends Value {
        private final String name;
        private final ListValue values;

        public FunctionValue(String name, ListValue values) {
            this.name = name;
            this.values = values;
        }

        @Override
        public String getExpression() {
            return String.format("\"%s(\" + %s + \")\"", Generator.escape((String)this.name), this.values.getExpression());
        }

        public String getName() {
            return this.name;
        }

        public ListValue getValues() {
            return this.values;
        }

        @Override
        public FunctionValue isFunctionValue() {
            return this;
        }

        @Override
        public boolean isStatic() {
            return this.values.isStatic();
        }

        @Override
        public String toCss() {
            String string = String.valueOf(String.valueOf(this.name));
            String string2 = String.valueOf(String.valueOf(this.values.toCss()));
            return new StringBuilder(2 + string.length() + string2.length()).append(string).append("(").append(string2).append(")").toString();
        }
    }

    public static class ExpressionValue
    extends Value {
        private final String expression;

        public ExpressionValue(String expression) {
            this.expression = expression;
        }

        @Override
        public String getExpression() {
            return this.expression;
        }

        @Override
        public ExpressionValue isExpressionValue() {
            return this;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String toCss() {
            return "/* Java expression */";
        }

        @Override
        public String toString() {
            return this.expression;
        }
    }

    public static class DotPathValue
    extends Value {
        private final String path;
        private final String suffix;

        public DotPathValue(String path) {
            assert (path != null) : "path";
            this.path = path;
            this.suffix = null;
        }

        public DotPathValue(String path, String suffix) {
            assert (path != null) : "path";
            assert (suffix != null) : "suffix";
            this.path = path;
            this.suffix = suffix;
        }

        @Override
        public String getExpression() {
            StringBuilder toReturn = new StringBuilder();
            toReturn.append(this.path.replace(".", "()."));
            toReturn.append("()");
            if (this.suffix != null) {
                toReturn.append(" + \"");
                toReturn.append(Generator.escape((String)this.suffix));
                toReturn.append("\"");
            }
            return toReturn.toString();
        }

        public List<String> getParts() {
            return Arrays.asList(this.path.split("\\."));
        }

        public String getPath() {
            return this.path;
        }

        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public DotPathValue isDotPathValue() {
            return this;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String toCss() {
            String string;
            String string2 = String.valueOf(String.valueOf(this.path));
            if (this.suffix == null) {
                string = "";
            } else {
                String string3 = String.valueOf(String.valueOf(this.suffix));
                string = new StringBuilder(4 + string3.length()).append(", \"").append(string3).append("\"").toString();
            }
            String string4 = String.valueOf(String.valueOf(string));
            return new StringBuilder(9 + string2.length() + string4.length()).append("value(\"").append(string2).append("\"").append(string4).append(")").toString();
        }
    }
}

