/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css.ast;

import com.google.gwt.resources.css.ast.CollapsedNode;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssFontFace;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssNoFlip;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssPageRule;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssUnknownAtRule;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.resources.css.ast.HasNodes;
import com.google.gwt.resources.css.ast.HasProperties;
import com.google.gwt.resources.css.ast.HasSelectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class CssNodeCloner
extends CssVisitor {
    private HasProperties currentHasProperties;
    private HasSelectors currentHasSelectors;
    private final Stack<List<CssNode>> curentNodes = new Stack();

    public static <T extends CssNode> List<T> clone(Class<T> clazz, List<T> nodes) {
        ArrayList topContext = new ArrayList();
        final ArrayList topProperties = new ArrayList();
        final ArrayList topSelectors = new ArrayList();
        CssNodeCloner cloner = new CssNodeCloner();
        cloner.curentNodes.push(topContext);
        cloner.currentHasProperties = new HasProperties(){

            @Override
            public List<CssProperty> getProperties() {
                return topProperties;
            }
        };
        cloner.currentHasSelectors = new HasSelectors(){

            @Override
            public List<CssSelector> getSelectors() {
                return topSelectors;
            }
        };
        cloner.accept(nodes);
        ArrayList toIterate = CssProperty.class.isAssignableFrom(clazz) ? topProperties : (CssSelector.class.isAssignableFrom(clazz) ? topSelectors : topContext);
        if (!$assertionsDisabled && toIterate.size() != nodes.size()) {
            String string = String.valueOf(String.valueOf("Wrong number of nodes in top context. Expecting: "));
            int n = nodes.size();
            int n2 = toIterate.size();
            throw new AssertionError((Object)new StringBuilder(30 + string.length()).append(string).append(n).append(" Found: ").append(n2).toString());
        }
        ArrayList<T> toReturn = new ArrayList<T>(toIterate.size());
        for (Object node : toIterate) {
            if (!$assertionsDisabled && !clazz.isInstance(node)) {
                String string = String.valueOf(String.valueOf(clazz.getName()));
                String string2 = String.valueOf(String.valueOf(node.getClass().getName()));
                throw new AssertionError((Object)new StringBuilder(41 + string.length() + string2.length()).append("Return type mismatch. Expecting: ").append(string).append(" Found: ").append(string2).toString());
            }
            toReturn.add(clazz.cast(node));
        }
        return toReturn;
    }

    public static <T extends CssNode> T clone(Class<T> clazz, T node) {
        return CssNodeCloner.clone(clazz, Collections.singletonList(node)).get(0);
    }

    private CssNodeCloner() {
    }

    @Override
    public void endVisit(CssMediaRule x, Context ctx) {
        this.popNodes(x);
    }

    @Override
    public void endVisit(CssNoFlip x, Context ctx) {
        this.popNodes(x);
    }

    @Override
    public void endVisit(CssStylesheet x, Context ctx) {
        this.popNodes(x);
    }

    @Override
    public boolean visit(CssDef x, Context ctx) {
        CssDef newDef = new CssDef(x.getKey());
        newDef.getValues().addAll(x.getValues());
        this.addToNodes(newDef);
        return true;
    }

    @Override
    public boolean visit(CssEval x, Context ctx) {
        assert (x.getValues().size() == 1);
        assert (x.getValues().get(0).isExpressionValue() != null);
        String value = x.getValues().get(0).isExpressionValue().getExpression();
        CssEval newEval = new CssEval(x.getKey(), value);
        this.addToNodes(newEval);
        return true;
    }

    @Override
    public boolean visit(CssExternalSelectors x, Context ctx) {
        CssExternalSelectors newExternals = new CssExternalSelectors();
        newExternals.getClasses().addAll(x.getClasses());
        this.addToNodes(newExternals);
        return true;
    }

    @Override
    public boolean visit(CssIf x, Context ctx) {
        CssIf newIf = new CssIf();
        if (x.getExpression() != null) {
            newIf.setExpression(x.getExpression());
        } else {
            newIf.setProperty(x.getPropertyName());
            String[] newValues = new String[x.getPropertyValues().length];
            System.arraycopy(x.getPropertyValues(), 0, newValues, 0, newValues.length);
            newIf.setPropertyValues(newValues);
            newIf.setNegated(x.isNegated());
        }
        this.pushNodes(newIf);
        this.accept(x.getNodes());
        this.popNodes(x, newIf);
        CollapsedNode oldElseNodes = new CollapsedNode(x.getElseNodes());
        CollapsedNode newElseNodes = new CollapsedNode(newIf.getElseNodes());
        this.pushNodes(newElseNodes, false);
        this.accept(oldElseNodes);
        this.popNodes(oldElseNodes, newElseNodes);
        return false;
    }

    @Override
    public boolean visit(CssMediaRule x, Context ctx) {
        CssMediaRule newRule = new CssMediaRule();
        newRule.getMedias().addAll(x.getMedias());
        this.pushNodes(newRule);
        return true;
    }

    @Override
    public boolean visit(CssNoFlip x, Context ctx) {
        this.pushNodes(new CssNoFlip());
        return true;
    }

    @Override
    public boolean visit(CssPageRule x, Context ctx) {
        CssPageRule newRule = new CssPageRule();
        newRule.setPseudoPage(x.getPseudoPage());
        this.addToNodes(newRule);
        return true;
    }

    @Override
    public boolean visit(CssProperty x, Context ctx) {
        CssProperty newProperty = new CssProperty(x.getName(), x.getValues(), x.isImportant());
        this.currentHasProperties.getProperties().add(newProperty);
        return true;
    }

    @Override
    public boolean visit(CssFontFace x, Context ctx) {
        CssFontFace newRule = new CssFontFace();
        this.addToNodes(newRule);
        return true;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        CssRule newRule = new CssRule();
        this.addToNodes(newRule);
        return true;
    }

    @Override
    public boolean visit(CssSelector x, Context ctx) {
        CssSelector newSelector = new CssSelector(x.getSelector());
        this.currentHasSelectors.getSelectors().add(newSelector);
        return true;
    }

    @Override
    public boolean visit(CssSprite x, Context ctx) {
        CssSprite newSprite = new CssSprite();
        newSprite.setResourceFunction(x.getResourceFunction());
        this.addToNodes(newSprite);
        return true;
    }

    @Override
    public boolean visit(CssStylesheet x, Context ctx) {
        CssStylesheet newSheet = new CssStylesheet();
        this.pushNodes(newSheet);
        return true;
    }

    @Override
    public boolean visit(CssUrl x, Context ctx) {
        assert (x.getValues().size() == 1);
        assert (x.getValues().get(0).isDotPathValue() != null);
        CssUrl newUrl = new CssUrl(x.getKey(), x.getValues().get(0).isDotPathValue());
        this.addToNodes(newUrl);
        return true;
    }

    @Override
    public boolean visit(CssUnknownAtRule x, Context ctx) {
        CssUnknownAtRule newRule = new CssUnknownAtRule(x.getRule());
        this.addToNodes(newRule);
        return true;
    }

    private void addToNodes(CssNode node) {
        this.curentNodes.peek().add(node);
        this.currentHasProperties = node instanceof HasProperties ? (HasProperties)((Object)node) : null;
        this.currentHasSelectors = node instanceof HasSelectors ? (HasSelectors)((Object)node) : null;
    }

    private List<CssNode> popNodes(HasNodes original) {
        List<CssNode> toReturn = this.curentNodes.pop();
        if (toReturn.size() != original.getNodes().size()) {
            String string = String.valueOf(String.valueOf(original.getClass().getName()));
            int n = original.getNodes().size();
            int n2 = toReturn.size();
            throw new RuntimeException(new StringBuilder(76 + string.length()).append("Insufficient number of nodes for a ").append(string).append(" Expected: ").append(n).append(" Found: ").append(n2).toString());
        }
        return toReturn;
    }

    private List<CssNode> popNodes(HasNodes original, HasNodes expected) {
        List<CssNode> toReturn = this.popNodes(original);
        if (toReturn != expected.getNodes()) {
            throw new RuntimeException("Incorrect parent node list popped");
        }
        return toReturn;
    }

    private <T extends CssNode> void pushNodes(T parent) {
        this.pushNodes(parent, true);
    }

    private <T extends CssNode> void pushNodes(T parent, boolean addToNodes) {
        if (addToNodes) {
            this.addToNodes(parent);
        }
        this.curentNodes.push(((HasNodes)((Object)parent)).getNodes());
    }
}

