/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.converter.SimpleValue;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UndefinedConstantVisitor
extends CssVisitor {
    private final Set<String> gssContantNames;
    private final Pattern pattern = Pattern.compile("[A-Z][A-Z_0-9]+");
    private final Set<String> propertyNamesToSkip = Sets.newHashSet("filter", "-ms-filter", "font-family");
    private final boolean lenient;
    private final TreeLogger treeLogger;

    public UndefinedConstantVisitor(Set<String> gssContantNames, boolean lenient, TreeLogger treeLogger) {
        this.gssContantNames = gssContantNames;
        this.lenient = lenient;
        this.treeLogger = treeLogger;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        List<CssProperty> properties = x.getProperties();
        for (CssProperty cssProperty : properties) {
            if (this.propertyNamesToSkip.contains(cssProperty.getName())) continue;
            String cssPropertyString = cssProperty.getValues().toCss();
            Matcher matcher = this.pattern.matcher(cssPropertyString);
            boolean needsUpdate = false;
            while (matcher.find()) {
                String string;
                String upperCaseString = matcher.group();
                if (this.gssContantNames.contains(upperCaseString)) continue;
                String string2 = String.valueOf(String.valueOf(cssProperty.getName()));
                String string3 = String.valueOf(String.valueOf(x.getSelectors().toString()));
                String string4 = String.valueOf(String.valueOf(upperCaseString));
                this.treeLogger.log(TreeLogger.Type.WARN, new StringBuilder(53 + string2.length() + string3.length() + string4.length()).append("Property '").append(string2).append("' from rule '").append(string3).append("' uses an undefined constant: ").append(string4).toString());
                if (this.lenient) {
                    string = String.valueOf(String.valueOf(upperCaseString));
                    this.treeLogger.log(TreeLogger.Type.WARN, new StringBuilder(87 + string.length()).append("turning '").append(string).append("' to lower case. This is probably not what you wanted here in the ").append("first place!").toString());
                    cssPropertyString = cssPropertyString.replace(upperCaseString, upperCaseString.toLowerCase());
                    needsUpdate = true;
                    break;
                }
                string = String.valueOf(String.valueOf(cssProperty.getName()));
                String string5 = String.valueOf(String.valueOf(x.getSelectors().toString()));
                String string6 = String.valueOf(String.valueOf(upperCaseString));
                throw new Css2GssConversionException(new StringBuilder(70 + string.length() + string5.length() + string6.length()).append("Found undefined constant in input. ").append(string).append("' from rule '").append(string5).append("' undefined constant: ").append(string6).toString());
            }
            if (!needsUpdate) continue;
            cssProperty.setValue(new SimpleValue(cssPropertyString));
        }
        return false;
    }
}

