/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import com.google.gwt.logging.impl.LoggerConfigurator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class LoggerConfiguratorConsole
implements LoggerConfigurator {
    LoggerConfiguratorConsole() {
    }

    @Override
    public void configure(Logger logger) {
        if (logger.getName().isEmpty()) {
            logger.addHandler(new SimpleConsoleLogHandler());
        }
    }

    private static class SimpleConsoleLogHandler
    extends Handler {
        private SimpleConsoleLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (!this.isSupported()) {
                return;
            }
            int val = record.getLevel().intValue();
            if (val >= Level.SEVERE.intValue()) {
                this.error(record.getMessage());
            } else if (val >= Level.WARNING.intValue()) {
                this.warn(record.getMessage());
            } else if (val >= Level.INFO.intValue()) {
                this.info(record.getMessage());
            } else {
                this.log(record.getMessage());
            }
        }

        private native boolean isSupported();

        private native void error(String var1);

        private native void warn(String var1);

        private native void info(String var1);

        private native void log(String var1);

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

