/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.layout.client;

import com.google.gwt.aria.client.State;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.Layout;

class LayoutImpl {
    private static DivElement fixedRuler = LayoutImpl.createRuler(Style.Unit.CM, Style.Unit.CM);
    protected DivElement relativeRuler;

    LayoutImpl() {
    }

    protected static DivElement createRuler(Style.Unit widthUnit, Style.Unit heightUnit) {
        DivElement ruler = Document.get().createDivElement();
        ruler.setInnerHTML("&nbsp;");
        Style style = ruler.getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setZIndex(-32767);
        style.setTop(-20.0, heightUnit);
        style.setWidth(10.0, widthUnit);
        style.setHeight(10.0, heightUnit);
        style.setVisibility(Style.Visibility.HIDDEN);
        State.HIDDEN.set(ruler, (Boolean[])new Boolean[]{true});
        return ruler;
    }

    public Element attachChild(Element parent, Element child, Element before) {
        DivElement container = Document.get().createDivElement();
        container.appendChild(child);
        container.getStyle().setPosition(Style.Position.ABSOLUTE);
        container.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.fillParent(child);
        Element beforeContainer = null;
        if (before != null) {
            beforeContainer = before.getParentElement();
            assert (beforeContainer.getParentElement() == parent) : "Element to insert before must be a sibling";
        }
        parent.insertBefore(container, beforeContainer);
        return container;
    }

    public void fillParent(Element elem) {
        Style style = elem.getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(0.0, Style.Unit.PX);
        style.setTop(0.0, Style.Unit.PX);
        style.setRight(0.0, Style.Unit.PX);
        style.setBottom(0.0, Style.Unit.PX);
    }

    public void finalizeLayout(Element parent) {
    }

    public double getUnitSizeInPixels(Element parent, Style.Unit unit, boolean vertical) {
        if (unit == null) {
            return 1.0;
        }
        switch (unit) {
            case PCT: {
                return (double)(vertical ? parent.getClientHeight() : parent.getClientWidth()) / 100.0;
            }
            case EM: {
                return (double)this.relativeRuler.getOffsetWidth() / 10.0;
            }
            case EX: {
                return (double)this.relativeRuler.getOffsetHeight() / 10.0;
            }
            case CM: {
                return (double)fixedRuler.getOffsetWidth() * 0.1;
            }
            case MM: {
                return (double)fixedRuler.getOffsetWidth() * 0.01;
            }
            case IN: {
                return (double)fixedRuler.getOffsetWidth() * 0.254;
            }
            case PT: {
                return (double)fixedRuler.getOffsetWidth() * 0.00353;
            }
            case PC: {
                return (double)fixedRuler.getOffsetWidth() * 0.0423;
            }
        }
        return 1.0;
    }

    public void initParent(Element parent) {
        parent.getStyle().setPosition(Style.Position.RELATIVE);
        this.relativeRuler = LayoutImpl.createRuler(Style.Unit.EM, Style.Unit.EX);
        parent.appendChild(this.relativeRuler);
    }

    public void layout(Layout.Layer layer) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Style style = layer.container.getStyle();
        if (layer.visible) {
            style.clearDisplay();
        } else {
            style.setDisplay(Style.Display.NONE);
        }
        if (layer.setLeft) {
            double d = layer.left;
            String string7 = String.valueOf(String.valueOf(layer.leftUnit.getType()));
            string6 = new StringBuilder(24 + string7.length()).append(d).append(string7).toString();
        } else {
            string6 = "";
        }
        style.setProperty("left", string6);
        if (layer.setTop) {
            double d = layer.top;
            String string8 = String.valueOf(String.valueOf(layer.topUnit.getType()));
            string5 = new StringBuilder(24 + string8.length()).append(d).append(string8).toString();
        } else {
            string5 = "";
        }
        style.setProperty("top", string5);
        if (layer.setRight) {
            double d = layer.right;
            String string9 = String.valueOf(String.valueOf(layer.rightUnit.getType()));
            string4 = new StringBuilder(24 + string9.length()).append(d).append(string9).toString();
        } else {
            string4 = "";
        }
        style.setProperty("right", string4);
        if (layer.setBottom) {
            double d = layer.bottom;
            String string10 = String.valueOf(String.valueOf(layer.bottomUnit.getType()));
            string3 = new StringBuilder(24 + string10.length()).append(d).append(string10).toString();
        } else {
            string3 = "";
        }
        style.setProperty("bottom", string3);
        if (layer.setWidth) {
            double d = layer.width;
            String string11 = String.valueOf(String.valueOf(layer.widthUnit.getType()));
            string2 = new StringBuilder(24 + string11.length()).append(d).append(string11).toString();
        } else {
            string2 = "";
        }
        style.setProperty("width", string2);
        if (layer.setHeight) {
            double d = layer.height;
            String string12 = String.valueOf(String.valueOf(layer.heightUnit.getType()));
            string = new StringBuilder(24 + string12.length()).append(d).append(string12).toString();
        } else {
            string = "";
        }
        style.setProperty("height", string);
        style = layer.child.getStyle();
        switch (layer.hPos) {
            case BEGIN: {
                style.setLeft(0.0, Style.Unit.PX);
                style.clearRight();
                break;
            }
            case END: {
                style.clearLeft();
                style.setRight(0.0, Style.Unit.PX);
                break;
            }
            case STRETCH: {
                style.setLeft(0.0, Style.Unit.PX);
                style.setRight(0.0, Style.Unit.PX);
            }
        }
        switch (layer.vPos) {
            case BEGIN: {
                style.setTop(0.0, Style.Unit.PX);
                style.clearBottom();
                break;
            }
            case END: {
                style.clearTop();
                style.setBottom(0.0, Style.Unit.PX);
                break;
            }
            case STRETCH: {
                style.setTop(0.0, Style.Unit.PX);
                style.setBottom(0.0, Style.Unit.PX);
            }
        }
    }

    public void onAttach(Element parent) {
    }

    public void onDetach(Element parent) {
    }

    public void removeChild(Element container, Element child) {
        container.removeFromParent();
        if (child.getParentElement() == container) {
            child.removeFromParent();
        }
        Style style = child.getStyle();
        style.clearPosition();
        style.clearLeft();
        style.clearTop();
        style.clearWidth();
        style.clearHeight();
    }

    static {
        Document.get().getBody().appendChild(fixedRuler);
    }
}

