/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.shared.impl;

import java.util.NoSuchElementException;

public class GwtPreconditions {
    public static void checkArrayType(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ArrayStoreException(String.valueOf(errorMessage));
        }
    }

    public static void checkElement(boolean expression) {
        GwtPreconditions.checkCriticalElement(expression);
    }

    public static void checkElement(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new NoSuchElementException(String.valueOf(errorMessage));
        }
    }

    public static void checkCriticalElement(boolean expression) {
        if (!expression) {
            throw new NoSuchElementException();
        }
    }

    public static void checkArgument(boolean expression) {
        GwtPreconditions.checkCriticalArgument(expression);
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        GwtPreconditions.checkCriticalArgument(expression, errorMessage);
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        GwtPreconditions.checkCriticalArgument(expression, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkCriticalArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkCriticalArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkCriticalArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(GwtPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static void checkNotNull(Object reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
    }

    public static void checkArraySize(int size) {
        if (size < 0) {
            int n = size;
            throw new NegativeArraySizeException(new StringBuilder(32).append("Negative array size: ").append(n).toString());
        }
    }

    public static void checkElementIndex(int index, int size) {
        if (index < 0 || index >= size) {
            int n = index;
            int n2 = size;
            throw new IndexOutOfBoundsException(new StringBuilder(37).append("Index: ").append(n).append(", Size: ").append(n2).toString());
        }
    }

    public static void checkPositionIndex(int index, int size) {
        if (index < 0 || index > size) {
            int n = index;
            int n2 = size;
            throw new IndexOutOfBoundsException(new StringBuilder(37).append("Index: ").append(n).append(", Size: ").append(n2).toString());
        }
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        GwtPreconditions.checkCriticalPositionIndexes(start, end, size);
    }

    public static void checkCriticalPositionIndexes(int start, int end, int size) {
        if (start < 0) {
            int n = start;
            throw new IndexOutOfBoundsException(new StringBuilder(26).append("fromIndex: ").append(n).append(" < 0").toString());
        }
        if (end > size) {
            int n = end;
            int n2 = size;
            throw new IndexOutOfBoundsException(new StringBuilder(39).append("toIndex: ").append(n).append(" > size ").append(n2).toString());
        }
        if (start > end) {
            int n = start;
            int n3 = end;
            throw new IllegalArgumentException(new StringBuilder(45).append("fromIndex: ").append(n).append(" > toIndex: ").append(n3).toString());
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

