/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.shared.impl.JsLogger;

public class SuperDevModeLogger
extends JsLogger {
    @Override
    public void log(String message, Throwable t) {
        if (!this.consoleLogEnabled()) {
            return;
        }
        this.log(message);
        if (t != null) {
            String out = this.makeSimpleStackTrace(t);
            if (this.consoleErrorEnabled()) {
                this.error(out);
            } else {
                this.log(out);
            }
        }
    }

    private String makeSimpleStackTrace(Throwable first) {
        StringBuilder out = new StringBuilder();
        for (Throwable t = first; t != null; t = t.getCause()) {
            if (t == first) {
                out.append(String.valueOf(t.toString()).concat("\n"));
            } else {
                String string = String.valueOf(String.valueOf(t.toString()));
                out.append(new StringBuilder(12 + string.length()).append("Caused by: ").append(string).append("\n").toString());
            }
            for (StackTraceElement element : t.getStackTrace()) {
                String string = String.valueOf(String.valueOf(element.getMethodName()));
                out.append(new StringBuilder(6 + string.length()).append("  at ").append(string).append("\n").toString());
            }
        }
        return out.toString();
    }

    private native boolean consoleLogEnabled();

    private native boolean consoleErrorEnabled();

    private native void log(String var1);

    private native void error(String var1);
}

