/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.codegen.server;

import com.google.gwt.codegen.server.AbortablePrintWriter;
import com.google.gwt.codegen.server.SourceWriterBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceWriter
extends SourceWriterBase {
    private static final Pattern PKG_REGEX_BOTH = Pattern.compile("(com\\.google|javax?)\\..*");
    private static final Pattern PKG_REGEX_GOOGLE = Pattern.compile("com\\.google\\..*");
    private static final Pattern PKG_REGEX_JAVA = Pattern.compile("javax?\\..*");
    private final AbortablePrintWriter printWriter;

    public JavaSourceWriter(AbortablePrintWriter printWriter, String targetPackageName, Iterable<String> imports, boolean isClass, String classJavaDocComment, Iterable<String> annotationDeclarations, String targetClassShortName, String superClassName, Iterable<String> interfaceNames) {
        this.printWriter = printWriter;
        if (targetPackageName == null) {
            String string = String.valueOf(targetClassShortName);
            throw new IllegalArgumentException(string.length() != 0 ? "Cannot supply a null package name to".concat(string) : new String("Cannot supply a null package name to"));
        }
        if (targetPackageName.length() > 0) {
            String string = String.valueOf(String.valueOf(targetPackageName));
            this.println(new StringBuilder(9 + string.length()).append("package ").append(string).append(";").toString());
        }
        this.writeImportGroup(imports, PKG_REGEX_GOOGLE, true);
        this.writeImportGroup(imports, PKG_REGEX_BOTH, false);
        this.writeImportGroup(imports, PKG_REGEX_JAVA, true);
        if (classJavaDocComment != null) {
            this.beginJavaDocComment();
            this.print(classJavaDocComment);
            this.endJavaDocComment();
        } else {
            this.println();
        }
        for (String annotation : annotationDeclarations) {
            String string = String.valueOf(String.valueOf(annotation));
            this.println(new StringBuilder(1 + string.length()).append("@").append(string).toString());
        }
        if (isClass) {
            this.emitClassDecl(targetClassShortName, superClassName, interfaceNames);
        } else {
            this.emitInterfaceDecl(targetClassShortName, superClassName, interfaceNames);
        }
        this.println(" {");
        this.indent();
    }

    @Override
    public void abort() {
        this.printWriter.abort();
    }

    @Override
    public void close() {
        super.close();
        this.printWriter.close();
    }

    @Override
    protected void writeString(String s) {
        this.printWriter.print(s);
    }

    private void emitClassDecl(String targetClassShortName, String superClassName, Iterable<String> interfaceNames) {
        String string = String.valueOf(targetClassShortName);
        this.print(string.length() != 0 ? "public class ".concat(string) : new String("public class "));
        if (superClassName != null) {
            String string2 = String.valueOf(superClassName);
            this.print(string2.length() != 0 ? " extends ".concat(string2) : new String(" extends "));
        }
        boolean first = true;
        for (String interfaceName : interfaceNames) {
            if (first) {
                this.print(" implements ");
                first = false;
            } else {
                this.print(", ");
            }
            this.print(interfaceName);
        }
    }

    private void emitInterfaceDecl(String targetClassShortName, String superClassName, Iterable<String> interfaceNames) {
        if (superClassName != null) {
            String string = String.valueOf(String.valueOf(superClassName));
            throw new IllegalArgumentException(new StringBuilder(43 + string.length()).append("Cannot set superclass name ").append(string).append(" on a interface.").toString());
        }
        String string = String.valueOf(targetClassShortName);
        this.print(string.length() != 0 ? "public interface ".concat(string) : new String("public interface "));
        boolean first = true;
        for (String interfaceName : interfaceNames) {
            if (first) {
                this.print(" extends ");
                first = false;
            } else {
                this.print(", ");
            }
            this.print(interfaceName);
        }
    }

    private void writeImportGroup(Iterable<String> imports, Pattern regex, boolean includeMatches) {
        boolean firstOfGroup = true;
        for (String importEntry : imports) {
            Matcher matcher = regex.matcher(importEntry);
            if (matcher.matches() != includeMatches) continue;
            if (firstOfGroup) {
                this.println();
                firstOfGroup = false;
            }
            String string = String.valueOf(String.valueOf(importEntry));
            this.println(new StringBuilder(8 + string.length()).append("import ").append(string).append(";").toString());
        }
    }
}

