/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.animation.WidgetAnimation;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class DeckPanel
extends ComplexPanel
implements HasAnimation {
    private static SlideAnimation slideAnimation;
    private boolean isAnimationEnabled = false;
    private Widget visibleWidget;

    private static Element getContainer(Widget w) {
        return DOM.getParent(w.getElement());
    }

    public DeckPanel() {
        this.setElement(DOM.createDiv());
    }

    public void add(Widget w) {
        Element container = DOM.createDiv();
        DOM.appendChild(this.getElement(), container);
        this.initChildWidget(w);
        this.initWidgetContainer(container);
        super.add(w, container);
    }

    public int getVisibleWidget() {
        return this.getWidgetIndex(this.visibleWidget);
    }

    public void insert(Widget w, int beforeIndex) {
        Element container = DOM.createDiv();
        DOM.insertChild(this.getElement(), container, beforeIndex);
        this.initChildWidget(w);
        this.initWidgetContainer(container);
        super.insert(w, container, beforeIndex, true);
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean remove(Widget w) {
        Element container = DeckPanel.getContainer(w);
        boolean removed = super.remove(w);
        if (removed) {
            this.resetChildWidget(w);
            DOM.removeChild(this.getElement(), container);
            if (this.visibleWidget == w) {
                this.visibleWidget = null;
            }
        }
        return removed;
    }

    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void showWidget(int index) {
        this.checkIndexBoundsForAccess(index);
        Widget oldWidget = this.visibleWidget;
        this.visibleWidget = this.getWidget(index);
        if (this.visibleWidget != oldWidget) {
            if (slideAnimation == null) {
                slideAnimation = new SlideAnimation();
            }
            slideAnimation.showWidget(oldWidget, this.visibleWidget, this.isAnimationEnabled && this.isAttached());
        }
    }

    private void initChildWidget(Widget w) {
        w.setSize("100%", "100%");
    }

    private void initWidgetContainer(Element container) {
        DOM.setStyleAttribute(container, "width", "100%");
        DOM.setStyleAttribute(container, "height", "100%");
        DOM.setStyleAttribute(container, "overflow", "hidden");
        DOM.setStyleAttribute(container, "padding", "0px");
        DOM.setStyleAttribute(container, "margin", "0px");
        UIObject.setVisible(container, false);
    }

    private void resetChildWidget(Widget w) {
        w.setSize("", "");
    }

    private static class SlideAnimation
    extends WidgetAnimation {
        private Element container1 = null;
        private Element container2 = null;
        private boolean growing = false;
        private int fixedHeight = -1;

        private SlideAnimation() {
        }

        public void onCancel() {
            this.onComplete();
        }

        public void onComplete() {
            if (this.growing) {
                this.onUpdate(1.0);
                DOM.setStyleAttribute(this.container1, "height", "100%");
                UIObject.setVisible(this.container1, true);
                UIObject.setVisible(this.container2, false);
                DOM.setStyleAttribute(this.container2, "height", "100%");
            } else {
                UIObject.setVisible(this.container1, false);
                DOM.setStyleAttribute(this.container1, "height", "100%");
                DOM.setStyleAttribute(this.container2, "height", "100%");
                UIObject.setVisible(this.container2, true);
            }
            this.container1 = null;
            this.container2 = null;
        }

        public void onInstantaneousRun() {
            UIObject.setVisible(this.container1, this.growing);
            UIObject.setVisible(this.container2, !this.growing);
            this.container1 = null;
            this.container2 = null;
        }

        public void onStart() {
            this.onUpdate(0.0);
            UIObject.setVisible(this.container1, true);
            UIObject.setVisible(this.container2, true);
        }

        public void onUpdate(double progress) {
            int height2;
            int height1;
            if (!this.growing) {
                progress = 1.0 - progress;
            }
            if (this.fixedHeight == -1) {
                height1 = (int)(progress * (double)DOM.getElementPropertyInt(this.container1, "scrollHeight"));
                height2 = (int)((1.0 - progress) * (double)DOM.getElementPropertyInt(this.container2, "scrollHeight"));
            } else {
                height1 = (int)(progress * (double)this.fixedHeight);
                height2 = this.fixedHeight - height1;
            }
            DOM.setStyleAttribute(this.container1, "height", height1 + "px");
            DOM.setStyleAttribute(this.container2, "height", height2 + "px");
        }

        public void showWidget(Widget oldWidget, Widget newWidget, boolean animate) {
            this.cancel();
            Element newContainer = DeckPanel.getContainer(newWidget);
            int newIndex = DOM.getChildIndex(DOM.getParent(newContainer), newContainer);
            if (oldWidget == null) {
                UIObject.setVisible(newContainer, true);
                return;
            }
            Element oldContainer = DeckPanel.getContainer(oldWidget);
            int oldIndex = DOM.getChildIndex(DOM.getParent(oldContainer), oldContainer);
            if (newIndex > oldIndex) {
                this.container1 = oldContainer;
                this.container2 = newContainer;
                this.growing = false;
            } else {
                this.container1 = newContainer;
                this.container2 = oldContainer;
                this.growing = true;
            }
            this.fixedHeight = DOM.getElementPropertyInt(oldContainer, "offsetHeight");
            if (this.fixedHeight == oldWidget.getOffsetHeight()) {
                this.fixedHeight = -1;
            }
            if (animate) {
                this.run(350);
            } else {
                this.onInstantaneousRun();
            }
        }
    }
}

