/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamFactory;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.RemoteServiceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCallbackAdapter<T>
implements RequestCallback {
    private final AsyncCallback<T> callback;
    private final String methodName;
    private final int requestId;
    private final ResponseReader responseReader;
    private final SerializationStreamFactory streamFactory;

    public RequestCallbackAdapter(SerializationStreamFactory streamFactory, String methodName, int requestId, AsyncCallback<T> callback, ResponseReader responseReader) {
        assert (streamFactory != null);
        assert (callback != null);
        assert (responseReader != null);
        this.streamFactory = streamFactory;
        this.callback = callback;
        this.methodName = methodName;
        this.requestId = requestId;
        this.responseReader = responseReader;
    }

    @Override
    public void onError(Request request, Throwable exception) {
        this.callback.onFailure(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void onResponseReceived(Request request, Response response) {
        boolean toss;
        block11: {
            Throwable caught;
            Object result;
            block10: {
                result = null;
                caught = null;
                try {
                    boolean toss2;
                    String encodedResponse = response.getText();
                    boolean bl = toss2 = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseReceived", RemoteServiceProxy.bytesStat(this.methodName, this.requestId, encodedResponse.length()));
                    if (RemoteServiceProxy.isReturnValue(encodedResponse)) {
                        result = this.responseReader.read(this.streamFactory.createStreamReader(encodedResponse));
                        break block10;
                    }
                    caught = RemoteServiceProxy.isThrownException(encodedResponse) ? (Throwable)this.streamFactory.createStreamReader(encodedResponse).readObject() : new InvocationException(encodedResponse);
                }
                catch (SerializationException e) {
                    caught = new IncompatibleRemoteServiceException();
                    toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseDeserialized", RemoteServiceProxy.timeStat(this.methodName, this.requestId));
                }
                catch (Throwable e2) {
                    caught = e2;
                    {
                        catch (Throwable throwable) {
                            boolean toss3 = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseDeserialized", RemoteServiceProxy.timeStat(this.methodName, this.requestId));
                            throw throwable;
                        }
                    }
                    toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseDeserialized", RemoteServiceProxy.timeStat(this.methodName, this.requestId));
                }
            }
            toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseDeserialized", RemoteServiceProxy.timeStat(this.methodName, this.requestId));
            try {
                if (caught == null) {
                    this.callback.onSuccess(result);
                    break block11;
                }
                this.callback.onFailure(caught);
            }
            catch (Throwable throwable) {
                boolean toss4 = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseCallbackDone", RemoteServiceProxy.timeStat(this.methodName, this.requestId));
                throw throwable;
            }
        }
        toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(this.methodName + ":" + this.requestId + ":responseCallbackDone", RemoteServiceProxy.timeStat(this.methodName, this.requestId));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseReader {
        BOOLEAN{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readBoolean();
            }
        }
        ,
        BYTE{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readByte();
            }
        }
        ,
        CHAR{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Character.valueOf(streamReader.readChar());
            }
        }
        ,
        DOUBLE{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readDouble();
            }
        }
        ,
        FLOAT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Float.valueOf(streamReader.readFloat());
            }
        }
        ,
        INT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readInt();
            }
        }
        ,
        LONG{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readLong();
            }
        }
        ,
        OBJECT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readObject();
            }
        }
        ,
        SHORT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readShort();
            }
        }
        ,
        STRING{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readString();
            }
        }
        ,
        VOID{

            public Object read(SerializationStreamReader streamReader) {
                return null;
            }
        };


        public abstract Object read(SerializationStreamReader var1) throws SerializationException;
    }
}

