/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.animation;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.List;

public abstract class Animation {
    static AnimationImpl impl = (AnimationImpl)GWT.create(AnimationImpl.class);
    private int duration = -1;
    private boolean started = false;
    private double startTime = -1.0;

    public void cancel() {
        impl.cancel(this);
    }

    public abstract void onCancel();

    public abstract void onComplete();

    public abstract void onStart();

    public abstract void onUpdate(double var1);

    public void run(int duration) {
        this.run(duration, Duration.currentTimeMillis());
    }

    public void run(int duration, double startTime) {
        impl.run(this, duration, startTime);
    }

    protected double interpolate(double progress) {
        return (1.0 + Math.cos(Math.PI + progress * Math.PI)) / 2.0;
    }

    void onRunWhenDisabled() {
        this.onStart();
        this.onComplete();
    }

    private boolean update(double curTime) {
        if (!this.started && curTime >= this.startTime) {
            this.started = true;
            this.onStart();
        }
        if (curTime >= this.startTime + (double)this.duration) {
            this.started = false;
            this.onComplete();
            return true;
        }
        if (curTime >= this.startTime) {
            double progress = (curTime - this.startTime) / (double)this.duration;
            this.onUpdate(this.interpolate(progress));
        }
        return false;
    }

    public static class AnimationImplEnabled
    extends AnimationImpl {
        private static final int DEFAULT_FRAME_DELAY = 25;
        private static List<Animation> animations;
        private static Timer animationTimer;

        protected void cancel(Animation anim) {
            if (animations == null) {
                return;
            }
            anim.started = false;
            if (animations.remove(anim)) {
                anim.onCancel();
            }
        }

        protected void run(Animation anim, int duration, double startTime) {
            anim.cancel();
            anim.duration = duration;
            anim.startTime = startTime;
            if (anim.update(Duration.currentTimeMillis())) {
                return;
            }
            if (animations == null) {
                animations = new ArrayList<Animation>();
                animationTimer = new Timer(){

                    public void run() {
                        AnimationImplEnabled.this.updateAnimations();
                    }
                };
            }
            animations.add(anim);
            if (animations.size() == 1) {
                animationTimer.schedule(25);
            }
        }

        private void updateAnimations() {
            double curTime = Duration.currentTimeMillis();
            for (int i = 0; i < animations.size(); ++i) {
                Animation animation = animations.get(i);
                if (!animation.update(curTime)) continue;
                animations.remove(i);
                --i;
            }
            if (animations.size() > 0) {
                animationTimer.schedule(25);
            }
        }
    }

    public static class AnimationImpl {
        protected void cancel(Animation anim) {
        }

        protected void run(Animation anim, int duration, double startTime) {
            anim.onRunWhenDisabled();
        }
    }
}

