/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.ListIteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.Platform;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@NullMarked
@GwtCompatible
public class ListListIteratorTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET, ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testListIterator_unmodifiable() {
        this.runListIteratorTest(IteratorFeature.UNMODIFIABLE);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET, ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testListIterator_fullyModifiable() {
        this.runListIteratorTest(IteratorFeature.MODIFIABLE);
    }

    private void runListIteratorTest(Set<IteratorFeature> features) {
        new ListIteratorTester<E>(Platform.listListIteratorTesterNumIterations(), Collections.singleton(this.e4()), features, Helpers.copyToList(this.getOrderedElements()), 0){

            @Override
            protected ListIterator<E> newTargetIterator() {
                ListListIteratorTester.this.resetCollection();
                return ListListIteratorTester.this.getList().listIterator();
            }

            @Override
            protected void verify(List<E> elements) {
                ListListIteratorTester.this.expectContents(elements);
            }
        }.test();
    }

    public void testListIterator_tooLow() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().listIterator(-1));
    }

    public void testListIterator_tooHigh() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().listIterator(this.getNumElements() + 1));
    }

    public void testListIterator_atSize() {
        ListListIteratorTester.assertNotNull(this.getList().listIterator(this.getNumElements()));
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getListIteratorFullyModifiableMethod() {
        return Helpers.getMethod(ListListIteratorTester.class, "testListIterator_fullyModifiable");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getListIteratorUnmodifiableMethod() {
        return Helpers.getMethod(ListListIteratorTester.class, "testListIterator_unmodifiable");
    }
}

