/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.NullMarked;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@NullMarked
@GwtCompatible
public class ConcurrentMapRemoveTester<K, V>
extends AbstractMapTester<K, V> {
    @Override
    protected ConcurrentMap<K, V> getMap() {
        return (ConcurrentMap)super.getMap();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_supportedPresent() {
        ConcurrentMapRemoveTester.assertTrue((boolean)this.getMap().remove(this.k0(), this.v0()));
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_supportedPresentKeyWrongValue() {
        ConcurrentMapRemoveTester.assertFalse((boolean)this.getMap().remove(this.k0(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_supportedWrongKeyPresentValue() {
        ConcurrentMapRemoveTester.assertFalse((boolean)this.getMap().remove(this.k3(), this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_supportedAbsentKeyAbsentValue() {
        ConcurrentMapRemoveTester.assertFalse((boolean)this.getMap().remove(this.k3(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testRemove_nullKeyQueriesUnsupported() {
        try {
            ConcurrentMapRemoveTester.assertFalse((boolean)this.getMap().remove(null, this.v3()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testRemove_nullValueQueriesUnsupported() {
        try {
            ConcurrentMapRemoveTester.assertFalse((boolean)this.getMap().remove(this.k3(), null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupportedPresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().remove(this.k0(), this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedAbsent() {
        try {
            ConcurrentMapRemoveTester.assertFalse((boolean)this.getMap().remove(this.k0(), this.v3()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

