/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public final class StringWrapper {
    public static final String TEXT_BLOCK_DELIMITER = "\"\"\"";
    public static final CharMatcher STRING_CONCAT_DELIMITER = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"\"+"));

    public static String wrap(String input, Formatter formatter) throws FormatterException {
        return StringWrapper.wrap(100, input, formatter);
    }

    static String wrap(int columnLimit, String input, Formatter formatter) throws FormatterException {
        String actual;
        if (!StringWrapper.needWrapping(columnLimit, input)) {
            return input;
        }
        TreeRangeMap<Integer, String> replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        String firstPass = formatter.formatSource(input, replacements.asMapOfRanges().keySet());
        if (!firstPass.equals(input)) {
            input = firstPass;
            replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        }
        String result = StringWrapper.applyReplacements(input, replacements);
        String expected = StringWrapper.parse(input, true).toString();
        if (!expected.equals(actual = StringWrapper.parse(result, true).toString())) {
            throw new FormatterException(String.format("Something has gone terribly wrong. We planned to make the below formatting change, but have aborted because it would unexpectedly change the AST.\nPlease file a bug: https://github.com/google/google-java-format/issues/new\n\n=== Actual: ===\n%s\n=== Expected: ===\n%s\n", actual, expected));
        }
        return result;
    }

    private static TreeRangeMap<Integer, String> getReflowReplacements(int columnLimit, String input) throws FormatterException {
        return new Reflower(columnLimit, input).getReflowReplacements();
    }

    private static ImmutableList<String> stringComponents(String input, JCTree.JCCompilationUnit unit, List<Tree> flat) {
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder piece = new StringBuilder();
        for (Tree tree : flat) {
            String text = input.substring(StringWrapper.getStartPosition(tree) + 1, StringWrapper.getEndPosition(unit, tree) - 1);
            int start = 0;
            for (int idx = 0; idx < text.length(); ++idx) {
                if (!CharMatcher.whitespace().matches(text.charAt(idx)) && StringWrapper.hasEscapedWhitespaceAt(text, idx) == -1) {
                    int length;
                    if (StringWrapper.hasEscapedNewlineAt(text, idx) == -1) continue;
                    while ((length = StringWrapper.hasEscapedNewlineAt(text, idx)) != -1) {
                        idx += length;
                    }
                }
                piece.append(text, start, idx);
                result.add((Object)piece.toString());
                piece = new StringBuilder();
                start = idx;
            }
            if (piece.length() > 0) {
                result.add((Object)piece.toString());
                piece = new StringBuilder();
            }
            if (start >= text.length()) continue;
            piece.append(text, start, text.length());
        }
        if (piece.length() > 0) {
            result.add((Object)piece.toString());
        }
        return result.build();
    }

    static int hasEscapedWhitespaceAt(String input, int idx) {
        return Stream.of("\\t").mapToInt(x -> input.startsWith((String)x, idx) ? x.length() : -1).filter(x -> x != -1).findFirst().orElse(-1);
    }

    static int hasEscapedNewlineAt(String input, int idx) {
        return Stream.of("\\r\\n", "\\r", "\\n").mapToInt(x -> input.startsWith((String)x, idx) ? x.length() : -1).filter(x -> x != -1).findFirst().orElse(-1);
    }

    private static String reflow(String separator, int columnLimit, int startColumn, int trailing, ImmutableList<String> components, boolean first0) {
        int width = columnLimit - startColumn - 2;
        ArrayDeque<String> input = new ArrayDeque<String>((Collection<String>)components);
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = first0;
        while (!input.isEmpty()) {
            int length = 0;
            ArrayList<String> line = new ArrayList<String>();
            if (input.stream().mapToInt(String::length).sum() <= width) {
                width -= trailing;
            }
            while (!(input.isEmpty() || length > 4 && length + ((String)input.peekFirst()).length() > width)) {
                String text = (String)input.removeFirst();
                line.add(text);
                length += text.length();
                if (!text.endsWith("\\n") && !text.endsWith("\\r")) continue;
                break;
            }
            if (line.isEmpty()) {
                line.add((String)input.removeFirst());
            }
            lines.add(String.join((CharSequence)"", line));
            if (!first) continue;
            width -= 6;
            first = false;
        }
        return lines.stream().collect(Collectors.joining("\"" + separator + Strings.repeat((String)" ", (int)(startColumn + (first0 ? 4 : -2))) + "+ \"", "\"", "\""));
    }

    private static List<Tree> flatten(String input, JCTree.JCCompilationUnit unit, TreePath path, TreePath parent, AtomicBoolean firstInChain) {
        int startIdx;
        ArrayList<Tree> flat = new ArrayList<Tree>();
        ArrayDeque<Tree> todo = new ArrayDeque<Tree>();
        todo.add(parent.getLeaf());
        while (!todo.isEmpty()) {
            Tree first = (Tree)todo.removeFirst();
            if (first.getKind() == Tree.Kind.PLUS) {
                BinaryTree bt = (BinaryTree)first;
                todo.addFirst(bt.getRightOperand());
                todo.addFirst(bt.getLeftOperand());
                continue;
            }
            flat.add(first);
        }
        int idx = flat.indexOf(path.getLeaf());
        Verify.verify((idx != -1 ? 1 : 0) != 0);
        int endIdx = idx + 1;
        for (startIdx = idx; startIdx > 0 && ((Tree)flat.get(startIdx - 1)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, (Tree)flat.get(startIdx - 1), (Tree)flat.get(startIdx)); --startIdx) {
        }
        while (endIdx < flat.size() && ((Tree)flat.get(endIdx)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, (Tree)flat.get(endIdx - 1), (Tree)flat.get(endIdx))) {
            ++endIdx;
        }
        firstInChain.set(startIdx == 0);
        return ImmutableList.copyOf(flat.subList(startIdx, endIdx));
    }

    private static boolean noComments(String input, JCTree.JCCompilationUnit unit, Tree one, Tree two) {
        return STRING_CONCAT_DELIMITER.matchesAllOf(input.subSequence(StringWrapper.getEndPosition(unit, one), StringWrapper.getStartPosition(two)));
    }

    private static int getEndPosition(JCTree.JCCompilationUnit unit, Tree tree) {
        return ((JCTree)tree).getEndPosition(unit.endPositions);
    }

    private static int getStartPosition(Tree tree) {
        return ((JCTree)tree).getStartPosition();
    }

    private static boolean needWrapping(int columnLimit, String input) {
        Iterator<String> it = Newlines.lineIterator(input);
        while (it.hasNext()) {
            String line = it.next();
            if (line.length() <= columnLimit && !line.contains(TEXT_BLOCK_DELIMITER)) continue;
            return true;
        }
        return false;
    }

    private static JCTree.JCCompilationUnit parse(final String source, boolean allowStringFolding) throws FormatterException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        Context context = new Context();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("--enable-preview", "true");
        Options.instance(context).put("allowStringFolding", Boolean.toString(allowStringFolding));
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, (Iterable<? extends File>)ImmutableList.of());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        SimpleJavaFileObject sjfo = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return source;
            }
        };
        Log.instance(context).useSource(sjfo);
        ParserFactory parserFactory = ParserFactory.instance(context);
        JavacParser parser = parserFactory.newParser(source, true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = sjfo;
        Iterable errorDiagnostics = Iterables.filter(diagnostics.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit;
    }

    private static String applyReplacements(String javaInput, TreeRangeMap<Integer, String> replacementMap) throws FormatterException {
        Map ranges = replacementMap.asDescendingMapOfRanges();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(javaInput);
        for (Map.Entry entry : ranges.entrySet()) {
            Range range = (Range)entry.getKey();
            sb.replace((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), (String)entry.getValue());
        }
        return sb.toString();
    }

    private StringWrapper() {
    }

    private static class Reflower {
        private final String input;
        private final int columnLimit;
        private final String separator;
        private final JCTree.JCCompilationUnit unit;
        private final Position.LineMap lineMap;

        Reflower(int columnLimit, String input) throws FormatterException {
            this.columnLimit = columnLimit;
            this.input = input;
            this.separator = Newlines.guessLineSeparator(input);
            this.unit = StringWrapper.parse(input, false);
            this.lineMap = this.unit.getLineMap();
        }

        TreeRangeMap<Integer, String> getReflowReplacements() {
            ArrayList<TreePath> longStringLiterals = new ArrayList<TreePath>();
            ArrayList<Tree> textBlocks = new ArrayList<Tree>();
            new LongStringsAndTextBlockScanner(longStringLiterals, textBlocks).scan(new TreePath(this.unit), null);
            TreeRangeMap replacements = TreeRangeMap.create();
            this.indentTextBlocks((TreeRangeMap<Integer, String>)replacements, textBlocks);
            this.wrapLongStrings((TreeRangeMap<Integer, String>)replacements, longStringLiterals);
            return replacements;
        }

        private void indentTextBlocks(TreeRangeMap<Integer, String> replacements, List<Tree> textBlocks) {
            for (Tree tree : textBlocks) {
                int startPosition = StringWrapper.getStartPosition(tree);
                int endPosition = StringWrapper.getEndPosition(this.unit, tree);
                String text = this.input.substring(startPosition, endPosition);
                int lineStartPosition = this.lineMap.getStartPosition(this.lineMap.getLineNumber(startPosition));
                int startColumn = CharMatcher.whitespace().negate().indexIn((CharSequence)this.input.substring(lineStartPosition, endPosition)) + 1;
                ImmutableList initialLines = (ImmutableList)text.lines().collect(ImmutableList.toImmutableList());
                String stripped = initialLines.stream().skip(1L).collect(Collectors.joining(this.separator)).stripIndent();
                ImmutableList lines = (ImmutableList)stripped.lines().collect(ImmutableList.toImmutableList());
                int deindent = ((String)Iterables.getLast((Iterable)initialLines)).stripTrailing().length() - ((String)Iterables.getLast((Iterable)lines)).stripTrailing().length();
                String prefix = deindent == 0 || lines.stream().anyMatch(x -> x.length() + startColumn - 1 > this.columnLimit) ? "" : " ".repeat(startColumn - 1);
                StringBuilder output = new StringBuilder(((String)initialLines.get(0)).stripLeading());
                for (int i = 0; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    String trimmed = line.stripTrailing();
                    output.append(this.separator);
                    if (!trimmed.isEmpty()) {
                        output.append(prefix);
                    }
                    if (i == lines.size() - 1) {
                        String withoutDelimiter = trimmed.substring(0, trimmed.length() - StringWrapper.TEXT_BLOCK_DELIMITER.length());
                        if (!withoutDelimiter.stripLeading().isEmpty()) {
                            output.append(withoutDelimiter).append('\\').append(this.separator).append(prefix);
                        }
                        output.append(StringWrapper.TEXT_BLOCK_DELIMITER);
                        continue;
                    }
                    output.append(line);
                }
                replacements.put(Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)), (Object)output.toString());
            }
        }

        private void wrapLongStrings(TreeRangeMap<Integer, String> replacements, List<TreePath> longStringLiterals) {
            Iterator<TreePath> iterator = longStringLiterals.iterator();
            while (iterator.hasNext()) {
                int end;
                TreePath path;
                TreePath enclosing = path = iterator.next();
                while (enclosing.getParentPath().getLeaf().getKind() == Tree.Kind.PLUS) {
                    enclosing = enclosing.getParentPath();
                }
                AtomicBoolean first = new AtomicBoolean(false);
                List<Tree> flat = StringWrapper.flatten(this.input, this.unit, path, enclosing, first);
                int startColumn = this.lineMap.getColumnNumber(StringWrapper.getStartPosition(flat.get(0))) - 1;
                int lineEnd = end = StringWrapper.getEndPosition(this.unit, (Tree)Iterables.getLast(flat));
                while (Newlines.hasNewlineAt(this.input, lineEnd) == -1) {
                    ++lineEnd;
                }
                int trailing = lineEnd - end;
                ImmutableList<String> components = StringWrapper.stringComponents(this.input, this.unit, flat);
                replacements.put(Range.closedOpen((Comparable)Integer.valueOf(StringWrapper.getStartPosition(flat.get(0))), (Comparable)Integer.valueOf(StringWrapper.getEndPosition(this.unit, (Tree)Iterables.getLast(flat)))), (Object)StringWrapper.reflow(this.separator, this.columnLimit, startColumn, trailing, components, first.get()));
            }
        }

        private class LongStringsAndTextBlockScanner
        extends TreePathScanner<Void, Void> {
            private final List<TreePath> longStringLiterals;
            private final List<Tree> textBlocks;

            LongStringsAndTextBlockScanner(List<TreePath> longStringLiterals, List<Tree> textBlocks) {
                this.longStringLiterals = longStringLiterals;
                this.textBlocks = textBlocks;
            }

            @Override
            public Void visitLiteral(LiteralTree literalTree, Void aVoid) {
                int endPosition;
                if (literalTree.getKind() != Tree.Kind.STRING_LITERAL) {
                    return null;
                }
                int pos = StringWrapper.getStartPosition(literalTree);
                if (Reflower.this.input.substring(pos, Math.min(Reflower.this.input.length(), pos + 3)).equals(StringWrapper.TEXT_BLOCK_DELIMITER)) {
                    this.textBlocks.add(literalTree);
                    return null;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (parent instanceof MemberSelectTree && ((MemberSelectTree)parent).getExpression().equals(literalTree)) {
                    return null;
                }
                int lineEnd = endPosition = StringWrapper.getEndPosition(Reflower.this.unit, literalTree);
                while (Newlines.hasNewlineAt(Reflower.this.input, lineEnd) == -1) {
                    ++lineEnd;
                }
                if (Reflower.this.lineMap.getColumnNumber(lineEnd) - 1 <= Reflower.this.columnLimit) {
                    return null;
                }
                this.longStringLiterals.add(this.getCurrentPath());
                return null;
            }
        }
    }
}

