/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.html;

import com.google.gdata.util.common.base.StringUtil;
import java.util.regex.Pattern;

public final class HtmlToText {
    private static final Pattern htmlNewlinePattern = Pattern.compile("\\s*<(br|/?p)>\\s*");
    private static final Pattern htmlListPattern = Pattern.compile("\\s*<li>\\s*");
    private static final Pattern htmlTagPattern = Pattern.compile("</?([^<]*)>");
    public static final int EMAIL_LINE_WIDTH_MAX = 72;

    private HtmlToText() {
    }

    public static String htmlToPlainText(String html) {
        if (html == null) {
            throw new NullPointerException("Html parameter may not be null.");
        }
        String text = StringUtil.stripAndCollapse(html);
        text = htmlNewlinePattern.matcher(text).replaceAll("\n");
        text = htmlListPattern.matcher(text).replaceAll("\n- ");
        text = htmlTagPattern.matcher(text).replaceAll("");
        text = StringUtil.unescapeHTML(text).trim();
        return StringUtil.fixedWidth(text.split("\n"), 72);
    }
}

