/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface ErrorContent {
    public String getDomainName();

    public String getCodeName();

    public String getLocation();

    public LocationType getLocationType();

    public String getInternalReason();

    public String getExtendedHelp();

    public String getSendReport();

    public String getDebugInfo();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        XPATH,
        HEADER,
        OTHER;

        private static final Map<String, LocationType> VALUE_MAP;

        public static LocationType fromString(String value) {
            return VALUE_MAP.get(value);
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            HashMap<String, LocationType> map = new HashMap<String, LocationType>();
            for (LocationType locationType : LocationType.values()) {
                map.put(locationType.toString(), locationType);
            }
            VALUE_MAP = Collections.unmodifiableMap(map);
        }
    }
}

