/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.Source;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.util.EventSourceParser;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ParseUtil;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFeed<F extends BaseFeed, E extends BaseEntry>
extends Source
implements Kind.Adaptable,
Kind.Adaptor,
IFeed {
    protected FeedState feedState;
    protected Class<? extends E> entryClass;
    protected List<E> entries = new LinkedList();
    private static final Collection<XmlWriter.Attribute> rssHeaderAttrs = new Vector<XmlWriter.Attribute>(1);

    protected BaseFeed(Class<? extends E> entryClass) {
        this.feedState = new FeedState();
        this.entryClass = entryClass;
    }

    protected BaseFeed(Class<? extends E> entryClass, BaseFeed<?, ?> sourceFeed) {
        super(sourceFeed);
        this.feedState = sourceFeed.feedState;
        this.entryClass = entryClass;
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        IEntry entry = this.createEntry();
        extProfile.addDeclarations((Kind.Adaptor)((Object)entry));
    }

    public Service getService() {
        return this.feedState.service;
    }

    @Override
    public void setService(Service v) {
        this.feedState.service = v;
        for (BaseEntry entry : this.entries) {
            entry.setService(v);
        }
    }

    @Override
    public boolean getCanPost() {
        return this.feedState.canPost;
    }

    @Override
    public void setCanPost(boolean v) {
        this.feedState.canPost = v;
    }

    @Override
    public void setVersionId(String v) {
        this.feedState.versionId = v;
    }

    @Override
    public String getVersionId() {
        return this.feedState.versionId;
    }

    @Override
    public String getEtag() {
        return this.feedState.etag;
    }

    @Override
    public void setEtag(String v) {
        this.feedState.etag = v;
    }

    @Override
    public String getKind() {
        return this.feedState.kind;
    }

    @Override
    public void setKind(String v) {
        this.feedState.kind = v;
    }

    @Override
    public int getTotalResults() {
        return this.feedState.totalResults;
    }

    @Override
    public void setTotalResults(int v) {
        this.feedState.totalResults = v;
    }

    @Override
    public int getStartIndex() {
        return this.feedState.startIndex;
    }

    @Override
    public void setStartIndex(int v) {
        this.feedState.startIndex = v;
    }

    @Override
    public int getItemsPerPage() {
        return this.feedState.itemsPerPage;
    }

    @Override
    public void setItemsPerPage(int v) {
        this.feedState.itemsPerPage = v;
    }

    public List<E> getEntries() {
        return this.entries;
    }

    public void setEntries(List<E> entryList) {
        this.entries = entryList;
    }

    @Override
    public void addAdaptor(Kind.Adaptor adaptor) {
        this.feedState.adaptable.addAdaptor(adaptor);
    }

    @Override
    public Collection<Kind.Adaptor> getAdaptors() {
        return this.feedState.adaptable.getAdaptors();
    }

    public <A extends Kind.Adaptor> A getAdaptor(Class<A> adaptorClass) {
        return this.feedState.adaptable.getAdaptor(adaptorClass);
    }

    public E createEntry() {
        BaseEntry entry;
        try {
            entry = (BaseEntry)this.entryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (this.feedState.service != null) {
            entry.setService(this.feedState.service);
        }
        return (E)entry;
    }

    @Override
    public Link getEntryPostLink() {
        ILink postLink = this.getLink("http://schemas.google.com/g/2005#post", ILink.Type.ATOM);
        return postLink;
    }

    @Override
    public Link getSelfLink() {
        ILink postLink = this.getLink("self", ILink.Type.ATOM);
        return postLink;
    }

    @Override
    public Link getNextLink() {
        return this.getLink("next", ILink.Type.ATOM);
    }

    @Override
    public Link getPreviousLink() {
        return this.getLink("previous", ILink.Type.ATOM);
    }

    @Override
    public Link getFeedBatchLink() {
        return this.getLink("http://schemas.google.com/g/2005#batch", ILink.Type.ATOM);
    }

    public F getSelf() throws IOException, ServiceException {
        if (this.feedState.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.feedNotAssociated);
        }
        Link selfLink = this.getSelfLink();
        if (selfLink == null) {
            throw new UnsupportedOperationException("Feed cannot be retrieved");
        }
        URL feedUrl = new URL(selfLink.getHref());
        try {
            if (this.feedState.etag != null) {
                return (F)((BaseFeed)this.feedState.service.getFeed(feedUrl, this.getClass(), this.feedState.etag));
            }
            return (F)((BaseFeed)this.feedState.service.getFeed(feedUrl, this.getClass(), this.srcState.updated));
        }
        catch (NotModifiedException e) {
            return (F)this;
        }
    }

    public <T extends E> T insert(T newEntry) throws ServiceException, IOException {
        if (this.feedState.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link postLink = this.getEntryPostLink();
        if (postLink == null) {
            throw new UnsupportedOperationException("Media cannot be inserted");
        }
        URL postUrl = new URL(postLink.getHref());
        return (T)((BaseEntry)this.feedState.service.insert(postUrl, newEntry));
    }

    @Override
    protected void visitChildren(ExtensionVisitor ev) throws ExtensionVisitor.StoppedException {
        for (BaseEntry entry : this.entries) {
            this.visitChild(ev, entry);
        }
        for (Link link : this.getLinks()) {
            this.visitChild(ev, link);
        }
        super.visitChildren(ev);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
        this.generateAtom(w, p);
    }

    @Override
    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        this.generateFeedStart(extProfile, w, null);
        this.generateEntries(w, extProfile);
        this.generateFeedEnd(w);
    }

    private void generateEntries(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        w.startRepeatingElement();
        for (BaseEntry entry : this.entries) {
            entry.generateAtom(w, extProfile);
        }
        w.endRepeatingElement();
    }

    public void generateFeedEnd(XmlWriter w) throws IOException {
        w.endElement(Namespaces.atomNs, "feed");
    }

    public void generateFeedStart(ExtensionProfile extProfile, XmlWriter w, Collection<XmlNamespace> namespaces) throws IOException {
        XmlNamespace openSearchNs = Namespaces.getOpenSearchNs();
        LinkedHashSet<XmlNamespace> nsDecls = new LinkedHashSet<XmlNamespace>();
        nsDecls.add(Namespaces.atomNs);
        nsDecls.add(openSearchNs);
        nsDecls.addAll(extProfile.getNamespaceDecls());
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (this.feedState.kind != null && Service.getVersion().isAfter(Service.Versions.V1)) {
            nsDecls.add(Namespaces.gNs);
            attrs.add(new XmlWriter.Attribute("gd", "kind", this.feedState.kind));
        }
        if (this.feedState.etag != null && Service.getVersion().isAfter(Service.Versions.V1)) {
            nsDecls.add(Namespaces.gNs);
            attrs.add(new XmlWriter.Attribute("gd", "etag", this.feedState.etag));
        }
        AttributeGenerator generator = new AttributeGenerator();
        this.putAttributes(generator);
        this.generateAttributes(attrs, generator);
        this.generateStartElement(w, Namespaces.atomNs, "feed", attrs, nsDecls);
        this.generateInnerAtom(w, extProfile);
        if (this.getTotalResults() != -1) {
            w.simpleElement(openSearchNs, "totalResults", null, String.valueOf(this.feedState.totalResults));
        }
        if (this.getStartIndex() != -1) {
            w.simpleElement(openSearchNs, "startIndex", null, String.valueOf(this.feedState.startIndex));
        }
        if (this.getItemsPerPage() != -1) {
            w.simpleElement(openSearchNs, "itemsPerPage", null, String.valueOf(this.feedState.itemsPerPage));
        }
        this.generateExtensions(w, extProfile);
    }

    public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        String name;
        String lang;
        XmlNamespace openSearchNs = Namespaces.getOpenSearchNs();
        Vector<XmlNamespace> nsDecls = new Vector<XmlNamespace>();
        nsDecls.add(Namespaces.atomNs);
        nsDecls.add(openSearchNs);
        nsDecls.addAll(extProfile.getNamespaceDecls());
        w.startElement(Namespaces.rssNs, "rss", rssHeaderAttrs, nsDecls);
        this.generateStartElement(w, Namespaces.rssNs, "channel", null, null);
        if (this.srcState.id != null) {
            w.simpleElement(Namespaces.atomNs, "id", null, this.srcState.id);
        }
        if (this.xmlBlob != null && (lang = this.xmlBlob.getLang()) != null) {
            w.simpleElement(Namespaces.rssNs, "language", null, lang);
        }
        if (this.srcState.updated != null) {
            w.simpleElement(Namespaces.rssNs, "lastBuildDate", null, this.srcState.updated.toStringRfc822());
        }
        w.startRepeatingElement();
        for (Category cat : this.srcState.categories) {
            cat.generateRss(w);
        }
        w.endRepeatingElement();
        if (this.srcState.title != null) {
            this.srcState.title.generateRss(w, "title", TextConstruct.RssFormat.PLAIN_TEXT);
        }
        if (this.srcState.subtitle != null) {
            this.srcState.subtitle.generateRss(w, "description", TextConstruct.RssFormat.FULL_HTML);
        } else {
            w.simpleElement(Namespaces.rssNs, "description", null, null);
        }
        Link htmlLink = this.getHtmlLink();
        if (htmlLink != null) {
            w.simpleElement(Namespaces.rssNs, "link", null, htmlLink.getHref());
        }
        if (this.srcState.logo != null || this.srcState.icon != null) {
            w.startElement(Namespaces.rssNs, "image", null, null);
            w.simpleElement(Namespaces.rssNs, "url", null, this.srcState.logo != null ? this.srcState.logo : this.srcState.icon);
            if (this.srcState.title != null) {
                this.srcState.title.generateRss(w, "title", TextConstruct.RssFormat.PLAIN_TEXT);
            }
            if (htmlLink != null) {
                w.simpleElement(Namespaces.rssNs, "link", null, htmlLink.getHref());
            }
            w.endElement(Namespaces.rssNs, "image");
        }
        if (this.srcState.rights != null) {
            this.srcState.rights.generateRss(w, "copyright", TextConstruct.RssFormat.PLAIN_TEXT);
        }
        if (this.srcState.authors.size() > 0) {
            this.srcState.authors.get(0).generateRss(w, "managingEditor");
        }
        if (this.srcState.generator != null && (name = this.srcState.generator.getName()) != null) {
            w.simpleElement(Namespaces.rssNs, "generator", null, name);
        }
        if (this.getTotalResults() != -1) {
            w.simpleElement(openSearchNs, "totalResults", null, String.valueOf(this.feedState.totalResults));
        }
        if (this.getStartIndex() != -1) {
            w.simpleElement(openSearchNs, "startIndex", null, String.valueOf(this.feedState.startIndex));
        }
        if (this.getItemsPerPage() != -1) {
            w.simpleElement(openSearchNs, "itemsPerPage", null, String.valueOf(this.feedState.itemsPerPage));
        }
        this.generateExtensions(w, extProfile);
        w.startRepeatingElement();
        for (BaseEntry entry : this.entries) {
            entry.generateRss(w, extProfile);
        }
        w.endRepeatingElement();
        w.endElement(Namespaces.rssNs, "channel");
        w.endElement(Namespaces.rssNs, "rss");
    }

    public static BaseFeed<?, ?> readFeed(ParseSource source) throws IOException, ParseException, ServiceException {
        return BaseFeed.readFeed(source, null, null);
    }

    public static <F extends BaseFeed> F readFeed(ParseSource source, Class<F> feedClass, ExtensionProfile extProfile) throws IOException, ParseException, ServiceException {
        return (F)((BaseFeed)ParseUtil.readFeed(source, feedClass, extProfile, null));
    }

    @Override
    public void parseAtom(ExtensionProfile extProfile, InputStream input) throws IOException, ParseException {
        FeedHandler handler = new FeedHandler(extProfile);
        new XmlParser().parse(input, (XmlParser.ElementHandler)handler, "http://www.w3.org/2005/Atom", "feed");
    }

    @Override
    public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
        FeedHandler handler = new FeedHandler(extProfile);
        new XmlParser().parse(reader, (XmlParser.ElementHandler)handler, "http://www.w3.org/2005/Atom", "feed");
    }

    public void parseAtom(ExtensionProfile extProfile, XmlEventSource source) throws IOException, ParseException {
        FeedHandler handler = new FeedHandler(extProfile);
        new EventSourceParser(handler, "http://www.w3.org/2005/Atom", "feed").parse(source);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) throws ParseException {
        return new FeedHandler(p);
    }

    public BaseFeed<?, ?> getAdaptedFeed() throws Kind.AdaptorException {
        Object adaptedFeed = null;
        for (Kind.Adaptor adaptor : this.getAdaptors()) {
            if (!(adaptor instanceof BaseFeed) || adaptedFeed != null && !adaptedFeed.getClass().isAssignableFrom(adaptor.getClass())) continue;
            adaptedFeed = (BaseFeed)adaptor;
        }
        if (adaptedFeed != null) {
            List<E> sourceEntries;
            if (adaptedFeed != this) {
                sourceEntries = this.entries;
            } else {
                sourceEntries = new ArrayList();
                sourceEntries.addAll(this.entries);
            }
            ((BaseFeed)adaptedFeed).getEntries().clear();
            for (BaseEntry entry : sourceEntries) {
                ((BaseFeed)adaptedFeed).getEntries().add(entry.getAdaptedEntry());
            }
        }
        return adaptedFeed;
    }

    public <T extends BaseEntry> List<T> getEntries(Class<T> returnClass) {
        ArrayList<BaseEntry> adaptedEntries = new ArrayList<BaseEntry>();
        for (BaseEntry entry : this.getEntries()) {
            BaseEntry adapted = (BaseEntry)entry.getAdaptor(returnClass);
            if (adapted == null) continue;
            adaptedEntries.add(adapted);
        }
        return adaptedEntries;
    }

    static {
        rssHeaderAttrs.add(new XmlWriter.Attribute("version", "2.0"));
    }

    public class FeedHandler
    extends Source.SourceHandler {
        private XmlNamespace openSearchNs;

        public FeedHandler(ExtensionProfile extProfile) {
            super(BaseFeed.this, extProfile, BaseFeed.this.getClass());
            this.openSearchNs = Namespaces.getOpenSearchNs();
        }

        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("http://schemas.google.com/g/2005")) {
                if (localName.equals("etag")) {
                    BaseFeed.this.setEtag(value);
                    return;
                }
                if (localName.equals("kind")) {
                    BaseFeed.this.setKind(value);
                    return;
                }
            }
            super.processAttribute(namespace, localName, value);
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            XmlParser.ElementHandler extensionHandler = BaseFeed.this.getExtensionHandler(this.extProfile, BaseFeed.this.getClass(), namespace, localName, attrs);
            if (extensionHandler != null) {
                return extensionHandler;
            }
            if (namespace.equals("http://www.w3.org/2005/Atom")) {
                if (localName.equals("entry")) {
                    IEntry entry = BaseFeed.this.createEntry();
                    BaseFeed.this.entries.add(entry);
                    IEntry iEntry = entry;
                    iEntry.getClass();
                    return (BaseEntry)iEntry.new BaseEntry.AtomHandler(this.extProfile);
                }
                return super.getChildHandler(namespace, localName, attrs);
            }
            if (namespace.equals(this.openSearchNs.getUri())) {
                if (localName.equals("totalResults")) {
                    return new TotalResultsHandler();
                }
                if (localName.equals("startIndex")) {
                    return new StartIndexHandler();
                }
                if (localName.equals("itemsPerPage")) {
                    return new ItemsPerPageHandler();
                }
            } else {
                return super.getChildHandler(namespace, localName, attrs);
            }
            return null;
        }

        public void processEndElement() {
            BaseFeed.this.feedState.canPost = BaseFeed.this.getEntryPostLink() != null;
        }

        private class ItemsPerPageHandler
        extends XmlParser.ElementHandler {
            private ItemsPerPageHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseFeed.this.feedState.itemsPerPage != -1) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateItemsPerPage);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.logoValueRequired);
                }
                try {
                    BaseFeed.this.feedState.itemsPerPage = Integer.valueOf(this.value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(CoreErrorDomain.ERR.itemsPerPageNotInteger);
                }
            }
        }

        private class StartIndexHandler
        extends XmlParser.ElementHandler {
            private StartIndexHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseFeed.this.feedState.startIndex != -1) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateStartIndex);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.logoValueRequired);
                }
                try {
                    BaseFeed.this.feedState.startIndex = Integer.valueOf(this.value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(CoreErrorDomain.ERR.startIndexNotInteger);
                }
            }
        }

        private class TotalResultsHandler
        extends XmlParser.ElementHandler {
            private TotalResultsHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseFeed.this.feedState.totalResults != -1) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateTotalResults);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.logoValueRequired);
                }
                try {
                    BaseFeed.this.feedState.totalResults = Integer.valueOf(this.value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(CoreErrorDomain.ERR.totalResultsNotInteger);
                }
            }
        }
    }

    protected static class FeedState {
        public Service service;
        public boolean canPost = true;
        public int totalResults = -1;
        public int startIndex = -1;
        public int itemsPerPage = -1;
        public Kind.Adaptable adaptable = new Kind.AdaptableHelper();
        public String etag;
        public String kind;
        public String versionId;

        protected FeedState() {
        }
    }
}

