/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfigFactory;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationVisitor;
import com.google.firebase.perf.plugin.instrumentation.PerfInstrumentedAttribute;
import com.google.firebase.perf.plugin.instrumentation.exceptions.AlreadyPerfInstrumentedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;

public class Instrument {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private final InstrumentationConfig instrumentationConfig;

    public Instrument(ClassLoader classLoader) {
        this.instrumentationConfig = new InstrumentationConfigFactory(classLoader).newConfig();
    }

    public void instrumentClassFile(File inputFile, File outputFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(inputFile);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            logger.debug("instrumentClassFile() >> inputFile: '{}', outputFile: '{}'", (Object)inputFile, (Object)outputFile);
            fos.write(this.instrument(ByteStreams.toByteArray((InputStream)fis)));
        }
        catch (AlreadyPerfInstrumentedException e) {
            logger.error("Already instrumented class - {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Can't instrument because of {}. Copying as is.", (Object)e.getMessage());
            Files.copy((File)inputFile, (File)outputFile);
        }
    }

    /*
     * Exception decompiling
     */
    public void instrumentClassesInJar(File inputJar, File outputJar) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 29[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isInstrumentable(String name) {
        return !name.equals("android") && !name.startsWith("android/") && !name.startsWith("firebase/perf/") && !name.startsWith("com/google/firebase/") && !name.startsWith("com/google/firebase/perf/") && !name.startsWith("com/google/protobuf/") && !name.startsWith("com/google/android/apps/common/proguard/") && !name.startsWith("com/google/android/datatransport/") && !name.startsWith("com/google/android/gms/") && !name.startsWith("com/google/common") && !name.startsWith("okhttp3/") && !name.startsWith("okio/");
    }

    public byte[] instrument(byte[] in) {
        ClassReader cr = new ClassReader(in);
        FirebasePerfClassWriter cw = new FirebasePerfClassWriter(3);
        cr.accept((ClassVisitor)new InstrumentationVisitor((ClassVisitor)cw, this.instrumentationConfig), new Attribute[]{new PerfInstrumentedAttribute("")}, 4);
        return cw.toByteArray();
    }

    private class FirebasePerfClassWriter
    extends ClassWriter {
        public FirebasePerfClassWriter(int flags) {
            super(flags);
        }

        public FirebasePerfClassWriter(ClassReader classReader, int flags) {
            super(classReader, flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> class2;
            Class<?> class1;
            ClassLoader classLoader = Instrument.this.instrumentationConfig.getClassLoader();
            try {
                class1 = Class.forName(type1.replace('/', '.'), false, classLoader);
                class2 = Class.forName(type2.replace('/', '.'), false, classLoader);
            }
            catch (Throwable e) {
                logger.warn(e.toString());
                return "java/lang/Object";
            }
            if (class1.isAssignableFrom(class2)) {
                return type1;
            }
            if (class2.isAssignableFrom(class1)) {
                return type2;
            }
            if (class1.isInterface() || class2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
    }
}

