/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.GetMetadataNetworkRequest;
import org.json.JSONException;

class GetMetadataTask
implements Runnable {
    private static final String TAG = "GetMetadataTask";
    private StorageReference mStorageRef;
    private TaskCompletionSource<StorageMetadata> mPendingResult;
    private StorageMetadata mResultMetadata;
    private ExponentialBackoffSender mSender;

    GetMetadataTask(@NonNull StorageReference storageRef, @NonNull TaskCompletionSource<StorageMetadata> pendingResult) {
        Preconditions.checkNotNull((Object)storageRef);
        Preconditions.checkNotNull(pendingResult);
        this.mStorageRef = storageRef;
        this.mPendingResult = pendingResult;
        if (storageRef.getRoot().getName().equals(storageRef.getName())) {
            throw new IllegalArgumentException("getMetadata() is not supported at the root of the bucket.");
        }
        FirebaseStorage storage = this.mStorageRef.getStorage();
        this.mSender = new ExponentialBackoffSender(storage.getApp().getApplicationContext(), storage.getAuthProvider(), storage.getAppCheckProvider(), storage.getMaxDownloadRetryTimeMillis());
    }

    @Override
    public void run() {
        GetMetadataNetworkRequest request = new GetMetadataNetworkRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp());
        this.mSender.sendWithExponentialBackoff(request);
        if (request.isResultSuccess()) {
            try {
                this.mResultMetadata = new StorageMetadata.Builder(request.getResultBody(), this.mStorageRef).build();
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Unable to parse resulting metadata. " + request.getRawResult()), (Throwable)e);
                this.mPendingResult.setException((Exception)((Object)StorageException.fromException(e)));
                return;
            }
        }
        if (this.mPendingResult != null) {
            request.completeTask(this.mPendingResult, this.mResultMetadata);
        }
    }
}

