/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.inject.Provider;
import com.google.firebase.storage.FirebaseStorage;
import java.util.HashMap;
import java.util.Map;

class FirebaseStorageComponent {
    private final Map<String, FirebaseStorage> instances = new HashMap<String, FirebaseStorage>();
    private final FirebaseApp app;
    @Nullable
    private final Provider<InternalAuthProvider> authProvider;
    @Nullable
    private final Provider<InternalAppCheckTokenProvider> appCheckProvider;

    FirebaseStorageComponent(@NonNull FirebaseApp app, @Nullable Provider<InternalAuthProvider> authProvider, @Nullable Provider<InternalAppCheckTokenProvider> appCheckProvider) {
        this.app = app;
        this.authProvider = authProvider;
        this.appCheckProvider = appCheckProvider;
    }

    @NonNull
    synchronized FirebaseStorage get(@Nullable String bucketName) {
        FirebaseStorage storage = this.instances.get(bucketName);
        if (storage == null) {
            storage = new FirebaseStorage(bucketName, this.app, this.authProvider, this.appCheckProvider);
            this.instances.put(bucketName, storage);
        }
        return storage;
    }

    @VisibleForTesting
    synchronized void clearInstancesForTesting() {
        this.instances.clear();
    }
}

