/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.network;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.network.ResumableNetworkRequest;

public class ResumableUploadCancelRequest
extends ResumableNetworkRequest {
    @VisibleForTesting
    public static boolean CANCEL_CALLED = false;
    private final String uploadURL;

    public ResumableUploadCancelRequest(@NonNull Uri gsUri, @NonNull FirebaseApp app, @NonNull String uploadURL) {
        super(gsUri, app);
        CANCEL_CALLED = true;
        if (TextUtils.isEmpty((CharSequence)uploadURL)) {
            this.mException = new IllegalArgumentException("uploadURL is null or empty");
        }
        this.uploadURL = uploadURL;
        super.setCustomHeader("X-Goog-Upload-Protocol", "resumable");
        super.setCustomHeader("X-Goog-Upload-Command", "cancel");
    }

    @Override
    @NonNull
    protected String getAction() {
        return "POST";
    }

    @Override
    @NonNull
    protected String getURL() {
        return this.uploadURL;
    }
}

