/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.CancellationTokenSource;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask$$Lambda$1;
import com.google.firebase.storage.StorageTask$$Lambda$10;
import com.google.firebase.storage.StorageTask$$Lambda$11;
import com.google.firebase.storage.StorageTask$$Lambda$12;
import com.google.firebase.storage.StorageTask$$Lambda$13;
import com.google.firebase.storage.StorageTask$$Lambda$14;
import com.google.firebase.storage.StorageTask$$Lambda$15;
import com.google.firebase.storage.StorageTask$$Lambda$16;
import com.google.firebase.storage.StorageTask$$Lambda$17;
import com.google.firebase.storage.StorageTask$$Lambda$18;
import com.google.firebase.storage.StorageTask$$Lambda$4;
import com.google.firebase.storage.StorageTask$$Lambda$5;
import com.google.firebase.storage.StorageTask$$Lambda$6;
import com.google.firebase.storage.StorageTask$$Lambda$7;
import com.google.firebase.storage.StorageTask$$Lambda$8;
import com.google.firebase.storage.StorageTask$$Lambda$9;
import com.google.firebase.storage.StorageTaskManager;
import com.google.firebase.storage.TaskListenerImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

@PublicApi
public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final String TAG = "StorageTask";
    static final int INTERNAL_STATE_NOT_STARTED = 1;
    static final int INTERNAL_STATE_QUEUED = 2;
    static final int INTERNAL_STATE_IN_PROGRESS = 4;
    static final int INTERNAL_STATE_PAUSING = 8;
    static final int INTERNAL_STATE_PAUSED = 16;
    static final int INTERNAL_STATE_CANCELING = 32;
    static final int INTERNAL_STATE_FAILURE = 64;
    static final int INTERNAL_STATE_SUCCESS = 128;
    static final int INTERNAL_STATE_CANCELED = 256;
    static final int STATES_SUCCESS = 128;
    static final int STATES_PAUSED = 16;
    static final int STATES_FAILURE = 64;
    static final int STATES_CANCELED = 256;
    static final int STATES_COMPLETE = 448;
    static final int STATES_INPROGRESS = -465;
    private static final HashMap<Integer, HashSet<Integer>> ValidUserInitiatedStateChanges = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> ValidTaskInitiatedStateChanges = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    final TaskListenerImpl<OnSuccessListener<? super TResult>, TResult> successManager = new TaskListenerImpl(this, 128, StorageTask$$Lambda$1.lambdaFactory$(this));
    @VisibleForTesting
    final TaskListenerImpl<OnFailureListener, TResult> failureManager = new TaskListenerImpl(this, 64, StorageTask$$Lambda$4.lambdaFactory$(this));
    @VisibleForTesting
    final TaskListenerImpl<OnCompleteListener<TResult>, TResult> completeListener = new TaskListenerImpl(this, 448, StorageTask$$Lambda$5.lambdaFactory$(this));
    @VisibleForTesting
    final TaskListenerImpl<OnCanceledListener, TResult> cancelManager = new TaskListenerImpl(this, 256, StorageTask$$Lambda$6.lambdaFactory$(this));
    @VisibleForTesting
    final TaskListenerImpl<OnProgressListener<? super TResult>, TResult> progressManager = new TaskListenerImpl(this, -465, StorageTask$$Lambda$7.lambdaFactory$());
    @VisibleForTesting
    final TaskListenerImpl<OnPausedListener<? super TResult>, TResult> pausedManager = new TaskListenerImpl(this, 16, StorageTask$$Lambda$8.lambdaFactory$());
    private volatile int currentState = 1;
    private TResult finalResult;

    protected StorageTask() {
    }

    @VisibleForTesting
    boolean queue() {
        if (this.tryChangeState(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    @PublicApi
    public boolean resume() {
        if (this.tryChangeState(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    @PublicApi
    public boolean pause() {
        return this.tryChangeState(new int[]{16, 8}, true);
    }

    @Override
    @PublicApi
    public boolean cancel() {
        return this.tryChangeState(new int[]{256, 32}, true);
    }

    @PublicApi
    public boolean isComplete() {
        return (this.getInternalState() & 0x1C0) != 0;
    }

    @PublicApi
    public boolean isSuccessful() {
        return (this.getInternalState() & 0x80) != 0;
    }

    @Override
    @PublicApi
    public boolean isCanceled() {
        return this.getInternalState() == 256;
    }

    @Override
    @PublicApi
    public boolean isInProgress() {
        return (this.getInternalState() & 0xFFFFFE2F) != 0;
    }

    @Override
    @PublicApi
    public boolean isPaused() {
        return (this.getInternalState() & 0x10) != 0;
    }

    @PublicApi
    public TResult getResult() {
        if (this.getFinalResult() == null) {
            throw new IllegalStateException();
        }
        Exception t = this.getFinalResult().getError();
        if (t != null) {
            throw new RuntimeExecutionException((Throwable)t);
        }
        return this.getFinalResult();
    }

    @PublicApi
    public <X extends Throwable> TResult getResult(@NonNull Class<X> exceptionType) throws X {
        if (this.getFinalResult() == null) {
            throw new IllegalStateException();
        }
        if (exceptionType.isInstance(this.getFinalResult().getError())) {
            throw (Throwable)exceptionType.cast(this.getFinalResult().getError());
        }
        Exception t = this.getFinalResult().getError();
        if (t != null) {
            throw new RuntimeExecutionException((Throwable)t);
        }
        return this.getFinalResult();
    }

    @Nullable
    @PublicApi
    public Exception getException() {
        if (this.getFinalResult() == null) {
            return null;
        }
        return this.getFinalResult().getError();
    }

    @PublicApi
    public TResult getSnapshot() {
        return this.snapState();
    }

    @VisibleForTesting
    int getInternalState() {
        return this.currentState;
    }

    @VisibleForTesting
    Object getSyncObject() {
        return this.mSyncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    TResult snapState() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.snapStateImpl();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult snapStateImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean tryChangeState(int[] requestedStates, boolean userInitiated) {
        HashMap<Integer, HashSet<Integer>> table = userInitiated ? ValidUserInitiatedStateChanges : ValidTaskInitiatedStateChanges;
        Object object = this.mSyncObject;
        synchronized (object) {
            for (int newState : requestedStates) {
                HashSet<Integer> validStates = table.get(this.getInternalState());
                if (validStates == null || !validStates.contains(newState)) continue;
                this.currentState = newState;
                switch (this.currentState) {
                    case 2: {
                        StorageTaskManager.getInstance().ensureRegistered(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.successManager.onInternalStateChanged();
                this.failureManager.onInternalStateChanged();
                this.cancelManager.onInternalStateChanged();
                this.completeListener.onInternalStateChanged();
                this.pausedManager.onInternalStateChanged();
                this.progressManager.onInternalStateChanged();
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("changed internal state to: " + this.getStateString(newState) + " isUser: " + userInitiated + " from state:" + this.getStateString(this.currentState)));
                }
                return true;
            }
            Log.w((String)TAG, (String)("unable to change internal state to: " + this.getStateString(requestedStates) + " isUser: " + userInitiated + " from state:" + this.getStateString(this.currentState)));
            return false;
        }
    }

    @VisibleForTesting
    boolean tryChangeState(int newState, boolean userInitiated) {
        return this.tryChangeState(new int[]{newState}, userInitiated);
    }

    @PublicApi
    protected void onQueued() {
    }

    @PublicApi
    protected void onProgress() {
    }

    @PublicApi
    protected void onPaused() {
    }

    @PublicApi
    protected void onFailure() {
    }

    @PublicApi
    protected void onSuccess() {
    }

    @PublicApi
    protected void onCanceled() {
    }

    private TResult getFinalResult() {
        if (this.finalResult != null) {
            return this.finalResult;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.finalResult == null) {
            this.finalResult = this.snapState();
        }
        return this.finalResult;
    }

    @Override
    @PublicApi
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.pausedManager.addListener(null, null, listener);
        return this;
    }

    @Override
    @PublicApi
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)executor);
        this.pausedManager.addListener(null, executor, listener);
        return this;
    }

    @Override
    @PublicApi
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)activity);
        this.pausedManager.addListener(activity, null, listener);
        return this;
    }

    @PublicApi
    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.pausedManager.removeListener(listener);
        return this;
    }

    @Override
    @PublicApi
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.progressManager.addListener(null, null, listener);
        return this;
    }

    @Override
    @PublicApi
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)executor);
        this.progressManager.addListener(null, executor, listener);
        return this;
    }

    @Override
    @PublicApi
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)activity);
        this.progressManager.addListener(activity, null, listener);
        return this;
    }

    @PublicApi
    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.progressManager.removeListener(listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.successManager.addListener(null, null, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> listener) {
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull(listener);
        this.successManager.addListener(null, executor, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> listener) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull(listener);
        this.successManager.addListener(activity, null, listener);
        return this;
    }

    @PublicApi
    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.successManager.removeListener(listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.failureManager.addListener(null, null, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener listener) {
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)executor);
        this.failureManager.addListener(null, executor, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener listener) {
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)activity);
        this.failureManager.addListener(activity, null, listener);
        return this;
    }

    @PublicApi
    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.failureManager.removeListener(listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.completeListener.addListener(null, null, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)executor);
        this.completeListener.addListener(null, executor, listener);
        return this;
    }

    @PublicApi
    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> listener) {
        Preconditions.checkNotNull(listener);
        this.completeListener.removeListener(listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)activity);
        this.completeListener.addListener(activity, null, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnCanceledListener(@NonNull OnCanceledListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.cancelManager.addListener(null, null, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnCanceledListener(@NonNull Executor executor, @NonNull OnCanceledListener listener) {
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)executor);
        this.cancelManager.addListener(null, executor, listener);
        return this;
    }

    @NonNull
    @PublicApi
    public StorageTask<TResult> addOnCanceledListener(@NonNull Activity activity, @NonNull OnCanceledListener listener) {
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)activity);
        this.cancelManager.addListener(activity, null, listener);
        return this;
    }

    @PublicApi
    public StorageTask<TResult> removeOnCanceledListener(@NonNull OnCanceledListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.cancelManager.removeListener(listener);
        return this;
    }

    @NonNull
    @PublicApi
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWithImpl(null, continuation);
    }

    @NonNull
    @PublicApi
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWithImpl(executor, continuation);
    }

    @NonNull
    private <TContinuationResult> Task<TContinuationResult> continueWithImpl(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource source = new TaskCompletionSource();
        this.completeListener.addListener(null, executor, StorageTask$$Lambda$9.lambdaFactory$(this, continuation, source));
        return source.getTask();
    }

    @NonNull
    @PublicApi
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTaskImpl(null, continuation);
    }

    @NonNull
    @PublicApi
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTaskImpl(executor, continuation);
    }

    @NonNull
    @PublicApi
    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull SuccessContinuation<TResult, TContinuationResult> continuation) {
        return this.successTaskImpl(null, continuation);
    }

    @NonNull
    @PublicApi
    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull Executor executor, @NonNull SuccessContinuation<TResult, TContinuationResult> continuation) {
        return this.successTaskImpl(executor, continuation);
    }

    @NonNull
    private <TContinuationResult> Task<TContinuationResult> continueWithTaskImpl(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.getToken();
        TaskCompletionSource source = new TaskCompletionSource(cancellationToken);
        this.completeListener.addListener(null, executor, StorageTask$$Lambda$10.lambdaFactory$(this, continuation, source, cancellationTokenSource));
        return source.getTask();
    }

    @NonNull
    private <TContinuationResult> Task<TContinuationResult> successTaskImpl(@Nullable Executor executor, @NonNull SuccessContinuation<TResult, TContinuationResult> continuation) {
        CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.getToken();
        TaskCompletionSource source = new TaskCompletionSource(cancellationToken);
        this.successManager.addListener(null, executor, StorageTask$$Lambda$11.lambdaFactory$(continuation, source, cancellationTokenSource));
        return source.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    Runnable getRunnable() {
        return StorageTask$$Lambda$12.lambdaFactory$(this);
    }

    private void ensureFinalState() {
        if (!(this.isComplete() || this.isPaused() || this.getInternalState() == 2 || this.tryChangeState(256, false))) {
            this.tryChangeState(64, false);
        }
    }

    private String getStateString(int[] states) {
        if (states.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int state : states) {
            builder.append(this.getStateString(state)).append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    private String getStateString(int state) {
        switch (state) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void lambda$getRunnable$7(StorageTask this_) {
        try {
            this_.run();
        }
        finally {
            this_.ensureFinalState();
        }
    }

    static /* synthetic */ void lambda$successTaskImpl$6(SuccessContinuation continuation, TaskCompletionSource source, CancellationTokenSource cancellationTokenSource, ProvideError result) {
        Task resultTask;
        try {
            resultTask = continuation.then((Object)result);
        }
        catch (RuntimeExecutionException e) {
            if (e.getCause() instanceof Exception) {
                source.setException((Exception)e.getCause());
            } else {
                source.setException((Exception)((Object)e));
            }
            return;
        }
        catch (Exception e) {
            source.setException(e);
            return;
        }
        TaskCompletionSource taskCompletionSource = source;
        taskCompletionSource.getClass();
        resultTask.addOnSuccessListener(StorageTask$$Lambda$13.lambdaFactory$(taskCompletionSource));
        TaskCompletionSource taskCompletionSource2 = source;
        taskCompletionSource2.getClass();
        resultTask.addOnFailureListener(StorageTask$$Lambda$14.lambdaFactory$(taskCompletionSource2));
        CancellationTokenSource cancellationTokenSource2 = cancellationTokenSource;
        cancellationTokenSource2.getClass();
        resultTask.addOnCanceledListener(StorageTask$$Lambda$15.lambdaFactory$(cancellationTokenSource2));
    }

    static /* synthetic */ void lambda$continueWithTaskImpl$5(StorageTask this_, Continuation continuation, TaskCompletionSource source, CancellationTokenSource cancellationTokenSource, Task task) {
        Task resultTask;
        try {
            resultTask = (Task)continuation.then((Task)this_);
        }
        catch (RuntimeExecutionException e) {
            if (e.getCause() instanceof Exception) {
                source.setException((Exception)e.getCause());
            } else {
                source.setException((Exception)((Object)e));
            }
            return;
        }
        catch (Exception e) {
            source.setException(e);
            return;
        }
        if (!source.getTask().isComplete()) {
            if (resultTask == null) {
                source.setException((Exception)new NullPointerException("Continuation returned null"));
                return;
            }
            TaskCompletionSource taskCompletionSource = source;
            taskCompletionSource.getClass();
            resultTask.addOnSuccessListener(StorageTask$$Lambda$16.lambdaFactory$(taskCompletionSource));
            TaskCompletionSource taskCompletionSource2 = source;
            taskCompletionSource2.getClass();
            resultTask.addOnFailureListener(StorageTask$$Lambda$17.lambdaFactory$(taskCompletionSource2));
            CancellationTokenSource cancellationTokenSource2 = cancellationTokenSource;
            cancellationTokenSource2.getClass();
            resultTask.addOnCanceledListener(StorageTask$$Lambda$18.lambdaFactory$(cancellationTokenSource2));
        }
    }

    static /* synthetic */ void lambda$continueWithImpl$4(StorageTask this_, Continuation continuation, TaskCompletionSource source, Task task) {
        Object result;
        try {
            result = continuation.then((Task)this_);
        }
        catch (RuntimeExecutionException e) {
            if (e.getCause() instanceof Exception) {
                source.setException((Exception)e.getCause());
            } else {
                source.setException((Exception)((Object)e));
            }
            return;
        }
        catch (Exception e) {
            source.setException(e);
            return;
        }
        if (!source.getTask().isComplete()) {
            source.setResult(result);
        }
    }

    static /* synthetic */ void lambda$new$3(StorageTask this_, OnCanceledListener listener, ProvideError snappedState) {
        StorageTaskManager.getInstance().unRegister(this_);
        listener.onCanceled();
    }

    static /* synthetic */ void lambda$new$2(StorageTask this_, OnCompleteListener listener, ProvideError snappedState) {
        StorageTaskManager.getInstance().unRegister(this_);
        listener.onComplete((Task)this_);
    }

    static /* synthetic */ void lambda$new$1(StorageTask this_, OnFailureListener listener, ProvideError snappedState) {
        StorageTaskManager.getInstance().unRegister(this_);
        listener.onFailure(snappedState.getError());
    }

    static /* synthetic */ void lambda$new$0(StorageTask this_, OnSuccessListener listener, ProvideError snappedState) {
        StorageTaskManager.getInstance().unRegister(this_);
        listener.onSuccess((Object)snappedState);
    }

    static {
        ValidUserInitiatedStateChanges.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        ValidUserInitiatedStateChanges.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        ValidUserInitiatedStateChanges.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        ValidUserInitiatedStateChanges.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        ValidUserInitiatedStateChanges.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        ValidTaskInitiatedStateChanges.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        ValidTaskInitiatedStateChanges.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        ValidTaskInitiatedStateChanges.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        ValidTaskInitiatedStateChanges.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        ValidTaskInitiatedStateChanges.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    @PublicApi
    public class SnapshotBase
    implements ProvideError {
        private final Exception error;

        @PublicApi
        public SnapshotBase(Exception error) {
            this.error = error == null ? (StorageTask.this.isCanceled() ? StorageException.fromErrorStatus(Status.RESULT_CANCELED) : (StorageTask.this.getInternalState() == 64 ? StorageException.fromErrorStatus(Status.RESULT_INTERNAL_ERROR) : null)) : error;
        }

        @NonNull
        @PublicApi
        public StorageTask<TResult> getTask() {
            return StorageTask.this;
        }

        @NonNull
        @PublicApi
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        @PublicApi
        public Exception getError() {
            return this.error;
        }
    }

    protected static interface ProvideError {
        public Exception getError();
    }
}

