/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.GetMetadataNetworkRequest;
import org.json.JSONException;

@PublicApi
class GetMetadataTask
implements Runnable {
    private static final String TAG = "GetMetadataTask";
    private StorageReference mStorageRef;
    private TaskCompletionSource<StorageMetadata> mPendingResult;
    private StorageMetadata mResultMetadata;
    private ExponentialBackoffSender mSender;

    GetMetadataTask(@NonNull StorageReference storageRef, @NonNull TaskCompletionSource<StorageMetadata> pendingResult) {
        Preconditions.checkNotNull((Object)storageRef);
        Preconditions.checkNotNull(pendingResult);
        this.mStorageRef = storageRef;
        this.mPendingResult = pendingResult;
        this.mSender = new ExponentialBackoffSender(this.mStorageRef.getApp(), this.mStorageRef.getStorage().getMaxOperationRetryTimeMillis());
    }

    @Override
    @PublicApi
    public void run() {
        GetMetadataNetworkRequest request = new GetMetadataNetworkRequest(this.mStorageRef.getStorageUri(), this.mStorageRef.getApp());
        this.mSender.sendWithExponentialBackoff(request);
        if (request.isResultSuccess()) {
            try {
                this.mResultMetadata = new StorageMetadata.Builder(request.getResultBody(), this.mStorageRef).build();
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Unable to parse resulting metadata. " + request.getRawResult()), (Throwable)e);
                this.mPendingResult.setException((Exception)((Object)StorageException.fromException(e)));
                return;
            }
        }
        if (this.mPendingResult != null) {
            request.completeTask(this.mPendingResult, this.mResultMetadata);
        }
    }
}

