/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.Util;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

@PublicApi
public class FirebaseStorage {
    private static final String TAG = "FirebaseStorage";
    private static final Map<String, Map<String, FirebaseStorage>> mStorageMap = new HashMap<String, Map<String, FirebaseStorage>>();
    private static final String STORAGE_URI_PARSE_EXCEPTION = "The storage Uri could not be parsed.";
    private static final String STORAGE_BUCKET_WITH_PATH_EXCEPTION = "The storage Uri cannot contain a path element.";
    @NonNull
    private final FirebaseApp mApp;
    @Nullable
    private final String mBucketName;
    private long sMaxUploadRetry = 600000L;
    private long sMaxDownloadRetry = 600000L;
    private long sMaxQueryRetry = 120000L;

    private FirebaseStorage(@Nullable String bucketName, @NonNull FirebaseApp app) {
        this.mBucketName = bucketName;
        this.mApp = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FirebaseStorage getInstanceImpl(@NonNull FirebaseApp app, @Nullable Uri url) {
        String bucketName;
        String string = bucketName = url != null ? url.getHost() : null;
        if (url != null && !TextUtils.isEmpty((CharSequence)url.getPath())) {
            throw new IllegalArgumentException(STORAGE_BUCKET_WITH_PATH_EXCEPTION);
        }
        Map<String, Map<String, FirebaseStorage>> map = mStorageMap;
        synchronized (map) {
            FirebaseStorage storage;
            Map<String, FirebaseStorage> storageBuckets = mStorageMap.get(app.getName());
            if (storageBuckets == null) {
                storageBuckets = new HashMap<String, FirebaseStorage>();
                mStorageMap.put(app.getName(), storageBuckets);
            }
            if ((storage = storageBuckets.get(bucketName)) == null) {
                storage = new FirebaseStorage(bucketName, app);
                storageBuckets.put(bucketName, storage);
            }
            return storage;
        }
    }

    @NonNull
    @PublicApi
    public static FirebaseStorage getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (app != null);
        return FirebaseStorage.getInstance(app);
    }

    @NonNull
    @PublicApi
    public static FirebaseStorage getInstance(@NonNull String url) {
        FirebaseApp app = FirebaseApp.getInstance();
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (app != null);
        return FirebaseStorage.getInstance(app, url);
    }

    @NonNull
    @PublicApi
    public static FirebaseStorage getInstance(@NonNull FirebaseApp app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        String storageBucket = app.getOptions().getStorageBucket();
        if (storageBucket == null) {
            return FirebaseStorage.getInstanceImpl(app, null);
        }
        try {
            return FirebaseStorage.getInstanceImpl(app, Util.normalize(app, "gs://" + app.getOptions().getStorageBucket()));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Unable to parse bucket:" + storageBucket), (Throwable)e);
            throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
        }
    }

    @NonNull
    @PublicApi
    public static FirebaseStorage getInstance(@NonNull FirebaseApp app, @NonNull String url) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        if (!url.toLowerCase().startsWith("gs://")) {
            throw new IllegalArgumentException("Please use a gs:// URL for your Firebase Storage bucket.");
        }
        try {
            return FirebaseStorage.getInstanceImpl(app, Util.normalize(app, url));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Unable to parse url:" + url), (Throwable)e);
            throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearInstancesForTest() {
        Map<String, Map<String, FirebaseStorage>> map = mStorageMap;
        synchronized (map) {
            mStorageMap.clear();
        }
    }

    @PublicApi
    public long getMaxDownloadRetryTimeMillis() {
        return this.sMaxDownloadRetry;
    }

    @PublicApi
    public void setMaxDownloadRetryTimeMillis(long maxTransferRetryMillis) {
        this.sMaxDownloadRetry = maxTransferRetryMillis;
    }

    @PublicApi
    public long getMaxUploadRetryTimeMillis() {
        return this.sMaxUploadRetry;
    }

    @PublicApi
    public void setMaxUploadRetryTimeMillis(long maxTransferRetryMillis) {
        this.sMaxUploadRetry = maxTransferRetryMillis;
    }

    @PublicApi
    public long getMaxOperationRetryTimeMillis() {
        return this.sMaxQueryRetry;
    }

    @PublicApi
    public void setMaxOperationRetryTimeMillis(long maxTransferRetryMillis) {
        this.sMaxQueryRetry = maxTransferRetryMillis;
    }

    @Nullable
    private String getBucketName() {
        return this.mBucketName;
    }

    @PublicApi
    @NonNull
    public StorageReference getReference() {
        String bucketName = this.getBucketName();
        if (TextUtils.isEmpty((CharSequence)bucketName)) {
            throw new IllegalStateException("FirebaseApp was not initialized with a bucket name.");
        }
        Uri uri = new Uri.Builder().scheme("gs").authority(this.getBucketName()).path("/").build();
        return this.getReference(uri);
    }

    @NonNull
    @PublicApi
    public StorageReference getReferenceFromUrl(@NonNull String fullUrl) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)fullUrl) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String lowerCaseLocation = fullUrl.toLowerCase();
        if (lowerCaseLocation.startsWith("gs://") || lowerCaseLocation.startsWith("https://") || lowerCaseLocation.startsWith("http://")) {
            try {
                Uri uri = Util.normalize(this.mApp, fullUrl);
                if (uri == null) {
                    throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
                }
                return this.getReference(uri);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)("Unable to parse location:" + fullUrl), (Throwable)e);
                throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
            }
        }
        throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
    }

    @NonNull
    @PublicApi
    public StorageReference getReference(@NonNull String location) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)location) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String lowerCaseLocation = location.toLowerCase();
        if (lowerCaseLocation.startsWith("gs://") || lowerCaseLocation.startsWith("https://") || lowerCaseLocation.startsWith("http://")) {
            throw new IllegalArgumentException("location should not be a full URL.");
        }
        return this.getReference().child(location);
    }

    @NonNull
    private StorageReference getReference(@NonNull Uri uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri must not be null");
        String bucketName = this.getBucketName();
        Preconditions.checkArgument((TextUtils.isEmpty((CharSequence)bucketName) || uri.getAuthority().equalsIgnoreCase(bucketName) ? 1 : 0) != 0, (Object)"The supplied bucketname does not match the storage bucket of the current instance.");
        return new StorageReference(uri, this);
    }

    @NonNull
    @PublicApi
    public FirebaseApp getApp() {
        return this.mApp;
    }
}

