/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.sessions.SessionLifecycleService;
import com.google.firebase.sessions.SessionLifecycleServiceBinder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleServiceBinderImpl;", "Lcom/google/firebase/sessions/SessionLifecycleServiceBinder;", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "(Lcom/google/firebase/FirebaseApp;)V", "bindToService", "", "callback", "Landroid/os/Messenger;", "serviceConnection", "Landroid/content/ServiceConnection;", "unbindServiceSafely", "", "appContext", "Landroid/content/Context;", "Companion", "com.google.firebase-firebase-sessions"})
public final class SessionLifecycleServiceBinderImpl
implements SessionLifecycleServiceBinder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp firebaseApp;
    @Deprecated
    @NotNull
    public static final String TAG = "LifecycleServiceBinder";

    public SessionLifecycleServiceBinderImpl(@NotNull FirebaseApp firebaseApp) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        this.firebaseApp = firebaseApp;
    }

    @Override
    public void bindToService(@NotNull Messenger callback, @NotNull ServiceConnection serviceConnection2) {
        boolean bl;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)serviceConnection2, (String)"serviceConnection");
        Context context = this.firebaseApp.getApplicationContext().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"firebaseApp.applicationContext.applicationContext");
        Context appContext = context;
        Intent intent2 = intent = new Intent(appContext, SessionLifecycleService.class);
        boolean bl2 = false;
        Log.d((String)TAG, (String)"Binding service to application.");
        intent2.setAction(String.valueOf(Process.myPid()));
        intent2.putExtra("ClientCallbackMessenger", (Parcelable)callback);
        intent2.setPackage(appContext.getPackageName());
        try {
            bl = appContext.bindService(intent2, serviceConnection2, 65);
        }
        catch (SecurityException ex) {
            Log.w((String)TAG, (String)"Failed to bind session lifecycle service to application.", (Throwable)ex);
            bl = false;
        }
        boolean isServiceBound = bl;
        if (!isServiceBound) {
            this.unbindServiceSafely(appContext, serviceConnection2);
            Log.i((String)TAG, (String)"Session lifecycle service binding failed.");
        }
    }

    private final Object unbindServiceSafely(Context appContext, ServiceConnection serviceConnection2) {
        Object object;
        try {
            appContext.unbindService(serviceConnection2);
            object = Unit.INSTANCE;
        }
        catch (IllegalArgumentException ex) {
            object = Log.w((String)TAG, (String)"Session lifecycle service binding failed.", (Throwable)ex);
        }
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleServiceBinderImpl$Companion;", "", "()V", "TAG", "", "com.google.firebase-firebase-sessions"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

